/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.SBlockEntities.ContainerBlockEntity;
import com.Harbinger.Spore.SBlockEntities.LivingStructureBlocks;
import com.Harbinger.Spore.Sentities.AI.HurtTargetGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.FoliageSpread;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import com.Harbinger.Spore.Sentities.Signal;
import com.Harbinger.Spore.Sentities.Utility.InfectionTendril;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Sparticles;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class Mound
extends Organoid
implements FoliageSpread {
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.defineId(Mound.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> COUNTER = SynchedEntityData.defineId(Mound.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MAX_AGE = SynchedEntityData.defineId(Mound.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> STRUCTURE = SynchedEntityData.defineId(Mound.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> LINKED = SynchedEntityData.defineId(Mound.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final int maxCounter;
    private int attackCooldown;
    private static final int AGE_INCREMENT_INTERVAL = 20;
    private static final int ATTACK_CLOUD_DURATION = 300;
    private static final int ATTACK_CLOUD_COOLDOWN = 300;
    private static final int MYCELIUM_EFFECT_DURATION = 600;
    private static final int MAX_TENDRILS = 4;
    private static final float STRUCTURE_PLACEMENT_CHANCE = 0.1f;
    private static final double MIN_STRUCTURE_DISTANCE_SQ = 80.0;

    public Mound(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.maxCounter = (Integer)SConfig.SERVER.mound_cooldown.get();
        this.attackCooldown = 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.mound_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.mound_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        EntityDimensions baseDimensions = super.getDefaultDimensions(pose);
        return baseDimensions.scale(Math.max(1.0f, (float)this.getAge()));
    }

    protected int calculateFallDamage(float fallDistance, float damageMultiplier) {
        return Math.max(0, super.calculateFallDamage(fallDistance, damageMultiplier) - 30);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return this.getLinked() && this.getMaxAge() <= 2;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.mound_loot.get();
    }

    @Override
    public int getEmerge_tick() {
        return 40;
    }

    @Override
    public boolean isCloseCombatant() {
        return true;
    }

    public int getAge() {
        return (Integer)this.entityData.get(AGE);
    }

    public void setAge(int age) {
        this.entityData.set(AGE, (Object)age);
    }

    public int getCounter() {
        return (Integer)this.entityData.get(COUNTER);
    }

    public void setCounter(int counter) {
        this.entityData.set(COUNTER, (Object)counter);
    }

    public int getMaxAge() {
        return (Integer)this.entityData.get(MAX_AGE);
    }

    public void setMaxAge(int maxAge) {
        this.entityData.set(MAX_AGE, (Object)maxAge);
    }

    public boolean getLinked() {
        return (Boolean)this.entityData.get(LINKED);
    }

    public void setLinked(boolean linked) {
        this.entityData.set(LINKED, (Object)linked);
    }

    public int getAgeCounter() {
        return this.getPersistentData().getInt("age");
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount % 20 == 0) {
            this.handleAgeIncrement();
            this.handleInfectionSpread();
            this.handleParticleEffects();
        }
        if (this.isAlive() && this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    private void handleAgeIncrement() {
        if (this.isAlive() && this.getAge() < this.getMaxAge()) {
            int currentAgeCounter = this.getAgeCounter() + 1;
            this.getPersistentData().putInt("age", currentAgeCounter);
            if (currentAgeCounter >= (Integer)SConfig.SERVER.mound_age.get()) {
                this.getPersistentData().putInt("age", 0);
                this.setAge(this.getAge() + 1);
            }
        }
    }

    private void handleInfectionSpread() {
        if (this.getCounter() < this.maxCounter) {
            this.setCounter(this.getCounter() + 1);
        }
        if (this.isAlive() && this.getCounter() >= this.maxCounter && !this.level().isClientSide) {
            double range = this.getInfectionRange();
            this.SpreadInfection(this.level(), range, this.getOnPos());
            this.setCounter(0);
            if (this.random.nextInt(10) == 0 && this.getAge() >= 3 && this.canSpawnTendrils()) {
                this.spawnTendril();
            }
        }
    }

    private double getInfectionRange() {
        return switch (this.getAge()) {
            case 2 -> (Double)SConfig.SERVER.mound_range_age2.get();
            case 3 -> (Double)SConfig.SERVER.mound_range_age3.get();
            case 4 -> (Double)SConfig.SERVER.mound_range_age4.get();
            default -> (Double)SConfig.SERVER.mound_range_default.get();
        };
    }

    private void handleParticleEffects() {
        Level level;
        if (this.getCounter() > this.maxCounter - 2 && this.getCounter() < this.maxCounter && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnPuffParticles(serverLevel);
        }
        if (this.getCounter() == this.maxCounter - 2) {
            this.playSound(Ssounds.PUFF.get());
        }
    }

    private void spawnPuffParticles(ServerLevel serverLevel) {
        double x = this.getX() + ((double)this.random.nextFloat() - 0.2) * 0.2;
        double y = this.getY() + ((double)this.random.nextFloat() - 0.5) * 5.0;
        double z = this.getZ() + ((double)this.random.nextFloat() - 0.2) * 0.2;
        serverLevel.sendParticles((ParticleOptions)Sparticles.SPORE_PARTICLE.get(), x, y, z, 9, 0.0, 0.0, 0.0, 1.0);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.attackCooldown == 0) {
            this.spawnDefensiveCloud();
            this.attackCooldown = 300;
        }
        return super.hurt(source, amount);
    }

    private void spawnDefensiveCloud() {
        if (!this.level().isClientSide) {
            AreaEffectCloud cloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
            cloud.setOwner((LivingEntity)this);
            cloud.setRadius(2.0f);
            cloud.setDuration(300);
            cloud.setRadiusPerTick((1.5f * (float)this.getAge() - cloud.getRadius()) / (float)cloud.getDuration());
            cloud.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 200, 1));
            this.level().addFreshEntity((Entity)cloud);
            this.playSound(Ssounds.PUFF.get(), 0.5f, 0.5f);
        }
    }

    public void die(DamageSource source) {
        if (this.getLinked() && this.getAge() > 3 && source.getEntity() != null && !this.isFrozen()) {
            this.alertNearbyProtos(source);
        }
        for (int i = 0; i <= this.getAge(); ++i) {
            super.die(source);
        }
    }

    private boolean isFrozen() {
        return this.isInPowderSnow || this.Cold() || this.getLastDamageSource() != null && this.getLastDamageSource().is(DamageTypes.FREEZE);
    }

    private void alertNearbyProtos(DamageSource source) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            List<Proto> protos = SporeSavedData.getHiveminds(serverLevel);
            if (protos.isEmpty()) {
                return;
            }
            for (Proto proto : protos) {
                if (!(proto.distanceTo((Entity)this) <= (float)((Integer)SConfig.SERVER.proto_range.get()).intValue())) continue;
                int y = source.getDirectEntity() != null ? (int)source.getDirectEntity().getY() : (int)this.getY();
                BlockPos relativePos = new BlockPos(this.getOnPos().getX(), y, this.getOnPos().getZ());
                proto.setSignal(new Signal(true, relativePos));
                break;
            }
        }
    }

    private boolean canSpawnTendrils() {
        AABB searchBox = this.getBoundingBox().inflate((double)((Integer)SConfig.SERVER.mound_tendril_checker.get()).intValue());
        List existingTendrils = this.level().getEntitiesOfClass(InfectionTendril.class, searchBox);
        return existingTendrils.size() <= 4;
    }

    private void spawnTendril() {
        AABB searchBox = this.getBoundingBox().inflate((double)((Integer)SConfig.SERVER.mound_tendril_checker.get()).intValue());
        for (BlockPos pos : BlockPos.betweenClosed((int)Mth.floor((double)searchBox.minX), (int)Mth.floor((double)searchBox.minY), (int)Mth.floor((double)searchBox.minZ), (int)Mth.floor((double)searchBox.maxX), (int)Mth.floor((double)searchBox.maxY), (int)Mth.floor((double)searchBox.maxZ))) {
            BlockState blockState;
            if (!this.isValidTendrilTarget(pos, blockState = this.level().getBlockState(pos))) continue;
            InfectionTendril tendril = new InfectionTendril(Sentities.TENDRIL.get(), this.level());
            tendril.setAgeM(this.getMaxAge() - 1);
            tendril.setSearchArea(pos);
            tendril.setPos(this.getX(), this.getY() + 0.5, this.getZ());
            this.level().addFreshEntity((Entity)tendril);
            break;
        }
    }

    private boolean isValidTendrilTarget(BlockPos pos, BlockState state) {
        return this.isStructureBlock(pos) || this.isChestWithFood(pos) && (Boolean)SConfig.SERVER.tendril_chest.get() != false || state.is((Block)Sblocks.REMAINS.get()) && (Boolean)SConfig.SERVER.tendril_corpse.get() != false || state.is(Blocks.SPAWNER) && (Boolean)SConfig.SERVER.tendril_spawner.get() != false;
    }

    private boolean isChestWithFood(BlockPos pos) {
        Container container;
        BlockEntity blockEntity = this.level().getBlockEntity(pos);
        return blockEntity instanceof Container && !((container = (Container)blockEntity) instanceof ContainerBlockEntity) && container.hasAnyMatching(item -> item.getFoodProperties((LivingEntity)this) != null);
    }

    private boolean isStructureBlock(BlockPos pos) {
        BlockEntity blockEntity = this.level().getBlockEntity(pos);
        return blockEntity instanceof LivingStructureBlocks;
    }

    @Override
    public void additionPlacers(Level level, BlockPos pos, double range) {
        AABB area = this.getBoundingBox().inflate(range);
        for (BlockPos blockPos : BlockPos.betweenClosed((int)Mth.floor((double)area.minX), (int)Mth.floor((double)area.minY), (int)Mth.floor((double)area.minZ), (int)Mth.floor((double)area.maxX), (int)Mth.floor((double)area.maxY), (int)Mth.floor((double)area.maxZ))) {
            if (!(this.random.nextFloat() < 0.1f) || !this.canPlaceStructure(level, blockPos) || !(this.distanceToSqr(blockPos.getX(), blockPos.getY(), blockPos.getZ()) > 80.0)) continue;
            this.placeStructureBlock(level, blockPos.above());
            this.entityData.set(STRUCTURE, (Object)false);
            break;
        }
    }

    @Override
    public void additionIgnoreConfigPlacers(Level level, BlockPos pos, double range) {
        AABB area = this.getBoundingBox().inflate(range);
        for (BlockPos blockPos : BlockPos.betweenClosed((int)Mth.floor((double)area.minX), (int)Mth.floor((double)area.minY), (int)Mth.floor((double)area.minZ), (int)Mth.floor((double)area.maxX), (int)Mth.floor((double)area.maxY), (int)Mth.floor((double)area.maxZ))) {
            if (!(this.random.nextFloat() < 0.1f) || !this.canPlaceStructure(level, blockPos) || !(this.distanceToSqr(blockPos.getX(), blockPos.getY(), blockPos.getZ()) > 80.0)) continue;
            this.placeStructureBlock(level, blockPos.above());
            this.entityData.set(STRUCTURE, (Object)false);
            break;
        }
        List entities = level.getEntitiesOfClass(LivingEntity.class, area);
        for (LivingEntity entity : entities) {
            if (!Utilities.TARGET_SELECTOR.Test(entity) || !Utilities.helmetList().contains(entity.getItemBySlot(EquipmentSlot.HEAD).getItem())) continue;
            entity.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 600, 1));
        }
    }

    private boolean canPlaceStructure(Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        BlockState aboveState = level.getBlockState(pos.above());
        return aboveState.isAir() && blockState.isSolidRender((BlockGetter)level, pos) && (Boolean)this.entityData.get(STRUCTURE) != false && this.getAge() >= this.getMaxAge();
    }

    private void placeStructureBlock(Level level, BlockPos pos) {
        List<Holder<Block>> structureBlocks = Utilities.tryToCreateBlockFromTag(level, ResourceLocation.parse((String)"spore:block_st"));
        if (!structureBlocks.isEmpty()) {
            BlockState blockState = ((Block)structureBlocks.get(this.random.nextInt(structureBlocks.size())).value()).defaultBlockState();
            level.setBlock(pos, blockState, 3);
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("age", this.getAge());
        tag.putInt("counter", this.getCounter());
        tag.putInt("max_age", this.getMaxAge());
        tag.putBoolean("structure", ((Boolean)this.entityData.get(STRUCTURE)).booleanValue());
        tag.putBoolean("linked", this.getLinked());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(AGE, (Object)tag.getInt("age"));
        this.entityData.set(COUNTER, (Object)tag.getInt("counter"));
        this.entityData.set(MAX_AGE, (Object)tag.getInt("max_age"));
        this.entityData.set(STRUCTURE, (Object)tag.getBoolean("structure"));
        this.entityData.set(LINKED, (Object)tag.getBoolean("linked"));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(AGE, (Object)1);
        builder.define(COUNTER, (Object)0);
        builder.define(MAX_AGE, (Object)4);
        builder.define(STRUCTURE, (Object)true);
        builder.define(LINKED, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        if (AGE.equals(dataAccessor)) {
            this.updateAttributes();
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(dataAccessor);
    }

    private void updateAttributes() {
        double health = (Double)SConfig.SERVER.mound_hp.get() * (double)this.getAge() * (Double)SConfig.SERVER.global_health.get();
        double armor = (Double)SConfig.SERVER.mound_armor.get() * (double)this.getAge() * (Double)SConfig.SERVER.global_armor.get();
        AttributeInstance healthAttr = this.getAttribute(Attributes.MAX_HEALTH);
        AttributeInstance armorAttr = this.getAttribute(Attributes.ARMOR);
        if (healthAttr != null) {
            healthAttr.setBaseValue(health);
        }
        if (armorAttr != null) {
            armorAttr.setBaseValue(armor);
        }
    }

    public void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new HurtTargetGoal((PathfinderMob)this, enemy -> !((List)SConfig.SERVER.blacklist.get()).contains(enemy.getEncodeId()) && !(enemy instanceof UtilityEntity), Infected.class).setAlertOthers(Infected.class));
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setDefaultLinkage((Level)level.getLevel());
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void setDefaultLinkage(Level level) {
        ServerLevel serverLevel;
        SporeSavedData data;
        if (level instanceof ServerLevel && (data = SporeSavedData.getDataLocation(serverLevel = (ServerLevel)level)) != null && data.getAmountOfHiveminds() >= (Integer)SConfig.SERVER.proto_spawn_world_mod.get()) {
            this.setLinked(true);
        }
    }
}

