/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.ExtremelySusThings.ChunkLoadRequest;
import com.Harbinger.Spore.ExtremelySusThings.ChunkLoaderHelper;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.NeuralProcessing.ProtoAIs.ProtoTargeting;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.CasingGenerator;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Scamper;
import com.Harbinger.Spore.Sentities.FoliageSpread;
import com.Harbinger.Spore.Sentities.Organoids.Mound;
import com.Harbinger.Spore.Sentities.Organoids.Verwa;
import com.Harbinger.Spore.Sentities.Organoids.Vigil;
import com.Harbinger.Spore.Sentities.Organoids.Womb;
import com.Harbinger.Spore.Sentities.Signal;
import com.Harbinger.Spore.Sentities.Utility.GastGeber;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class Proto
extends Organoid
implements CasingGenerator,
FoliageSpread {
    private static final EntityDataAccessor<Integer> HOSTS = SynchedEntityData.defineId(Proto.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BIOMASS = SynchedEntityData.defineId(Proto.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<BlockPos> NODE = SynchedEntityData.defineId(Proto.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private final List<String> hypers = new ArrayList<String>(){
        {
            this.add("spore:inquisitor");
            this.add("spore:wendigo");
            this.add("spore:hvindicator");
            this.add("spore:brot");
            this.add("spore:ogre");
            this.add("spore:hevoker");
        }
    };
    private int summonDefense = 0;
    private static final int INPUT_SIZE = 4;
    private static final int OUTPUT_SIZE = 4;
    private double[] weights;
    public List<String> team_1 = new ArrayList<String>();
    public List<String> team_2 = new ArrayList<String>();
    public List<String> team_3 = new ArrayList<String>();
    public List<String> team_4 = new ArrayList<String>();
    public List<String> team_5 = new ArrayList<String>();
    private final Random random = new Random();
    @Nullable
    public Signal signal;

    public Proto(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.setPersistenceRequired();
        this.initializeValues();
    }

    private void fillDefaultTeams(List<String> team, List<? extends String> CONFIG) {
        if (CONFIG.size() < 4) {
            throw new IllegalArgumentException("CONFIG must have at least 4 unique entries");
        }
        ArrayList<? extends String> shuffledConfig = new ArrayList<String>(CONFIG);
        Collections.shuffle(shuffledConfig, this.random);
        for (int i = 0; i < 4; ++i) {
            String config = (String)shuffledConfig.get(i);
            int add = this.isVariantKeeper(config);
            team.add(config + "_" + add);
        }
    }

    protected void initializeValues() {
        this.weights = new double[16];
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = this.getRandom().nextDouble();
        }
        this.fillDefaultTeams(this.team_1, (List)SConfig.SERVER.proto_summonable_troops.get());
        this.fillDefaultTeams(this.team_2, (List)SConfig.SERVER.proto_summonable_troops.get());
        this.fillDefaultTeams(this.team_3, (List)SConfig.SERVER.proto_summonable_troops.get());
        this.fillDefaultTeams(this.team_4, (List)SConfig.SERVER.proto_summonable_troops.get());
    }

    private int isVariantKeeper(String s) {
        int n;
        ResourceLocation location = ResourceLocation.parse((String)s);
        Entity entity = Utilities.tryToCreateEntity(location).create(this.level());
        if (entity instanceof VariantKeeper) {
            VariantKeeper keeper = (VariantKeeper)entity;
            n = this.getRandom().nextInt(keeper.amountOfMutations() - 1);
        } else {
            n = -1;
        }
        return n;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.proto_loot.get();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public double getWeightsValue(int i) {
        return this.weights[i];
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.proto_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.proto_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.proto_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.FOLLOW_RANGE, 128.0).add(Attributes.KNOCKBACK_RESISTANCE, 2.0);
    }

    protected void registerGoals() {
        this.addTargettingGoals();
        this.goalSelector.addGoal(3, (Goal)new ProtoTargeting(this));
        this.goalSelector.addGoal(4, (Goal)new AOEMeleeAttackGoal(this, 0.0, false, 2.5, 8.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    public boolean isNunny() {
        return Objects.equals(this.getCustomName(), Component.literal((String)"Nunny"));
    }

    private void generateCasing() {
        if (this.distanceToSqr(((BlockPos)this.entityData.get(NODE)).getX(), ((BlockPos)this.entityData.get(NODE)).getY(), ((BlockPos)this.entityData.get(NODE)).getZ()) > 100.0) {
            if (Math.random() < 0.1) {
                this.entityData.set(NODE, (Object)this.getOnPos());
            }
        } else if (this.getBiomass() > 40) {
            this.generateChasing((BlockPos)this.entityData.get(NODE), (Entity)this, 32, 2);
            this.generateChasing((BlockPos)this.entityData.get(NODE), (Entity)this, 16);
            this.eatBiomass(5);
        }
    }

    private void scanForHosts() {
        List entities = this.level().getEntities((Entity)this, this.seachbox(), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        this.entityData.set(HOSTS, (Object)0);
        for (Entity en : entities) {
            if (en instanceof Infected) {
                Infected infected = (Infected)en;
                if (!infected.getLinked()) {
                    infected.setLinked(true);
                }
                if (infected.getTarget() == null || infected.getY() < 0.0 || infected.getHealth() < infected.getMaxHealth() / 2.0f) {
                    if (!this.level().isClientSide && this.harvestBiomassByDespawning(infected)) {
                        this.setHosts(this.getHosts() + 1);
                    }
                } else {
                    this.setHosts(this.getHosts() + 1);
                }
            }
            if (en instanceof Mound) {
                Mound mound = (Mound)en;
                if (!mound.getLinked()) {
                    mound.setLinked(true);
                }
                this.setHosts(this.getHosts() + 1);
            }
            if (!((Boolean)SConfig.SERVER.proto_raid.get()).booleanValue() || !(Math.random() < (Double)SConfig.SERVER.proto_raid_chance.get() / 100.0) || !(en instanceof Player) && !((List)SConfig.SERVER.proto_sapient_target.get()).contains(en.getEncodeId())) continue;
            int x = this.random.nextInt(-30, 30);
            int z = this.random.nextInt(-30, 30);
            Vigil vigil = new Vigil((EntityType<? extends UtilityEntity>)Sentities.VIGIL.get(), this.level());
            vigil.randomTeleport(en.getX() + (double)x, en.getY(), en.getZ() + (double)z, false);
            vigil.setProto((Mob)this);
            vigil.setVariant(2);
            vigil.tickEmerging();
            this.level().addFreshEntity((Entity)vigil);
            break;
        }
    }

    public boolean harvestBiomassByDespawning(Infected living) {
        if (living instanceof GastGeber || living instanceof Scamper) {
            return true;
        }
        if (living.getKills() > 0) {
            this.addBiomass(living.getKills());
            living.setKills(0);
            return true;
        }
        if (living instanceof Hyper && Math.random() < 1.0E-4) {
            this.addBiomass(30);
            living.discard();
            return false;
        }
        if (living instanceof EvolvedInfected && Math.random() < 0.01) {
            this.addBiomass(15);
            living.discard();
            return false;
        }
        if (Math.random() < 0.2) {
            this.addBiomass(5);
            living.discard();
            return false;
        }
        return true;
    }

    private void griefBlocks() {
        if (this.getLastDamageSource() == this.damageSources().inWall() && EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
            AABB aabb = this.getBoundingBox().inflate(0.2, 0.0, 0.2);
            boolean flag = false;
            for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
                BlockState blockstate = this.level().getBlockState(blockpos);
                if (!(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) < 10.0f) || !(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) > 0.0f)) continue;
                flag = this.level().destroyBlock(blockpos, true, (Entity)this) || flag;
            }
        }
    }

    private boolean checkForScent() {
        AABB hitbox = this.getBoundingBox().inflate(3.0);
        List entities = this.level().getEntitiesOfClass(ScentEntity.class, hitbox);
        return entities.isEmpty();
    }

    private void SummonScent() {
        ScentEntity scent = new ScentEntity(Sentities.SCENT.get(), this.level());
        scent.setOvercharged(true);
        scent.moveTo(this.getX(), this.getY(), this.getZ());
        this.level().addFreshEntity((Entity)scent);
    }

    public void addBiomass(int e) {
        this.entityData.set(BIOMASS, (Object)((Integer)this.entityData.get(BIOMASS) + e));
    }

    public void eatBiomass(int e) {
        this.entityData.set(BIOMASS, (Object)((Integer)this.entityData.get(BIOMASS) - e));
    }

    public int getBiomass() {
        return (Integer)this.entityData.get(BIOMASS);
    }

    public AABB seachbox() {
        return this.getBoundingBox().inflate((double)((Integer)SConfig.SERVER.proto_range.get()).intValue());
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            LivingEntity target;
            if (this.tickCount % 6000 == 0 && ((Boolean)SConfig.SERVER.mound_foliage.get()).booleanValue() && this.entityData.get(NODE) != BlockPos.ZERO) {
                this.SpreadInfection(this.level(), (Double)SConfig.SERVER.mound_range_age4.get() * 2.0, (BlockPos)this.entityData.get(NODE));
                this.loadChunks();
            }
            if (this.tickCount % 200 == 0 && ((Boolean)SConfig.SERVER.proto_casing.get()).booleanValue()) {
                this.generateCasing();
            }
            if (this.tickCount % 1200 == 0) {
                this.scanForHosts();
                this.moraleBoost();
            }
            if (this.tickCount % 40 == 0) {
                this.griefBlocks();
                target = this.getTarget();
                if (target != null && this.checkForScent()) {
                    this.SummonScent();
                }
            }
            if (this.tickCount % 200 == 0) {
                this.addBiomass(1);
            }
            if (this.getSignal() != null && this.getSignal().active().booleanValue() && this.checkForCalamities(this.getSignal().pos())) {
                this.SummonConstructor(this.level(), (Entity)this, this.getSignal().pos());
            }
            if (this.tickCount % 3000 == 0 && ((Boolean)SConfig.SERVER.proto_madness.get()).booleanValue()) {
                this.giveMadness(this);
            }
            if (this.summonDefense > 0) {
                --this.summonDefense;
            }
            target = this.getTarget();
            if (this.tickCount % 200 == 0 && target != null) {
                BlockPos pos = target.getOnPos();
                if (this.checkForOrganoids((Entity)target) && this.getBiomass() > 2 && !this.level().isClientSide) {
                    int e = this.getRandom().nextInt(1, 5);
                    for (int o = 0; o < e; ++o) {
                        this.summonMob(this.decide(this.inputs(target)), pos);
                    }
                }
            }
        }
    }

    public double[] inputs(LivingEntity entity) {
        if (entity == null) {
            return new double[]{1.0, 1.0, 1.0, 1.0};
        }
        double distance = entity.distanceToSqr((Entity)this) < 200.0 ? 1.0 : 0.0;
        double isOnGround = entity.onGround() ? 1.0 : 0.0;
        double hasAllotOfHealth = entity.getMaxHealth() >= 20.0f ? 1.0 : 0.0;
        double hasAllotOfArmor = entity.getArmorValue() >= 20 ? 1.0 : 0.0;
        return new double[]{distance, isOnGround, hasAllotOfHealth, hasAllotOfArmor};
    }

    public Entity entityResourceLocation(int decision, List<String> string) {
        if (string.isEmpty()) {
            return null;
        }
        String[] id = string.get(decision).split("_");
        ResourceLocation location = ResourceLocation.parse((String)id[0]);
        int variant = Integer.parseInt(id[1]);
        Entity entity = Utilities.tryToCreateEntity(location).create(this.level());
        if (entity instanceof VariantKeeper) {
            VariantKeeper keeper = (VariantKeeper)entity;
            if (variant > 0) {
                keeper.setVariant(variant);
            }
        }
        return entity;
    }

    public List<String> getDecisionList(int decision) {
        return switch (decision) {
            case 0 -> this.team_1;
            case 1 -> this.team_2;
            case 2 -> this.team_3;
            case 3 -> this.team_4;
            default -> null;
        };
    }

    protected boolean checkForOrganoids(Entity entity) {
        AABB aabb = entity.getBoundingBox().inflate(12.0);
        List entities = this.level().getEntities((Entity)this, aabb, entity1 -> entity1 instanceof Organoid);
        return entities.size() <= 4;
    }

    private boolean checkTheGround(BlockPos pos, Level level) {
        for (int i = 0; i < 3; ++i) {
            BlockState state = level.getBlockState(pos.below(i));
            if (!(state.getDestroySpeed((BlockGetter)level, pos.below(i)) > 4.0f) && !state.isAir()) continue;
            return false;
        }
        return true;
    }

    private void summonMob(int decision, BlockPos pos) {
        Organoid organoid;
        if (pos.equals((Object)BlockPos.ZERO)) {
            return;
        }
        List<String> team = this.getDecisionList(decision);
        int i = this.getRandom().nextInt(team.size());
        BlockPos blockPos = pos;
        Entity summoned = this.entityResourceLocation(i, team);
        if (summoned instanceof Organoid) {
            organoid = (Organoid)summoned;
            blockPos = organoid.isCloseCombatant() ? pos : BlockPos.containing((Position)Utilities.generatePositionAway(new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), this.random.nextInt(8, 16)));
            organoid.tickEmerging();
        }
        if (summoned instanceof Vigil) {
            organoid = (Vigil)summoned;
            ((Vigil)organoid).setProto((Mob)this);
        }
        if (summoned instanceof Mound) {
            organoid = (Mound)summoned;
            ((Mound)organoid).setMaxAge(1);
        }
        if (summoned instanceof Verwa) {
            organoid = (Verwa)summoned;
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ((Verwa)organoid).finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(pos), MobSpawnType.SPAWNER, null);
            }
        }
        CompoundTag data = summoned.getPersistentData();
        data.putInt("hivemind", this.getId());
        data.putInt("decision", decision);
        data.putInt("member", decision);
        if (summoned instanceof LivingEntity) {
            LivingEntity mob = (LivingEntity)summoned;
            mob.randomTeleport((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), false);
        } else {
            summoned.teleportTo((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
        }
        if (this.checkTheGround(pos, summoned.level()) && summoned.position().distanceToSqr(0.0, 0.0, 0.0) > 10.0) {
            this.eatBiomass(2);
            this.level().addFreshEntity(summoned);
        }
    }

    public void moraleBoost() {
        int e = 0;
        for (double weight : this.weights) {
            if (!(weight < 0.0)) continue;
            ++e;
        }
        if (e > this.weights.length / 2) {
            for (int i = 0; i < this.weights.length; ++i) {
                this.weights[i] = this.weights[i] + this.getRandom().nextDouble();
            }
        }
    }

    protected void giveMadness(Proto proto) {
        AABB aabb = proto.getBoundingBox().inflate(128.0);
        List entities = this.level().getEntities((Entity)this, aabb);
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            if (!((List)SConfig.SERVER.proto_sapient_target.get()).contains(living.getEncodeId()) && !(living instanceof Player)) continue;
            living.addEffect(new MobEffectInstance(Seffects.MADNESS, 6000, 0, false, false));
        }
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.isOnFire() && !this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            this.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 200, 0));
        } else if (this.getLastDamageSource() == this.damageSources().freeze()) {
            this.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 400, 0));
        } else if (this.getHealth() < this.getMaxHealth() / 2.0f && !this.hasEffect(MobEffects.WEAKNESS) && !this.hasEffect(MobEffects.DAMAGE_RESISTANCE)) {
            this.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, 0));
        }
    }

    protected int calculateFallDamage(float p_149389_, float p_149390_) {
        return super.calculateFallDamage(p_149389_, p_149390_) - 60;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("biomass", ((Integer)this.entityData.get(BIOMASS)).intValue());
        tag.putInt("hosts", ((Integer)this.entityData.get(HOSTS)).intValue());
        tag.putInt("nodeX", ((BlockPos)this.entityData.get(NODE)).getX());
        tag.putInt("nodeY", ((BlockPos)this.entityData.get(NODE)).getY());
        tag.putInt("nodeZ", ((BlockPos)this.entityData.get(NODE)).getZ());
        ListTag weightsList = new ListTag();
        for (double weight : this.weights) {
            weightsList.add((Object)DoubleTag.valueOf((double)weight));
        }
        tag.put("weights", (Tag)weightsList);
        List<List<String>> teams = List.of(this.team_1, this.team_2, this.team_3, this.team_4, this.team_5);
        for (int i = 0; i < teams.size(); ++i) {
            ListTag teamTag = new ListTag();
            for (String member : teams.get(i)) {
                teamTag.add((Object)StringTag.valueOf((String)member));
            }
            tag.put("team_" + (i + 1), (Tag)teamTag);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(BIOMASS, (Object)tag.getInt("biomass"));
        this.entityData.set(HOSTS, (Object)tag.getInt("hosts"));
        int x = tag.getInt("nodeX");
        int y = tag.getInt("nodeY");
        int z = tag.getInt("nodeZ");
        this.entityData.set(NODE, (Object)new BlockPos(x, y, z));
        ListTag weightsList = tag.getList("weights", 6);
        this.weights = new double[weightsList.size()];
        for (int i = 0; i < weightsList.size(); ++i) {
            this.weights[i] = weightsList.getDouble(i);
        }
        this.team_1.clear();
        this.team_2.clear();
        this.team_3.clear();
        this.team_4.clear();
        this.team_5.clear();
        List<List<String>> teams = List.of(this.team_1, this.team_2, this.team_3, this.team_4, this.team_5);
        for (int i = 0; i < teams.size(); ++i) {
            ListTag teamTag = tag.getList("team_" + (i + 1), 8);
            for (int j = 0; j < teamTag.size(); ++j) {
                teams.get(i).add(teamTag.getString(j));
            }
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BIOMASS, (Object)100);
        builder.define(HOSTS, (Object)0);
        builder.define(NODE, (Object)this.getOnPos());
    }

    public int getHosts() {
        return (Integer)this.entityData.get(HOSTS);
    }

    public void setHosts(int i) {
        this.entityData.set(HOSTS, (Object)i);
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if ((double)amount > (Double)SConfig.SERVER.proto_dpsr.get() && (Double)SConfig.SERVER.proto_dpsr.get() > 0.0) {
            return super.hurt(source, (float)((Double)SConfig.SERVER.proto_dpsr.get() * 1.0));
        }
        if (source.getEntity() != null && Math.random() < (double)0.2f && this.summonDefense <= 0) {
            for (int i = 0; i < this.random.nextInt(1, 4); ++i) {
                this.SummonHelpers();
            }
            this.summonDefense = 160;
        }
        if (source.is(DamageTypes.FREEZE) && Math.random() < (double)0.2f) {
            this.SpreadInfection(this.level(), (Double)SConfig.SERVER.mound_range_age4.get() * 2.0, (BlockPos)this.entityData.get(NODE));
        }
        return super.hurt(source, amount);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.PROTO_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    public void die(DamageSource source) {
        super.die(source);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnDeathParticles(serverLevel);
            this.cleanupChunkLoading();
        }
        this.spreadBlocksAroundDeath();
        this.affectNearbyEntities();
        this.discard();
    }

    private void spawnDeathParticles(ServerLevel level) {
        double x = this.getX() - ((double)this.random.nextFloat() - 0.1) * 1.2;
        double y = this.getY() + ((double)this.random.nextFloat() - 0.25) * 1.25 * 5.0;
        double z = this.getZ() + ((double)this.random.nextFloat() - 0.1) * 1.2;
        level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x, y, z, 4, 0.0, 0.0, 0.0, 1.0);
    }

    private void cleanupChunkLoading() {
        ChunkPos chunk = this.chunkPosition();
        String requestId = "hivemind_" + String.valueOf(this.getUUID()) + "_" + String.valueOf(chunk);
    }

    private void spreadBlocksAroundDeath() {
        AABB area = this.getBoundingBox().inflate(2.5);
        BlockPos.betweenClosed((int)Mth.floor((double)area.minX), (int)Mth.floor((double)area.minY), (int)Mth.floor((double)area.minZ), (int)Mth.floor((double)area.maxX), (int)Mth.floor((double)area.maxY), (int)Mth.floor((double)area.maxZ)).forEach(this::trySpreadBlockAt);
    }

    private void trySpreadBlockAt(BlockPos pos) {
        double chance;
        BlockState ground = this.level().getBlockState(pos);
        BlockState above = this.level().getBlockState(pos.above());
        if (!this.level().isClientSide() && ground.isSolidRender((BlockGetter)this.level(), pos) && !above.isSolidRender((BlockGetter)this.level(), pos) && (chance = Math.random()) < 0.9) {
            if (Math.random() < 0.7) {
                this.level().setBlock(pos.above(), ((Block)Sblocks.MYCELIUM_VEINS.get()).defaultBlockState(), 2);
            }
            if (Math.random() < 0.3) {
                this.level().setBlock(pos.above(), ((Block)Sblocks.BIOMASS_BLOCK.get()).defaultBlockState(), 2);
            }
            if (Math.random() < 0.1) {
                this.level().setBlock(pos.above(), ((Block)Sblocks.ROOTED_BIOMASS.get()).defaultBlockState(), 2);
            }
            if (Math.random() < 0.15) {
                this.level().setBlock(pos, ((Block)Sblocks.BRAIN_REMNANTS.get()).defaultBlockState(), 2);
            }
        }
    }

    private void affectNearbyEntities() {
        AABB searchBox = AABB.ofSize((Vec3)new Vec3(this.getX(), this.getY(), this.getZ()), (double)300.0, (double)200.0, (double)300.0);
        List nearbyEntities = this.level().getEntities((Entity)this, searchBox, EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        this.entityData.set(HOSTS, (Object)0);
        for (Entity entity : nearbyEntities) {
            Infected infected;
            if (entity instanceof Infected && (infected = (Infected)entity).getLinked()) {
                infected.addEffect(new MobEffectInstance(MobEffects.WITHER, 400, 1));
            }
            if (!(entity instanceof Calamity)) continue;
            Calamity calamity = (Calamity)entity;
            calamity.setSearchArea(this.getOnPos());
        }
    }

    public void setSignal(@Nullable Signal signal) {
        this.signal = signal;
    }

    @Nullable
    public Signal getSignal() {
        return this.signal;
    }

    public void SummonConstructor(Level level, Entity entity, BlockPos pos) {
        ServerLevel serverLevel;
        RandomSource randomSource = RandomSource.create();
        int a = randomSource.nextInt(-12, 12);
        int b = randomSource.nextInt(-12, 12);
        int c = randomSource.nextInt(-4, 4);
        BlockPos blockPos = new BlockPos((int)entity.getX() + a, (int)entity.getY() + c, (int)entity.getZ() + b);
        BlockPos blockPosTop = blockPos.above();
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).isEmptyBlock(blockPos) && (serverLevel.isEmptyBlock(blockPosTop) || serverLevel.getBlockState(blockPosTop).liquid()) && pos != null) {
            Womb.TERRAIN terrain = Womb.TERRAIN.GROUND_LEVEL;
            if (pos.getY() > 120) {
                terrain = Womb.TERRAIN.AIR_LEVEL;
            } else if (pos.getY() < 63) {
                terrain = Womb.TERRAIN.UNDERGROUND;
            } else if (this.checkForLiquids(pos)) {
                terrain = Womb.TERRAIN.WATER_LEVEL;
            }
            Womb creature = new Womb(Sentities.RECONSTRUCTOR.get(), level, terrain, pos);
            creature.tickEmerging();
            creature.teleportRelative(entity.getX() + (double)a, entity.getY() + (double)c, entity.getZ() + (double)b);
            level.addFreshEntity((Entity)creature);
            level.getServer();
            for (ServerPlayer player : level.getServer().getPlayerList().getPlayers()) {
                player.playNotifySound(Ssounds.CALAMITY_SPAWN.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                player.displayClientMessage((Component)Component.translatable((String)"calamity_summon_message"), false);
            }
            this.setSignal(null);
        }
    }

    public void SummonHelpers() {
        int a = this.random.nextInt(-12, 12);
        int b = this.random.nextInt(-12, 12);
        int c = this.random.nextInt(4);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int i = this.hypers.size();
            Verwa verwa = new Verwa(Sentities.VERVA.get(), (Level)serverLevel);
            verwa.setStoredMob(this.hypers.get(this.random.nextInt(i)));
            verwa.teleportRelative(this.getX() + (double)a, this.getY() + (double)c, this.getZ() + (double)b);
            verwa.tickEmerging();
            this.level().addFreshEntity((Entity)verwa);
        }
    }

    private boolean checkForLiquids(BlockPos blockPos) {
        AABB aabb = AABB.ofSize((Vec3)new Vec3((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()), (double)14.0, (double)14.0, (double)14.0);
        ArrayList<BlockPos> liquids = new ArrayList<BlockPos>();
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            if (this.level().getBlockState(blockpos).getFluidState() == Fluids.EMPTY.defaultFluidState()) continue;
            liquids.add(blockpos);
        }
        return liquids.size() > 6 && blockPos.getY() < 70;
    }

    public boolean checkForCalamities(BlockPos pos) {
        List entities = this.level().getEntities((Entity)this, this.seachbox(), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        for (Entity en : entities) {
            Calamity calamity;
            if (!(en instanceof Calamity) || (calamity = (Calamity)en).getSearchArea() != BlockPos.ZERO || !(Math.random() < 0.5)) continue;
            calamity.setSearchArea(pos);
            this.setSignal(null);
            for (ServerPlayer player : this.level().getServer().getPlayerList().getPlayers()) {
                player.playNotifySound(Ssounds.CALAMITY_INCOMING.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                player.displayClientMessage((Component)Component.translatable((String)"calamity_coming_message"), false);
            }
            return false;
        }
        return true;
    }

    @Override
    public int getEmerge_tick() {
        return 120;
    }

    @Override
    public int getNumberOfParticles() {
        return 6;
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @org.jetbrains.annotations.Nullable SpawnGroupData spawnGroupData) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (((Boolean)SConfig.SERVER.teleport_hive.get()).booleanValue()) {
                Proto.teleportToSurface(serverLevel, (Mob)this);
            }
        }
        this.loadChunks();
        this.entityData.set(NODE, (Object)this.getOnPos());
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public void loadChunks() {
        Level level;
        if (((Boolean)SConfig.SERVER.proto_chunk.get()).booleanValue() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getServer().execute(() -> {
                ChunkPos chunk = this.chunkPosition();
                UUID ownerId = this.getUUID();
                String id = "hivemind_" + String.valueOf(ownerId) + "_" + chunk.toString();
                ChunkLoadRequest request = new ChunkLoadRequest((ResourceKey<Level>)serverLevel.dimension(), new ChunkPos[]{chunk}, 1, id, 12000L, ownerId);
                if (ChunkLoaderHelper.ACTIVE_REQUESTS.containsValue(request)) {
                    return;
                }
                ChunkLoaderHelper.addRequest(request);
            });
        }
    }

    public boolean hasLineOfSight(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.hasEffect(Seffects.MARKER)) {
                return true;
            }
            if ((livingEntity instanceof Player || ((List)SConfig.SERVER.proto_sapient_target.get()).contains(livingEntity.getEncodeId())) && !livingEntity.hasEffect(Seffects.SYMBIOSIS)) {
                return true;
            }
            if (livingEntity.getMaxHealth() > 30.0f) {
                return true;
            }
            return super.hasLineOfSight(entity);
        }
        return super.hasLineOfSight(entity);
    }

    public int decide(double[] inputs) {
        if (this.weights == null || this.weights.length == 0) {
            this.initializeValues();
        }
        if (inputs == null || inputs.length == 0) {
            return 0;
        }
        double[] outputs = new double[4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                int n = i;
                outputs[n] = outputs[n] + inputs[j] * this.weights[i * 4 + j];
            }
        }
        return this.argmax(outputs);
    }

    private int argmax(double[] arr) {
        if (arr == null || arr.length == 0) {
            return 0;
        }
        int maxIndex = 0;
        for (int i = 1; i < arr.length; ++i) {
            if (!(arr[i] > arr[maxIndex])) continue;
            maxIndex = i;
        }
        return maxIndex;
    }

    public void punishForDecision(int decision, int member) {
        this.adjustWeightsForDecision(decision, -0.1);
        if (Math.random() < 0.05) {
            this.punishMember(this.getDecisionList(decision), member);
        }
    }

    public void praisedForDecision(int decision, int member) {
        this.adjustWeightsForDecision(decision, 0.05);
        if (Math.random() < 0.2) {
            this.awardMember(this.getDecisionList(decision), member);
        }
    }

    public void adjustWeightsForDecision(int decision, double penalty) {
        int startIndex = decision * 4;
        int endIndex = startIndex + 4;
        for (int i = startIndex; i < endIndex; ++i) {
            int n = i;
            this.weights[n] = this.weights[n] + penalty;
            this.weights[i] = Math.max(-1.0, Math.min(1.0, this.weights[i]));
        }
    }

    private void punishMember(List<String> team, int member) {
        if (team == null || team.isEmpty() || member < 0 || member >= team.size()) {
            return;
        }
        String removed = team.remove(member);
        String newMember = this.getUniqueReplacement(team, (List)SConfig.SERVER.proto_summonable_troops.get());
        if (newMember != null) {
            team.add(newMember);
        } else {
            team.add(removed);
        }
    }

    private void awardMember(List<String> team, int member) {
        if (team == null || team.isEmpty() || member < 0 || member >= team.size()) {
            return;
        }
        String s = team.get(member);
        if (!this.team_5.contains(s)) {
            this.team_5.add(team.get(member));
        }
    }

    private String getUniqueReplacement(List<String> team, List<? extends String> CONFIG) {
        List<String> possibleReplacements;
        if (this.team_5.isEmpty()) {
            possibleReplacements = new ArrayList<String>(CONFIG);
        } else {
            possibleReplacements = this.team_5;
            possibleReplacements.removeAll(team);
            if (!possibleReplacements.isEmpty()) {
                String s = possibleReplacements.get(this.random.nextInt(possibleReplacements.size()));
                this.team_5.remove(s);
                return s;
            }
        }
        ArrayList<String> mobsInTeam = new ArrayList<String>();
        for (String s : team) {
            String[] string = s.split("_");
            mobsInTeam.add(string[0]);
        }
        possibleReplacements.removeAll(mobsInTeam);
        if (possibleReplacements.isEmpty()) {
            return null;
        }
        String member = possibleReplacements.get(this.random.nextInt(possibleReplacements.size()));
        int add = this.isVariantKeeper(member);
        return member + "_" + add;
    }

    public static void teleportToSurface(ServerLevel level, Mob entity) {
        BlockPos startPos = entity.blockPosition();
        if (level.canSeeSky(startPos)) {
            return;
        }
        int surfaceY = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, startPos.getX(), startPos.getZ());
        BlockPos surfacePos = new BlockPos(startPos.getX(), surfaceY, startPos.getZ());
        if (level.canSeeSky(surfacePos)) {
            BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(surfacePos.getX(), surfacePos.getY(), surfacePos.getZ());
            for (int i = 0; i < 8; ++i) {
                BlockState below = level.getBlockState(checkPos.below());
                BlockState current = level.getBlockState((BlockPos)checkPos);
                if (below.isSolid() && current.isAir()) {
                    entity.teleportTo((double)checkPos.getX() + 0.5, (double)checkPos.getY(), (double)checkPos.getZ() + 0.5);
                    return;
                }
                checkPos.move(Direction.DOWN);
            }
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(startPos.getX(), startPos.getY(), startPos.getZ());
        while (pos.getY() < level.getMaxBuildHeight()) {
            pos.move(Direction.UP);
            if (!level.canSeeSky((BlockPos)pos)) continue;
            entity.teleportTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
            return;
        }
    }

    @Override
    public void SpreadFoliageAndConvert(Level level, BlockState blockstate, BlockPos blockpos) {
        FoliageSpread.super.SpreadFoliageAndConvert(level, blockstate, blockpos);
    }
}

