/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.ScatterShotRangedGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.Projectile.AdaptableProjectile;
import com.Harbinger.Spore.Sentities.Variants.BulletParameters;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;

public class Usurper
extends Organoid
implements RangedAttackMob {
    private static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.defineId(Usurper.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public Usurper(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    @Override
    public int getEmerge_tick() {
        return 60;
    }

    @Override
    public int getBorrow_tick() {
        return 100;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.usurper_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.usurper_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("timer", ((Integer)this.entityData.get(TIMER)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(TIMER, (Object)tag.getInt("timer"));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TIMER, (Object)0);
    }

    protected void registerGoals() {
        this.addTargettingGoals();
        this.goalSelector.addGoal(2, (Goal)new ScatterShotRangedGoal(this, 0.0, 40, 32.0f, 1, 4));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.getTarget() == null && (Integer)this.entityData.get(TIMER) < 1200) {
                this.entityData.set(TIMER, (Object)((Integer)this.entityData.get(TIMER) + 1));
            } else if ((Integer)this.entityData.get(TIMER) >= 1200) {
                this.tickBurrowing();
            }
        }
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.usurper_loot.get();
    }

    @Override
    public void tickBurrowing() {
        int burrowing = (Integer)this.entityData.get(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            this.discard();
            burrowing = -1;
        }
        this.entityData.set(BORROW, (Object)(burrowing + 1));
    }

    @Override
    public boolean hurt(DamageSource source, float value) {
        if (this.isEmerging()) {
            return false;
        }
        return super.hurt(source, value);
    }

    public boolean isNoAi() {
        return this.isBurrowing() || this.isEmerging();
    }

    public void performRangedAttack(LivingEntity livingEntity, float p_33318_) {
        BulletParameters parameters = (BulletParameters)((Object)Util.getRandom((Object[])BulletParameters.values(), (RandomSource)this.random));
        AdaptableProjectile projectile = new AdaptableProjectile(parameters, this.level(), (LivingEntity)this);
        double dx = livingEntity.getX() - this.getX();
        double dy = livingEntity.getY() + (double)livingEntity.getEyeHeight();
        double dz = livingEntity.getZ() - this.getZ();
        projectile.moveTo(this.getX(), this.getY() + 1.2, this.getZ());
        projectile.shoot(dx, dy - projectile.getY() + Math.hypot(dx, dz) * (double)0.001f, dz, 1.5f, 3.0f);
        this.playSound(Ssounds.SPIT.get());
        this.level().addFreshEntity((Entity)projectile);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.USURPER_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }
}

