/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Verwa
extends Organoid {
    public static final EntityDataAccessor<String> STORED_MOB = SynchedEntityData.defineId(Verwa.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.defineId(Verwa.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public AnimationState burst = new AnimationState();
    private int burstTimeout = 0;

    public Verwa(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("timer", ((Integer)this.entityData.get(TIMER)).intValue());
        tag.putString("stored_mob", (String)this.entityData.get(STORED_MOB));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(TIMER, (Object)tag.getInt("timer"));
        this.entityData.set(STORED_MOB, (Object)tag.getString("stored_mob"));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TIMER, (Object)0);
        builder.define(STORED_MOB, (Object)"spore:knight");
    }

    public Entity getStoredEntity() {
        ResourceLocation location = ResourceLocation.parse((String)((String)this.entityData.get(STORED_MOB)));
        EntityType<?> entityType = Utilities.tryToCreateEntity(location);
        return entityType.create(this.level());
    }

    public void TickTimer() {
        this.entityData.set(TIMER, (Object)((Integer)this.entityData.get(TIMER) + 1));
        if ((Integer)this.entityData.get(TIMER) > 40 && this.level().isClientSide) {
            this.ClientAnimation();
        }
        if ((Integer)this.entityData.get(TIMER) > 80) {
            this.entityData.set(TIMER, (Object)-1);
            this.SummonStoredEntity();
            this.tickBurrowing();
        }
    }

    public List<String> getDropList() {
        UtilityEntity infected;
        List baseLoot = (List)SConfig.DATAGEN.verwa_loot.get();
        List<Object> storedLoot = new ArrayList();
        Entity entity = this.getStoredEntity();
        if (entity instanceof Infected && !(infected = (Infected)entity).getDropList().isEmpty()) {
            storedLoot = infected.getDropList();
        }
        if ((entity = this.getStoredEntity()) instanceof UtilityEntity && !(infected = (UtilityEntity)entity).getDropList().isEmpty()) {
            storedLoot = infected.getDropList();
        }
        ArrayList<String> combinedLoot = new ArrayList<String>();
        combinedLoot.addAll(baseLoot);
        combinedLoot.addAll(storedLoot);
        return combinedLoot;
    }

    public void SummonStoredEntity() {
        Entity entity = this.getStoredEntity();
        this.awardHivemind();
        if (entity instanceof LivingEntity) {
            Level level;
            LivingEntity living = (LivingEntity)entity;
            for (String string : (List)SConfig.SERVER.verwa_effect.get()) {
                Holder<MobEffect> effect = Utilities.tryToCreateEffect(ResourceLocation.parse((String)string));
                if (effect == null) continue;
                living.addEffect(new MobEffectInstance(effect, 600, 1));
            }
            if (living instanceof Infected) {
                Infected infected = (Infected)living;
                infected.setLinked(true);
                infected.setPersistent(true);
            }
            if ((level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (living instanceof Mob) {
                    Mob mob = (Mob)living;
                    mob.finalizeSpawn((ServerLevelAccessor)serverLevel, this.level().getCurrentDifficultyAt(this.getOnPos()), MobSpawnType.SPAWNER, null);
                }
            }
        }
        entity.moveTo(this.getX(), this.getY() + 0.2, this.getZ());
        this.level().addFreshEntity(entity);
    }

    public void ClientAnimation() {
        if (this.burstTimeout <= 0) {
            this.burstTimeout = 40;
            this.burst.start(this.tickCount);
        } else {
            --this.burstTimeout;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.isEmerging() && (Integer)this.entityData.get(TIMER) >= 0) {
            this.TickTimer();
        }
    }

    @Override
    public boolean hurt(DamageSource source, float p_21017_) {
        if (this.isEmerging()) {
            return false;
        }
        this.tickBurrowing();
        return super.hurt(source, p_21017_);
    }

    @Override
    public int getEmerge_tick() {
        return 40;
    }

    @Override
    public int getBorrow_tick() {
        return 60;
    }

    @Override
    public void tickBurrowing() {
        int burrowing = (Integer)this.entityData.get(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            burrowing = -1;
            this.discard();
        }
        this.entityData.set(BORROW, (Object)(burrowing + 1));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.verwa_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.verwa_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.WOMB_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    public void setStoredMob(String storedMob) {
        this.entityData.set(STORED_MOB, (Object)storedMob);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        int i = ((List)SConfig.SERVER.verwa_summons.get()).size();
        this.entityData.set(STORED_MOB, (Object)((String)((List)SConfig.SERVER.verwa_summons.get()).get(this.random.nextInt(i))));
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }
}

