/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import com.Harbinger.Spore.Sentities.Signal;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import com.Harbinger.Spore.Sentities.Variants.VigilVariants;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Sparticles;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class Vigil
extends Organoid
implements TraceableEntity,
VariantKeeper {
    private static final EntityDataAccessor<Integer> TRIGGER = SynchedEntityData.defineId(Vigil.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> WAVE_SIZE = SynchedEntityData.defineId(Vigil.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.defineId(Vigil.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(Vigil.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int summon_counter;
    @javax.annotation.Nullable
    private Mob proto;

    public Vigil(EntityType<? extends UtilityEntity> type, Level level) {
        super(type, level);
        this.setPersistenceRequired();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.vigil_loot.get();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(WAVE_SIZE, (Object)0);
        builder.define(TIMER, (Object)0);
        builder.define(TRIGGER, (Object)0);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public int getEmerge_tick() {
        return this.isStalker() ? 90 : 180;
    }

    @Override
    public int getBorrow_tick() {
        return this.isStalker() ? 100 : 200;
    }

    @Override
    public void tickBurrowing() {
        int burrowing = (Integer)this.entityData.get(BORROW);
        if (burrowing > this.getBorrow_tick()) {
            burrowing = -1;
            if (this.isStalker() && this.getTarget() != null) {
                this.ReEmerge();
            } else {
                Level level;
                if (this.getVariant() == VigilVariants.TROLL && (level = this.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.getLastAttacker() instanceof Player || this.getTarget() instanceof Player) {
                        this.pickAndPlaceMessage(serverLevel, this.getOnPos().above());
                    }
                }
                this.discard();
                this.TimeToLeave();
            }
        }
        this.entityData.set(BORROW, (Object)(burrowing + 1));
    }

    public boolean isStalker() {
        return this.getVariant() == VigilVariants.STALKER;
    }

    public int getTrigger() {
        return (Integer)this.entityData.get(TRIGGER);
    }

    public void setTrigger(int i) {
        this.entityData.set(TRIGGER, (Object)i);
    }

    public int getWaveSize() {
        return (Integer)this.entityData.get(WAVE_SIZE);
    }

    public void setWaveSize(int i) {
        this.entityData.set(WAVE_SIZE, (Object)i);
    }

    public int getTimer() {
        return (Integer)this.entityData.get(TIMER);
    }

    @javax.annotation.Nullable
    public void setProto(Mob entity) {
        this.proto = entity;
    }

    public boolean isNoAi() {
        return this.isBurrowing() || this.isEmerging();
    }

    @Override
    public void tick() {
        if (this.getTarget() == null && (Integer)this.entityData.get(TIMER) < 6000) {
            if ((Integer)this.entityData.get(TIMER) % 300 == 0) {
                this.setTrigger(0);
                this.setWaveSize(0);
            }
            this.entityData.set(TIMER, (Object)((Integer)this.entityData.get(TIMER) + 1));
        } else if ((Integer)this.entityData.get(TIMER) >= 6000) {
            this.escape();
        }
        if (this.getTarget() != null && this.distanceToSqr((Entity)this.getTarget()) < 300.0 || this.getTrigger() >= 4) {
            this.setTrigger(this.getTrigger() <= 0 ? 1 : this.getTrigger());
            this.escape();
        }
        super.tick();
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("trigger", ((Integer)this.entityData.get(TRIGGER)).intValue());
        tag.putInt("timer", ((Integer)this.entityData.get(TIMER)).intValue());
        tag.putInt("wave_size", ((Integer)this.entityData.get(WAVE_SIZE)).intValue());
        tag.putInt("Variant", this.getTypeVariant());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(TRIGGER, (Object)tag.getInt("trigger"));
        this.entityData.set(TIMER, (Object)tag.getInt("timer"));
        this.entityData.set(WAVE_SIZE, (Object)tag.getInt("wave_size"));
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)tag.getInt("Variant"));
    }

    public void ReEmerge() {
        this.entityData.set(TIMER, (Object)0);
        this.randomTeleport(this.getX() + (double)this.random.nextInt(-30, 30), this.getY(), this.getZ() + (double)this.random.nextInt(-30, 30), false);
        this.tickEmerging();
    }

    @Override
    public boolean hurt(DamageSource p_21016_, float p_21017_) {
        if (this.isEmerging()) {
            return false;
        }
        this.escape();
        return super.hurt(p_21016_, p_21017_);
    }

    public void escape() {
        if (this.onGround()) {
            this.tickBurrowing();
        }
    }

    boolean checkForScents() {
        AABB aabb = this.getBoundingBox().inflate(16.0);
        List entities = this.level().getEntitiesOfClass(ScentEntity.class, aabb);
        return entities.size() < (Integer)SConfig.SERVER.scent_cap.get();
    }

    public void TimeToLeave() {
        int i = (Integer)this.entityData.get(TRIGGER);
        if (i == 1) {
            this.SummonScent((Entity)this, this.level(), false);
        } else if (i == 2) {
            this.SummonScent((Entity)this, this.level(), true);
        } else if (i >= 3) {
            AABB searchbox = this.getBoundingBox().inflate((double)((Integer)SConfig.SERVER.proto_range.get()).intValue());
            List entities = this.level().getEntities((Entity)this, searchbox, EntitySelector.NO_CREATIVE_OR_SPECTATOR);
            for (Entity en : entities) {
                if (!(en instanceof Proto)) continue;
                Proto proto = (Proto)en;
                proto.setSignal(new Signal(true, new BlockPos((int)this.getX(), (int)this.getY(), (int)this.getZ())));
                break;
            }
        }
        this.punishHivemind();
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.VIGIL_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    private void SummonScent(Entity entity, Level level, boolean value) {
        if (this.checkForScents()) {
            ScentEntity scent = new ScentEntity(Sentities.SCENT.get(), level);
            scent.moveTo(entity.getX(), entity.getY(), entity.getZ());
            scent.setOvercharged(value);
            level.addFreshEntity((Entity)scent);
        }
    }

    @Nullable
    public Entity getOwner() {
        return this.proto;
    }

    public VigilVariants getVariant() {
        return VigilVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    @Override
    public void setVariant(int i) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(i > VigilVariants.values().length || i < 0 ? 0 : i));
    }

    @Override
    public int amountOfMutations() {
        return VigilVariants.values().length;
    }

    public void pickAndPlaceMessage(ServerLevel serverLevel, BlockPos pos) {
        if (pos.equals((Object)BlockPos.ZERO) || !serverLevel.getBlockState(pos).isAir() && !(serverLevel.getBlockState(pos).getBlock() instanceof BushBlock)) {
            return;
        }
        String key = "spore.proto.message." + this.random.nextInt(10);
        MutableComponent translated = Component.translatable((String)key);
        String[] words = translated.getString().split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 <= 15) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            lines.add(currentLine.toString());
            currentLine = new StringBuilder(word);
            if (lines.size() == 4) break;
        }
        if (lines.size() < 4 && currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        while (lines.size() < 4) {
            lines.add("");
        }
        this.placeSignWithText(serverLevel, pos, lines.toArray(new String[0]));
    }

    public void placeSignWithText(ServerLevel world, BlockPos pos, String[] lines) {
        BlockState signState = Blocks.OAK_SIGN.defaultBlockState();
        world.setBlockAndUpdate(pos, signState);
        BlockEntity be = world.getBlockEntity(pos);
        if (!(be instanceof SignBlockEntity)) {
            return;
        }
        SignBlockEntity sign = (SignBlockEntity)be;
        SignText newText = sign.getFrontText();
        int v = Math.min(lines.length, 4);
        for (int i = 0; i < v; ++i) {
            String centered = this.centerLine(lines[i], 15);
            MutableComponent line = Component.literal((String)centered);
            newText = newText.setMessage(i, (Component)line, (Component)line);
        }
        sign.setText(newText, true);
        sign.setChanged();
    }

    private String centerLine(String text, int width) {
        if (text.length() >= width) {
            return text.substring(0, width);
        }
        int pad = (width - text.length()) / 2;
        return " ".repeat(pad) + text;
    }

    private void setVariant(VigilVariants variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public void SummonInfected() {
        Level level;
        int l = this.getTrigger();
        List summons = l <= 1 ? (List)SConfig.SERVER.vigil_base_wave.get() : (l == 2 ? (List)SConfig.SERVER.vigil_middle_wave.get() : (List)SConfig.SERVER.vigil_max_wave.get());
        this.awardHivemind();
        LivingEntity target = this.getTarget();
        if (target != null && this.getTrigger() > 0 && (level = this.level()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor world = (ServerLevelAccessor)level;
            RandomSource rand = RandomSource.create();
            int randomIndex = rand.nextInt(summons.size());
            ResourceLocation randomElement1 = ResourceLocation.parse((String)((String)summons.get(randomIndex)));
            EntityType<?> randomElement = Utilities.tryToCreateEntity(randomElement1);
            Mob waveentity = (Mob)randomElement.create(this.level());
            assert (waveentity != null);
            waveentity.setPos(this.getX(), this.getY(), this.getZ());
            waveentity.finalizeSpawn(world, this.level().getCurrentDifficultyAt(new BlockPos((int)this.getX(), (int)this.getY(), (int)this.getZ())), MobSpawnType.NATURAL, null);
            if (waveentity.getTarget() == null && target.isAlive() && !target.isInvulnerable()) {
                waveentity.setTarget(target);
            }
            this.level().addFreshEntity((Entity)waveentity);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.vigil_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.vigil_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.getWaveSize() > 0 && this.summon_counter <= 20) {
            ++this.summon_counter;
        } else if (this.getWaveSize() > 0 && this.summon_counter >= 20) {
            this.summon_counter = 0;
            this.SummonInfected();
            this.setWaveSize(this.getWaveSize() - 1);
        }
        if (this.getWaveSize() > 0) {
            double x = this.getX();
            double y = this.getY();
            double z = this.getZ();
            RandomSource randomsource = this.getRandom();
            for (int l = 0; l < 3; ++l) {
                int i = randomsource.nextInt(-3, 3);
                int i1 = randomsource.nextInt(-3, 3);
                Level level = this.level();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)Sparticles.SPORE_PARTICLE.get(), x + (double)i, y + this.random.nextDouble(), z + (double)i1, 1, 0.0, 0.3, 0.0, (double)0.15f);
            }
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 0));
        }
        return super.mobInteract(player, interactionHand);
    }

    protected void registerGoals() {
        this.addTargettingGoals();
        this.goalSelector.addGoal(2, (Goal)new WatchTargetGoat(this));
        this.goalSelector.addGoal(2, (Goal)new WatcherMobSummon(this));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        super.registerGoals();
    }

    @Override
    public int getNumberOfParticles() {
        return 4;
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isStalker() ? super.getDimensions(pose).scale(1.2f) : super.getDefaultDimensions(pose);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        VigilVariants variant = (VigilVariants)((Object)Util.getRandom((Object[])VigilVariants.values(), (RandomSource)this.random));
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Override
    public String getMutation() {
        if (this.getTypeVariant() != 0) {
            return this.getVariant().getName();
        }
        return super.getMutation();
    }

    private static class WatchTargetGoat
    extends Goal {
        private final Vigil vigil;

        public WatchTargetGoat(Vigil vigil1) {
            this.vigil = vigil1;
        }

        public boolean canUse() {
            return this.vigil.getTarget() != null;
        }

        public void tick() {
            super.tick();
            LivingEntity target = this.vigil.getTarget();
            if (target != null && this.vigil.hasLineOfSight((Entity)target)) {
                this.vigil.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
                if (target instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)target;
                    if (!player.hasEffect(Seffects.UNEASY)) {
                        player.addEffect(new MobEffectInstance(Seffects.UNEASY, 6000, 0));
                    }
                    player.displayClientMessage((Component)Component.translatable((String)"vigil.message"), true);
                }
            }
        }

        public void start() {
            super.start();
            if (this.vigil.getTarget() != null && this.vigil.proto != null && this.vigil.proto.getTarget() == null) {
                this.vigil.proto.setTarget(this.vigil.getTarget());
            }
        }
    }

    private static class WatcherMobSummon
    extends Goal {
        private final Vigil vigil;

        private WatcherMobSummon(Vigil vigil) {
            this.vigil = vigil;
        }

        public boolean canUse() {
            if (this.vigil.getWaveSize() > 0) {
                return false;
            }
            return this.vigil.random.nextInt(100) == 0 && this.vigil.getTarget() != null && this.checkForInfected((Entity)this.vigil.getTarget());
        }

        boolean checkForInfected(Entity entity) {
            AABB boundingBox = entity.getBoundingBox().inflate(16.0);
            List entities = entity.level().getEntities(entity, boundingBox, EntitySelector.NO_CREATIVE_OR_SPECTATOR);
            for (Entity en : entities) {
                if (!(en instanceof Infected)) continue;
                return false;
            }
            return true;
        }

        public void start() {
            super.start();
            if (this.vigil.getTarget() != null && this.vigil.getWaveSize() <= 0) {
                LivingEntity target = this.vigil.getTarget();
                int l = (Integer)SConfig.SERVER.vigil_wave_size.get();
                int e = target.getMaxHealth() > (float)(l * 5) ? l : (int)(target.getMaxHealth() / 5.0f) + target.getArmorValue() / 4;
                this.vigil.setWaveSize(e);
                this.vigil.setTrigger(this.vigil.getTrigger() + 1);
            }
        }
    }
}

