/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Organoids;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Recipes.SporeForcedRecipes.WombAssimilationRecipe;
import com.Harbinger.Spore.Screens.AssimilationMenu;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sparticles;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.Nullable;

public class Womb
extends Organoid
implements MenuProvider {
    private static final EntityDataAccessor<Integer> COUNTER = SynchedEntityData.defineId(Womb.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BIOMASS = SynchedEntityData.defineId(Womb.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(Womb.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<BlockPos> LOCATION = SynchedEntityData.defineId(Womb.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private int breakCounter;
    private final List<String> attributeIDs = new ArrayList<String>();
    private int eatingTicks = 0;

    public Womb(EntityType<? extends PathfinderMob> type, Level level, TERRAIN terrain, BlockPos pos) {
        super(type, level);
        this.entityData.set(STATE, (Object)terrain.value);
        this.setLocation(pos);
    }

    public Womb(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.entityData.set(STATE, (Object)0);
        this.setLocation(BlockPos.ZERO);
    }

    public List<String> getAttributeIDs() {
        return this.attributeIDs;
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.womb_loot.get();
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.WOMB_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    @Override
    public void tick() {
        super.tick();
        if ((Integer)this.entityData.get(BIOMASS) >= (Integer)SConfig.SERVER.reconstructor_biomass.get()) {
            this.summon((Entity)this, false);
        }
        if ((Integer)this.entityData.get(COUNTER) < (Integer)SConfig.SERVER.recontructor_clock.get() * 20) {
            this.entityData.set(COUNTER, (Object)((Integer)this.entityData.get(COUNTER) + 1));
        } else {
            this.entityData.set(COUNTER, (Object)0);
            this.entityData.set(BIOMASS, (Object)((Integer)this.entityData.get(BIOMASS) + 1));
        }
        if (this.random.nextInt(100) == 0) {
            this.CallNearbyInfected();
        }
        if (this.random.nextInt(40) == 0) {
            this.AssimilateNearbyInfected();
        }
        if (this.random.nextInt(20) == 0 && this.isEating()) {
            this.playSound(SoundEvents.GENERIC_EAT);
        }
        if (this.eatingTicks > 0) {
            --this.eatingTicks;
        }
    }

    public void setBiomass(int biomass) {
        this.entityData.set(BIOMASS, (Object)biomass);
    }

    public int getBiomass() {
        return (Integer)this.entityData.get(BIOMASS);
    }

    public void setLocation(BlockPos pos) {
        this.entityData.set(LOCATION, (Object)pos);
    }

    public BlockPos getLocation() {
        return (BlockPos)this.entityData.get(LOCATION);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Counter", ((Integer)this.entityData.get(COUNTER)).intValue());
        tag.putInt("Biomass", ((Integer)this.entityData.get(BIOMASS)).intValue());
        tag.putInt("State", ((Integer)this.entityData.get(STATE)).intValue());
        tag.putInt("LocationX", this.getLocation().getX());
        tag.putInt("LocationY", this.getLocation().getY());
        tag.putInt("LocationZ", this.getLocation().getZ());
        ListTag teamTag = new ListTag();
        for (String member : this.attributeIDs) {
            teamTag.add((Object)StringTag.valueOf((String)member));
        }
        tag.put("mutations", (Tag)teamTag);
    }

    public boolean isEating() {
        return this.eatingTicks > 0;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COUNTER, (Object)0);
        builder.define(BIOMASS, (Object)0);
        builder.define(STATE, (Object)0);
        builder.define(LOCATION, (Object)BlockPos.ZERO);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(COUNTER, (Object)tag.getInt("Counter"));
        this.entityData.set(BIOMASS, (Object)tag.getInt("Biomass"));
        this.entityData.set(STATE, (Object)tag.getInt("State"));
        int i = tag.getInt("LocationX");
        int j = tag.getInt("LocationY");
        int k = tag.getInt("LocationZ");
        this.setLocation(new BlockPos(i, j, k));
        this.attributeIDs.clear();
        ListTag teamTag = tag.getList("mutations", 8);
        for (int l = 0; l < teamTag.size(); ++l) {
            this.attributeIDs.add(teamTag.getString(l));
        }
    }

    private void CallNearbyInfected() {
        if (!this.level().isClientSide) {
            AABB hitbox = this.getBoundingBox().inflate(50.0);
            List entities = this.level().getEntities((Entity)this, hitbox, EntitySelector.NO_CREATIVE_OR_SPECTATOR);
            for (Entity en : entities) {
                if (!(en instanceof Infected)) continue;
                Infected infected = (Infected)en;
                infected.setSearchPos(new BlockPos((int)this.getX(), (int)this.getY(), (int)this.getZ()));
            }
        }
    }

    public void addMutation(WombAssimilationRecipe.Recipe recipe) {
        this.attributeIDs.add(recipe.attribute());
    }

    private void AssimilateNearbyInfected() {
        if (!this.level().isClientSide) {
            List entities = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.1), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
            for (Entity en : entities) {
                if (!(en instanceof Infected)) continue;
                Infected infected = (Infected)en;
                this.setBiomass(this.getBiomass() + this.calculateAssimilation((Entity)infected) + infected.getKills());
                WombAssimilationRecipe.Recipe recipe = WombAssimilationRecipe.getUsableRecipe(this.level(), (LivingEntity)infected);
                if (recipe != null) {
                    this.addMutation(recipe);
                }
                infected.discard();
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    double x0 = this.getX() - ((double)this.random.nextFloat() - 0.1) * 0.1;
                    double y0 = this.getY() + ((double)this.random.nextFloat() - 0.25) * 0.25 * 5.0;
                    double z0 = this.getZ() + ((double)this.random.nextFloat() - 0.1) * 0.1;
                    serverLevel.sendParticles((ParticleOptions)Sparticles.BLOOD_PARTICLE.get(), x0, y0, z0, 8, 0.0, 0.0, 0.0, 1.0);
                }
                this.playSound(SoundEvents.GENERIC_EAT);
                this.eatingTicks += 80;
                break;
            }
        }
    }

    public int calculateAssimilation(Entity entity) {
        int value = (Integer)SConfig.SERVER.reconstructor_assimilation.get();
        if (entity instanceof Hyper) {
            return value * 4;
        }
        if (entity instanceof EvolvedInfected) {
            return value * 2;
        }
        return value;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        if (BIOMASS.equals(dataAccessor)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(dataAccessor);
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        EntityDimensions baseDimensions = super.getDefaultDimensions(pose);
        int age = 1;
        if (this.getBiomass() > (Integer)SConfig.SERVER.reconstructor_biomass.get() / 4 && this.getBiomass() < (Integer)SConfig.SERVER.reconstructor_biomass.get() / 2) {
            age = 2;
        } else if (this.getBiomass() > (Integer)SConfig.SERVER.reconstructor_biomass.get() / 2) {
            age = 3;
        }
        return baseDimensions.scale((float)age);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.reconstructor_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.reconstructor_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.breakCounter < 40) {
            ++this.breakCounter;
        } else if (this.getLastDamageSource() == this.damageSources().inWall() && EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
            AABB aabb = this.getBoundingBox().inflate(0.2, 0.0, 0.2);
            boolean flag = false;
            for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
                BlockState blockstate = this.level().getBlockState(blockpos);
                if (!(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) < 10.0f) || !(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) > 0.0f)) continue;
                flag = this.level().destroyBlock(blockpos, true, (Entity)this) || flag;
                this.breakCounter = 0;
            }
        }
    }

    @Override
    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.getBiomass() > 1) {
            int age = 1;
            if (this.getBiomass() > (Integer)SConfig.SERVER.reconstructor_biomass.get() / 4 && this.getBiomass() < (Integer)SConfig.SERVER.reconstructor_biomass.get() / 2) {
                age = 2;
            } else if (this.getBiomass() > (Integer)SConfig.SERVER.reconstructor_biomass.get() / 2) {
                age = 3;
            }
            if (age > 1) {
                AttributeInstance health = this.getAttribute(Attributes.MAX_HEALTH);
                assert (health != null);
                health.setBaseValue((Double)SConfig.SERVER.mound_hp.get() * (double)age * (Double)SConfig.SERVER.global_health.get());
                AttributeInstance armor = this.getAttribute(Attributes.ARMOR);
                assert (armor != null);
                armor.setBaseValue((Double)SConfig.SERVER.mound_armor.get() * (double)age * (Double)SConfig.SERVER.global_armor.get());
            }
        }
    }

    private void summon(Entity entity, boolean value) {
        Object object;
        List<? extends String> variantList;
        if (Math.random() <= (double)0.3f) {
            this.entityData.set(STATE, (Object)this.random.nextInt(TERRAIN.values().length));
        }
        if ((variantList = this.getVariant().getList()).isEmpty()) {
            return;
        }
        ResourceLocation entityId = ResourceLocation.parse((String)variantList.get(this.random.nextInt(variantList.size())));
        EntityType<?> entityType = Utilities.tryToCreateEntity(entityId);
        if (entityType == null) {
            return;
        }
        Mob spawnedEntity = (Mob)entityType.create(this.level());
        if (spawnedEntity == null) {
            return;
        }
        Vec3 origin = new Vec3((double)this.getLocation().getX(), (double)this.getLocation().getY(), (double)this.getLocation().getZ());
        Vec3 current = this.position();
        double maxDistance = 200.0;
        if (origin.distanceTo(current) > maxDistance) {
            Vec3 newPos = Utilities.generatePositionAway(origin, 100.0);
            spawnedEntity.teleportRelative(newPos.x, newPos.y, newPos.z);
        } else {
            spawnedEntity.setPos(entity.getX(), entity.getY(), entity.getZ());
        }
        if (spawnedEntity instanceof Calamity) {
            Calamity calamity = (Calamity)spawnedEntity;
            calamity.setSearchArea(this.getLocation());
            object = this.attributeIDs.iterator();
            while (object.hasNext()) {
                Holder attributeHolder;
                AttributeInstance instance;
                String attrId = (String)object.next();
                ResourceLocation attrLocation = ResourceLocation.parse((String)attrId);
                Optional optional = BuiltInRegistries.ATTRIBUTE.getOptional(attrLocation);
                if (!optional.isPresent() || (instance = calamity.getAttribute(attributeHolder = BuiltInRegistries.ATTRIBUTE.wrapAsHolder((Object)((Attribute)optional.get())))) == null) continue;
                double e = instance.getValue();
                instance.setBaseValue(e + 1.0);
            }
            if (value) {
                calamity.setRemainingFireTicks(60);
                calamity.setHealth(calamity.getMaxHealth() / 2.0f);
            }
        }
        if ((object = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            double x0 = this.getX() - ((double)this.random.nextFloat() - 0.1) * 0.1;
            double y0 = this.getY() + ((double)this.random.nextFloat() - 0.25) * 0.15 * 5.0;
            double z0 = this.getZ() + ((double)this.random.nextFloat() - 0.1) * 0.1;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x0, y0, z0, 2, 0.0, 0.0, 0.0, 1.0);
            spawnedEntity.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(this.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
        }
        this.level().addFreshEntity((Entity)spawnedEntity);
        this.discard();
    }

    public void die(DamageSource p_21014_) {
        if (this.getBiomass() > (Integer)SConfig.SERVER.reconstructor_biomass.get() / 2) {
            this.summon((Entity)this, true);
        }
        super.die(p_21014_);
    }

    @Override
    public int getEmerge_tick() {
        return 60;
    }

    public TERRAIN getVariant() {
        return TERRAIN.byId((Integer)this.entityData.get(STATE) & 0xFF);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new AssimilationMenu(i, inventory);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.getAbilities().instabuild && !this.level().isClientSide) {
                serverPlayer.openMenu((MenuProvider)this);
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(player, hand);
    }

    public static enum TERRAIN {
        GROUND_LEVEL(0, (List)SConfig.SERVER.reconstructor_terrain.get()),
        WATER_LEVEL(1, (List)SConfig.SERVER.reconstructor_water.get()),
        AIR_LEVEL(2, (List)SConfig.SERVER.reconstructor_air.get()),
        UNDERGROUND(3, (List)SConfig.SERVER.reconstructor_underground.get());

        private final int value;
        private final List<? extends String> list;
        private static final TERRAIN[] BY_ID;

        private TERRAIN(int v, List<? extends String> l) {
            this.value = v;
            this.list = l;
        }

        public int getValue() {
            return this.value;
        }

        public List<? extends String> getList() {
            return this.list;
        }

        public static TERRAIN byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        static {
            BY_ID = (TERRAIN[])Arrays.stream(TERRAIN.values()).sorted(Comparator.comparingInt(TERRAIN::getValue)).toArray(TERRAIN[]::new);
        }
    }
}

