/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.Variants.BulletParameters;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class AdaptableProjectile
extends Projectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(AdaptableProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(AdaptableProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> PARTICLES = SynchedEntityData.defineId(AdaptableProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public AdaptableProjectile(Level level) {
        super(Sentities.SPIT.get(), level);
    }

    public AdaptableProjectile(BulletParameters parameters, Level level, LivingEntity livingEntity) {
        super(Sentities.SPIT.get(), level);
        this.setOwner((Entity)livingEntity);
        this.setType(parameters.getId());
        this.setDamage(parameters.getDamage());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
        builder.define(TYPE, (Object)0);
        builder.define(PARTICLES, (Object)0);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DAMAGE, (Object)Float.valueOf(tag.getFloat("damage")));
        this.entityData.set(TYPE, (Object)tag.getInt("type"));
        this.entityData.set(PARTICLES, (Object)tag.getInt("particles"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("damage", ((Float)this.entityData.get(DAMAGE)).floatValue());
        tag.putInt("type", ((Integer)this.entityData.get(TYPE)).intValue());
        tag.putInt("particles", ((Integer)this.entityData.get(PARTICLES)).intValue());
    }

    public void setType(int i) {
        this.entityData.set(TYPE, (Object)i);
    }

    public void setDamage(float i) {
        this.entityData.set(DAMAGE, (Object)Float.valueOf(i));
    }

    public void setParticles(int i) {
        this.entityData.set(PARTICLES, (Object)i);
    }

    public int getParticles() {
        return (Integer)this.entityData.get(PARTICLES);
    }

    protected boolean canHitEntity(Entity entity) {
        return entity != this.getOwner();
    }

    public void tick() {
        super.tick();
        if (this.tickCount >= 300) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.setPos(d0, d1, d2);
        if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.onHit(hitresult);
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        if (!this.level().isClientSide()) {
            Entity entity = entityHitResult.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity instanceof Infected || livingEntity instanceof UtilityEntity || ((List)SConfig.SERVER.blacklist.get()).contains(livingEntity.getEncodeId())) {
                    return;
                }
                int type = (Integer)this.entityData.get(TYPE);
                livingEntity.hurt(this.level().damageSources().mobProjectile((Entity)this, (LivingEntity)this.getOwner()), ((Float)this.entityData.get(DAMAGE)).floatValue());
                if (type == 0) {
                    livingEntity.addEffect(new MobEffectInstance(Seffects.CORROSION, 400, 3));
                } else if (type == 1) {
                    livingEntity.level().explode(this.getOwner(), livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), 1.0f, Level.ExplosionInteraction.NONE);
                } else if (type == 2) {
                    livingEntity.addEffect(new MobEffectInstance(Seffects.CORROSION, 600, 1));
                } else if (type == 3) {
                    livingEntity.setRemainingFireTicks(120);
                }
                this.discard();
            }
        } else {
            super.onHitEntity(entityHitResult);
        }
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        if (!this.level().isClientSide) {
            int type = (Integer)this.entityData.get(TYPE);
            Level level = this.level();
            if (type == 3 && level.getBlockState(blockHitResult.getBlockPos()).isFlammable((BlockGetter)level, blockHitResult.getBlockPos(), blockHitResult.getDirection())) {
                this.level().setBlock(blockHitResult.getBlockPos().relative(blockHitResult.getDirection()), Blocks.FIRE.defaultBlockState(), 3);
            }
            this.discard();
        }
        super.onHitBlock(blockHitResult);
    }
}

