/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Fluids.BileLiquid;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Sitems;
import java.util.function.Predicate;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class BileProjectile
extends Projectile
implements ItemSupplier {
    private float setBaseDamage;
    private Predicate<LivingEntity> target = livingEntity -> true;

    public BileProjectile(Level level) {
        super(Sentities.BILE.get(), level);
    }

    public BileProjectile(Level level, LivingEntity livingEntity2, Predicate<LivingEntity> predicate) {
        super(Sentities.BILE.get(), level);
        this.setOwner((Entity)livingEntity2);
        this.target = predicate;
    }

    public float getDamage() {
        return this.setBaseDamage;
    }

    public void setDamage(float value) {
        this.setBaseDamage = value;
    }

    protected boolean canHitEntity(Entity entity) {
        return entity != this.getOwner();
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        if (!this.level().isClientSide()) {
            LivingEntity livingEntity;
            Entity entity = entityHitResult.getEntity();
            if (entity instanceof LivingEntity && this.target.test(livingEntity = (LivingEntity)entity)) {
                entity.hurt(this.level().damageSources().mobProjectile((Entity)this, (LivingEntity)this.getOwner()), this.getDamage());
                for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                    livingEntity.addEffect(instance);
                }
            }
            if (entity instanceof Boat) {
                Boat boat = (Boat)entity;
                boat.setDamage(50.0f);
            }
        } else {
            super.onHitEntity(entityHitResult);
        }
    }

    protected void onHitBlock(BlockHitResult hitResult) {
        super.onHitBlock(hitResult);
        if (this.level().getBlockState(hitResult.getBlockPos()).isSolidRender((BlockGetter)this.level(), hitResult.getBlockPos())) {
            this.discard();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.tickCount >= 300) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        Vec3 vec3 = this.getDeltaMovement();
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.setPos(d0, d1, d2);
        if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.onHit(hitresult);
        }
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)Sitems.BILE.get());
    }
}

