/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.Utility.NukeEntity;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FleshBomb
extends AbstractArrow {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(FleshBomb.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> BOMB_TYPE = SynchedEntityData.defineId(FleshBomb.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> EXPLOSION = SynchedEntityData.defineId(FleshBomb.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> CARRIER = SynchedEntityData.defineId(FleshBomb.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private Predicate<LivingEntity> livingEntityPredicate = entity -> true;
    @Nullable
    private Entity target;

    public FleshBomb(Level level, LivingEntity entity2, float damage, BombType type, int range) {
        super(Sentities.FLESH_BOMB.get(), level);
        this.setBombType(type.getValue());
        this.setExplosion(range);
        this.setDamage(damage);
        this.setOwner((Entity)entity2);
    }

    public void setTarget(Entity entity) {
        this.target = entity;
    }

    public FleshBomb(EntityType<FleshBomb> fleshBombEntityType, Level level) {
        super(fleshBombEntityType, level);
    }

    public FleshBomb(Level level) {
        super(Sentities.FLESH_BOMB.get(), level);
    }

    public void setLivingEntityPredicate(Predicate<LivingEntity> value) {
        this.livingEntityPredicate = value;
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DAMAGE, (Object)Float.valueOf(2.0f));
        builder.define(BOMB_TYPE, (Object)0);
        builder.define(EXPLOSION, (Object)5);
        builder.define(CARRIER, (Object)false);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setDamage(tag.getFloat("damage"));
        this.setBombType(tag.getInt("bomb_type"));
        this.setExplosion(tag.getInt("explosion"));
        this.setCarrier(tag.getBoolean("carrier"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("damage", this.getDamage());
        tag.putInt("bomb_type", this.getBombType());
        tag.putInt("explosion", this.getExplosion());
        tag.putBoolean("carrier", this.getCarrier());
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DAMAGE)).floatValue();
    }

    public void setDamage(float value) {
        this.entityData.set(DAMAGE, (Object)Float.valueOf(value));
    }

    public int getBombType() {
        return (Integer)this.entityData.get(BOMB_TYPE);
    }

    public void setBombType(int value) {
        this.entityData.set(BOMB_TYPE, (Object)value);
    }

    public int getExplosion() {
        return (Integer)this.entityData.get(EXPLOSION);
    }

    public void setExplosion(int value) {
        this.entityData.set(EXPLOSION, (Object)value);
    }

    public boolean getCarrier() {
        return (Boolean)this.entityData.get(CARRIER);
    }

    public void setCarrier(boolean value) {
        this.entityData.set(CARRIER, (Object)value);
    }

    protected boolean canHitEntity(Entity entity) {
        LivingEntity living;
        return entity instanceof LivingEntity && this.livingEntityPredicate.test(living = (LivingEntity)entity);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity2 = result.getEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Utilities.explodeCircle(serverLevel, this.getOwner(), result.getEntity().getOnPos(), this.getExplosion(), this.getDamage(), 8.0, entity -> {
                    LivingEntity livingEntity;
                    return entity instanceof LivingEntity && this.livingEntityPredicate.test(livingEntity = (LivingEntity)entity);
                });
                if (this.getBombType() == 1) {
                    living.setRemainingFireTicks(400);
                    Utilities.convertBlocks(serverLevel, this.getOwner(), result.getEntity().getOnPos(), this.getExplosion(), Blocks.FIRE.defaultBlockState());
                }
                if (this.getBombType() == 2) {
                    Utilities.convertBlocks(serverLevel, this.getOwner(), result.getEntity().getOnPos(), this.getExplosion(), ((LiquidBlock)Sblocks.BILE.get()).defaultBlockState());
                }
                if (this.getBombType() == 4) {
                    NukeEntity nukeEntity = new NukeEntity(Sentities.NUKE.get(), this.level());
                    nukeEntity.setInitRange(1.0f);
                    nukeEntity.setRange((float)((Double)SConfig.SERVER.nuke_range.get() * 1.0));
                    nukeEntity.setInitDuration(0);
                    nukeEntity.setDuration((Integer)SConfig.SERVER.nuke_time.get());
                    nukeEntity.setDamage((float)((Double)SConfig.SERVER.nuke_damage.get() * 1.0));
                    nukeEntity.livingEntityPredicate = this.livingEntityPredicate;
                    nukeEntity.setPos(living.getX(), living.getY(), living.getZ());
                    this.level().addFreshEntity((Entity)nukeEntity);
                }
            }
        }
        this.discard();
    }

    public void tick() {
        super.tick();
        if (this.tickCount % 70 == 0) {
            this.playSound(Ssounds.FALLING_BOMB.get());
        }
        if (this.getBombType() == 1) {
            for (int i = 0; i < 360; ++i) {
                if (i % 40 != 0) continue;
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(), this.getY(), this.getZ(), Math.cos(i) * 0.25, 0.25, Math.sin(i) * 0.25);
            }
        }
        this.aimForTarget();
    }

    private float calculate(Entity entity, Entity entity1) {
        float f = (float)(entity.getX() - entity1.getX());
        float f2 = (float)(entity.getZ() - entity1.getZ());
        return Mth.sqrt((float)(f * f + f2 * f2));
    }

    private void aimForTarget() {
        if (this.target != null && this.getDeltaMovement().y < 0.0) {
            Vec3 vec3 = this.getDeltaMovement();
            Vec3 vec31 = new Vec3(this.target.getX() - this.getX(), 0.0, this.target.getZ() - this.getZ());
            if (vec31.lengthSqr() > 1.0E-7) {
                vec31 = vec31.normalize().scale(0.05);
            }
            if (this.target != null && this.calculate((Entity)this, this.target) < 3.5f) {
                this.setDeltaMovement(new Vec3(vec31.x, vec3.y, vec31.z));
            } else {
                this.setDeltaMovement(vec3.add(vec31.x, 0.0, vec31.z));
            }
        }
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)SoundEvents.GENERIC_EXPLODE.value();
    }

    protected void onHitBlock(BlockHitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Utilities.explodeCircle(serverLevel, this.getOwner(), result.getBlockPos(), this.getExplosion(), this.getDamage(), ((Integer)SConfig.SERVER.calamity_bd.get()).intValue(), entity -> {
                LivingEntity livingEntity;
                return entity instanceof LivingEntity && this.livingEntityPredicate.test(livingEntity = (LivingEntity)entity);
            });
            if (this.getBombType() == 1) {
                Utilities.convertBlocks(serverLevel, this.getOwner(), result.getBlockPos(), this.getExplosion(), Blocks.FIRE.defaultBlockState());
            }
            if (this.getBombType() == 2) {
                Utilities.convertBlocks(serverLevel, this.getOwner(), result.getBlockPos(), this.getExplosion(), ((LiquidBlock)Sblocks.BILE.get()).defaultBlockState());
            }
            if (this.getBombType() == 3) {
                this.summonAcid(this.getX(), this.getY() - (double)(this.getExplosion() - 2), this.getZ(), this.getExplosion());
            }
            if (this.getBombType() == 4) {
                NukeEntity nukeEntity = new NukeEntity(Sentities.NUKE.get(), this.level());
                nukeEntity.setInitRange(1.0f);
                nukeEntity.setRange((float)((Double)SConfig.SERVER.nuke_range.get() * 1.0));
                nukeEntity.setInitDuration(0);
                nukeEntity.setDuration((Integer)SConfig.SERVER.nuke_time.get());
                nukeEntity.setDamage((float)((Double)SConfig.SERVER.nuke_damage.get() * 1.0));
                nukeEntity.livingEntityPredicate = this.livingEntityPredicate;
                nukeEntity.setPos(result.getBlockPos().getX(), result.getBlockPos().getY() - this.getExplosion() + 1, result.getBlockPos().getZ());
                this.level().addFreshEntity((Entity)nukeEntity);
            }
            if (this.getCarrier()) {
                this.SummonInfected(serverLevel);
            }
            this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value());
        }
        this.discard();
    }

    private void summonAcid(double x, double y, double z, int range) {
        AreaEffectCloud cloud = new AreaEffectCloud(this.level(), x, y, z);
        cloud.addEffect(new MobEffectInstance(Seffects.CORROSION, 300, 1));
        cloud.setRadius((float)range);
        this.level().addFreshEntity((Entity)cloud);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        super.onSyncedDataUpdated(accessor);
        if (accessor.equals(CARRIER)) {
            this.refreshDimensions();
        }
    }

    public EntityDimensions getDimensions(Pose pose) {
        return this.getCarrier() ? super.getDimensions(pose).scale(2.0f) : super.getDimensions(pose);
    }

    private void SummonInfected(ServerLevel serverLevel) {
        int randomIndex;
        List values = (List)SConfig.SERVER.howit_summmons.get();
        ResourceLocation randomElement1 = ResourceLocation.parse((String)((String)values.get(randomIndex = this.random.nextInt(values.size()))));
        EntityType<?> randomElement = Utilities.tryToCreateEntity(randomElement1);
        Mob waveentity = (Mob)randomElement.create(this.level());
        if (waveentity != null) {
            waveentity.setPos(this.getX(), this.getY(), this.getZ());
            waveentity.finalizeSpawn((ServerLevelAccessor)serverLevel, this.level().getCurrentDifficultyAt(new BlockPos((int)this.getX(), (int)this.getY(), (int)this.getZ())), MobSpawnType.NATURAL, null);
            serverLevel.addFreshEntity((Entity)waveentity);
        }
    }

    public static enum BombType {
        BASIC(0),
        FLAME(1),
        BILE(2),
        ACID(3),
        NUCLEAR(4);

        private final int value;

        private BombType(int value1) {
            this.value = value1;
        }

        public int getValue() {
            return this.value;
        }
    }
}

