/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class StingerProjectile
extends AbstractArrow {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(StingerProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public StingerProjectile(Level level) {
        super(Sentities.STINGER.get(), level);
    }

    public StingerProjectile(Level level, LivingEntity living, float damage) {
        super(Sentities.STINGER.get(), level);
        this.setOwner((Entity)living);
        this.setDamage(Float.valueOf(damage));
    }

    public Float getDamage() {
        return (Float)this.entityData.get(DAMAGE);
    }

    public void setDamage(Float value) {
        this.entityData.set(DAMAGE, (Object)value);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setDamage(Float.valueOf(tag.getFloat("damage")));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("damage", this.getDamage().floatValue());
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            this.hurt(this.level().damageSources().mobProjectile((Entity)this, (LivingEntity)this.getOwner()), this.getDamage().floatValue());
            living.addEffect(new MobEffectInstance(Seffects.CORROSION, 200, 0));
            living.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 0));
            living.setArrowCount(living.getArrowCount() - 1);
        }
        this.discard();
    }

    protected void onHitBlock(BlockHitResult p_36755_) {
        super.onHitBlock(p_36755_);
        this.discard();
    }

    protected boolean canHitEntity(Entity entity) {
        return !(entity instanceof UtilityEntity) && !(entity instanceof Infected) && super.canHitEntity(entity);
    }

    public void tick() {
        super.tick();
        if (this.tickCount % 200 == 0) {
            this.discard();
        }
    }

    protected float getWaterInertia() {
        return 0.99f;
    }
}

