/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Recipes.SporeForcedRecipes.InjectionSuctionRecipe;
import com.Harbinger.Spore.Sitems.Agents.AbstractSyringe;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Sitems;
import com.Harbinger.Spore.core.Ssounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class SyringeProjectile
extends AbstractArrow {
    private static final String SYRINGE_COMPONENT = "syringe_item";
    private ItemStack itemStack;

    public SyringeProjectile(Level level) {
        super(Sentities.THROWN_SYRINGE.get(), level);
        this.itemStack = new ItemStack((ItemLike)Sitems.SYRINGE.get());
    }

    public SyringeProjectile(Level level, LivingEntity living, float damage, ItemStack stack) {
        super(Sentities.STINGER.get(), level);
        this.setOwner((Entity)living);
        this.setBaseDamage(damage);
        this.setItemStack(stack);
    }

    public void setItemStack(ItemStack stack) {
        this.itemStack = stack;
    }

    protected ItemStack getPickupItem() {
        return this.itemStack;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Sitems.SYRINGE.get());
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Syringe", 10)) {
            this.itemStack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)tag.getCompound("Syringe")).orElse(ItemStack.EMPTY);
        } else if (tag.contains(SYRINGE_COMPONENT, 10)) {
            this.itemStack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)tag.getCompound(SYRINGE_COMPONENT)).orElse(ItemStack.EMPTY);
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (!this.itemStack.isEmpty()) {
            tag.put(SYRINGE_COMPONENT, this.itemStack.save((HolderLookup.Provider)this.registryAccess()));
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!this.level().isClientSide && this.canHitEntity((Entity)living)) {
                Item item;
                if (this.itemStack.getItem().equals(Sitems.SYRINGE.get())) {
                    InjectionSuctionRecipe.Recipe match = InjectionSuctionRecipe.getUsableRecipe(this.level(), living);
                    if (match != null && Math.random() < 0.5) {
                        ItemStack stack = new ItemStack((ItemLike)match.output());
                        ItemEntity itemEntity = new ItemEntity(this.level(), entity.getX(), entity.getY(), entity.getZ(), stack);
                        this.level().addFreshEntity((Entity)itemEntity);
                    }
                    this.playSound(Ssounds.SYRINGE_SUCK.get());
                }
                if ((item = this.itemStack.getItem()) instanceof AbstractSyringe) {
                    AbstractSyringe syringe = (AbstractSyringe)item;
                    syringe.useSyringe(this.itemStack, living);
                    this.playSound(Ssounds.SYRINGE_GUN_INJECT.get());
                }
                living.hurt(this.level().damageSources().mobProjectile((Entity)this, (LivingEntity)this.getOwner()), (float)this.getBaseDamage());
            }
        }
    }

    protected void onHitBlock(BlockHitResult p_36755_) {
        super.onHitBlock(p_36755_);
        this.discard();
    }

    protected boolean canHitEntity(Entity entity) {
        return !entity.equals((Object)this.getOwner()) && super.canHitEntity(entity);
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return Ssounds.SYRINGE_GUN_INJECT.get();
    }
}

