/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.core.Sentities;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class ThrownBlockProjectile
extends Projectile {
    private Predicate<LivingEntity> victim = livingEntity -> true;
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(ThrownBlockProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<BlockState> STATE = SynchedEntityData.defineId(ThrownBlockProjectile.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);

    public ThrownBlockProjectile(Level level) {
        super(Sentities.THROWN_BLOCK.get(), level);
        this.entityData.set(STATE, (Object)Blocks.GRASS_BLOCK.defaultBlockState());
    }

    public ThrownBlockProjectile(Level level, LivingEntity livingEntity2, Float damage, BlockState state, Predicate<LivingEntity> livingEntityPredicate) {
        super(Sentities.THROWN_BLOCK.get(), level);
        this.setOwner((Entity)livingEntity2);
        this.entityData.set(DAMAGE, (Object)damage);
        this.entityData.set(STATE, (Object)state);
        this.victim = livingEntityPredicate;
    }

    public BlockState state() {
        return (BlockState)this.entityData.get(STATE);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DAMAGE, (Object)Float.valueOf(tag.getFloat("damage")));
        this.entityData.set(STATE, (Object)NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)tag.getCompound("state")));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("damage", ((Float)this.entityData.get(DAMAGE)).floatValue());
        tag.put("state", (Tag)NbtUtils.writeBlockState((BlockState)((BlockState)this.entityData.get(STATE))));
    }

    protected boolean canHitEntity(Entity entity) {
        LivingEntity livingEntity;
        return entity != this.getOwner() || entity instanceof LivingEntity && this.victim.test(livingEntity = (LivingEntity)entity);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DAMAGE, (Object)Float.valueOf(5.0f));
        builder.define(STATE, (Object)Blocks.GRASS_BLOCK.defaultBlockState());
    }

    public void tick() {
        super.tick();
        if (this.tickCount >= 300) {
            this.remove(Entity.RemovalReason.DISCARDED);
            FallingBlockEntity.fall((Level)this.level(), (BlockPos)new BlockPos((int)this.getX(), (int)this.getY(), (int)this.getZ()), (BlockState)((BlockState)this.entityData.get(STATE)));
        }
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        Vec3 vec3 = this.getDeltaMovement().add(0.0, -0.1, 0.0);
        double d0 = this.getX() + vec3.x;
        double d1 = this.getY() + vec3.y;
        double d2 = this.getZ() + vec3.z;
        this.setPos(d0, d1, d2);
        if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.onHit(hitresult);
        }
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        super.onHitEntity(result);
        if (!this.level().isClientSide && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity1;
            Entity entity2;
            LivingEntity livingEntity = (LivingEntity)entity;
            BlockPos pos = new BlockPos((int)this.getX(), (int)this.getY(), (int)this.getZ());
            livingEntity.hurt(this.level().damageSources().mobProjectile((Entity)this, (entity2 = this.getOwner()) instanceof LivingEntity ? (livingEntity1 = (LivingEntity)entity2) : null), ((Float)this.entityData.get(DAMAGE)).floatValue() * ((BlockState)this.entityData.get(STATE)).getDestroySpeed((BlockGetter)this.level(), pos));
            FallingBlockEntity.fall((Level)this.level(), (BlockPos)pos, (BlockState)((BlockState)this.entityData.get(STATE)));
            this.discard();
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        BlockPos pos = result.getBlockPos().relative(result.getDirection()).above();
        FallingBlockEntity.fall((Level)this.level(), (BlockPos)pos, (BlockState)((BlockState)this.entityData.get(STATE)));
        this.discard();
    }
}

