/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Fluids.BileLiquid;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Senchantments;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Sitems;
import com.Harbinger.Spore.core.Ssounds;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownBoomerang
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(ThrownBoomerang.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(ThrownBoomerang.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private ItemStack boomerang = new ItemStack((ItemLike)Sitems.BOOMERANG.get());
    private boolean dealtDamage;
    private int returnTick;

    public ThrownBoomerang(Level level, LivingEntity owner, ItemStack stack, int color) {
        super(Sentities.THROWN_BOOMERANG.get(), level);
        this.setOwner((Entity)owner);
        this.boomerang = stack.copy();
        this.entityData.set(ID_FOIL, (Object)stack.hasFoil());
        this.entityData.set(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public ItemStack getBoomerang() {
        return this.boomerang;
    }

    public ThrownBoomerang(EntityType<ThrownBoomerang> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_FOIL, (Object)false);
        builder.define(COLOR, (Object)0);
    }

    public void tick() {
        if (this.inGroundTime > 4 || this.returnTick++ > 35) {
            this.dealtDamage = true;
        }
        Entity owner = this.getOwner();
        if ((this.dealtDamage || this.isNoPhysics()) && owner != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3 direction = owner.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + direction.y * 0.045, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(direction.normalize().scale(0.15)));
            }
        }
        super.tick();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity owner = this.getOwner();
        return owner != null && owner.isAlive() && (!(owner instanceof ServerPlayer) || !owner.isSpectator());
    }

    protected ItemStack getPickupItem() {
        return this.boomerang.copy();
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Sitems.BOOMERANG.get());
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 from, Vec3 to) {
        return this.dealtDamage ? null : super.findHitEntity(from, to);
    }

    protected void onHitBlock(BlockHitResult result) {
        this.dealtDamage = true;
        super.onHitBlock(result);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity target = result.getEntity();
        int sharpnessLevel = EnchantmentHelper.getTagEnchantmentLevel(Senchantments.getEnchantment((LevelAccessor)this.level(), (ResourceKey<Enchantment>)Enchantments.SHARPNESS), (ItemStack)this.boomerang);
        int fireAspectLevel = EnchantmentHelper.getTagEnchantmentLevel(Senchantments.getEnchantment((LevelAccessor)this.level(), (ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT), (ItemStack)this.boomerang);
        float baseDamage = (float)((Integer)SConfig.SERVER.boomerang_damage.get()).intValue() + 0.5f * (float)sharpnessLevel;
        Entity owner = this.getOwner();
        DamageSource source = this.damageSources().trident((Entity)this, (Entity)(owner == null ? this : owner));
        this.dealtDamage = true;
        if (target.hurt(source, baseDamage)) {
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                if (owner instanceof LivingEntity) {
                    LivingEntity ownerLiving = (LivingEntity)owner;
                    Level level = this.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)living, (DamageSource)source);
                        Item item = this.boomerang.getItem();
                        if (item instanceof SporeWeaponData) {
                            SporeWeaponData data = (SporeWeaponData)item;
                            data.abstractMutationBuffs(living, ownerLiving, this.boomerang, data);
                        }
                    }
                }
                if (fireAspectLevel > 0) {
                    target.setRemainingFireTicks(80 * fireAspectLevel);
                }
                ThrownBoomerang.abstractEffects(this.boomerang, living);
                this.doPostHurtEffects(living);
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
            this.playSound(Ssounds.INFECTED_WEAPON_HIT_ENTITY.get(), 1.0f, 1.0f);
        }
    }

    protected boolean tryPickup(Player player) {
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    public boolean isNoGravity() {
        return true;
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return Ssounds.INFECTED_WEAPON_HIT_BLOCK.get();
    }

    public void playerTouch(Player player) {
        if (this.ownedBy((Entity)player) || this.getOwner() == null) {
            super.playerTouch(player);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Boomerang", 10)) {
            CompoundTag boomerangTag = tag.getCompound("Boomerang");
            this.boomerang = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)boomerangTag).orElse(new ItemStack((ItemLike)Sitems.BOOMERANG.get()));
        }
        this.dealtDamage = tag.getBoolean("DealtDamage");
        this.entityData.set(COLOR, (Object)tag.getInt("color"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("Boomerang", this.boomerang.save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        tag.putBoolean("DealtDamage", this.dealtDamage);
        tag.putInt("color", ((Integer)this.entityData.get(COLOR)).intValue());
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    public static void abstractEffects(ItemStack stack, LivingEntity livingEntity) {
        if (Senchantments.hasEnchant((LevelAccessor)livingEntity.level(), stack, Senchantments.CORROSIVE_POTENCY)) {
            livingEntity.addEffect(new MobEffectInstance(Seffects.CORROSION, 200, 1));
        }
        if (Senchantments.hasEnchant((LevelAccessor)livingEntity.level(), stack, Senchantments.GASTRIC_SPEWAGE)) {
            for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                livingEntity.addEffect(instance);
            }
        }
        if (Senchantments.hasEnchant((LevelAccessor)livingEntity.level(), stack, Senchantments.CRYOGENIC_ASPECT)) {
            livingEntity.setTicksFrozen(livingEntity.getTicksFrozen() + 300);
        }
    }
}

