/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.core.Sentities;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class ThrownItemProjectile
extends AbstractArrow {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(ThrownItemProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final ItemStack stack;
    private Predicate<LivingEntity> livingEntityPredicate = entity -> true;

    public ThrownItemProjectile(Level level) {
        super(Sentities.THROWN_TOOL.get(), level);
        this.stack = new ItemStack((ItemLike)Items.IRON_AXE);
    }

    public ThrownItemProjectile(Level level, LivingEntity living, float damage, ItemStack stack) {
        super(Sentities.THROWN_TOOL.get(), level);
        this.setOwner((Entity)living);
        this.moveTo(living.getX(), living.getY() + (double)1.2f, living.getZ());
        this.setDamage(Float.valueOf(damage));
        this.stack = stack;
    }

    public void setLivingEntityPredicate(Predicate<LivingEntity> value) {
        this.livingEntityPredicate = value;
    }

    public Float getDamage() {
        return (Float)this.entityData.get(DAMAGE);
    }

    public void setDamage(Float value) {
        this.entityData.set(DAMAGE, (Object)value);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public ItemStack getItem() {
        return this.stack;
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setDamage(Float.valueOf(tag.getFloat("damage")));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("damage", this.getDamage().floatValue());
    }

    protected void onHitEntity(EntityHitResult result) {
        super.onHitEntity(result);
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.setArrowCount(living.getArrowCount() - 1);
        }
        this.discard();
    }

    protected void onHitBlock(BlockHitResult p_36755_) {
        super.onHitBlock(p_36755_);
        this.discard();
    }

    protected boolean canHitEntity(Entity entity) {
        LivingEntity living;
        return entity instanceof LivingEntity && this.livingEntityPredicate.test(living = (LivingEntity)entity);
    }

    public void tick() {
        super.tick();
        if (this.tickCount % 200 == 0) {
            this.discard();
        }
    }

    protected float getWaterInertia() {
        return 0.99f;
    }
}

