/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Fluids.BileLiquid;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import com.Harbinger.Spore.Sitems.InfectedSickle;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Senchantments;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Sitems;
import com.Harbinger.Spore.core.Ssounds;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownSickle
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(ThrownSickle.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(ThrownSickle.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private ItemStack spearItem = new ItemStack((ItemLike)Sitems.SICKLE.get());
    private boolean dealtDamage;
    private SickelState state = SickelState.FLYING;
    private Entity hookedEntity = null;
    private Vec3 hookedBlockPos = null;

    public ThrownSickle(Level level, LivingEntity livingEntity, ItemStack stack, int color) {
        super(Sentities.THROWN_SICKEL.get(), level);
        this.setOwner((Entity)livingEntity);
        this.spearItem = stack.copy();
        this.entityData.set(ID_FOIL, (Object)stack.hasFoil());
        this.entityData.set(COLOR, (Object)color);
    }

    public ThrownSickle(Level level) {
        super(Sentities.THROWN_SICKEL.get(), level);
    }

    public ThrownSickle(EntityType<ThrownSickle> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_FOIL, (Object)false);
        builder.define(COLOR, (Object)0);
    }

    public ItemStack getSpearItem() {
        return this.spearItem.copy();
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public void tick() {
        Entity owner;
        if (this.state == SickelState.HOOKED_IN_ENTITY && this.hookedEntity != null && this.hookedEntity.isAlive()) {
            this.setPos(this.hookedEntity.getX(), this.hookedEntity.getY() + (double)this.hookedEntity.getBbHeight() * 0.5, this.hookedEntity.getZ());
        }
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        if ((owner = this.getOwner()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)owner;
            ItemStack stack = living.getMainHandItem();
            if (this.distanceTo((Entity)living) > 30.0f || !(stack.getItem() instanceof InfectedSickle)) {
                Item item = stack.getItem();
                if (item instanceof InfectedSickle) {
                    InfectedSickle sickle = (InfectedSickle)item;
                    sickle.setThrownSickle(stack, false);
                }
                this.discard();
            }
        } else {
            this.discard();
        }
        super.tick();
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 from, Vec3 to) {
        return this.dealtDamage ? null : super.findHitEntity(from, to);
    }

    protected void onHitEntity(EntityHitResult hit) {
        Entity entity = hit.getEntity();
        int sharpnessLevel = EnchantmentHelper.getTagEnchantmentLevel(Senchantments.getEnchantment((LevelAccessor)this.level(), (ResourceKey<Enchantment>)Enchantments.SHARPNESS), (ItemStack)this.spearItem);
        int fireAspectLevel = EnchantmentHelper.getTagEnchantmentLevel(Senchantments.getEnchantment((LevelAccessor)this.level(), (ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT), (ItemStack)this.spearItem);
        float baseDamage = (float)((Integer)SConfig.SERVER.sickle_damage.get()).intValue() + 0.5f * (float)sharpnessLevel;
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().trident((Entity)this, (Entity)(entity1 == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = Ssounds.INFECTED_WEAPON_HIT_ENTITY.get();
        if (entity.hurt(damagesource, baseDamage)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (entity1 instanceof LivingEntity) {
                        LivingEntity ownerLiving = (LivingEntity)entity1;
                        EnchantmentHelper.doPostAttackEffects((ServerLevel)serverLevel, (Entity)entity, (DamageSource)damagesource);
                        Item item = this.spearItem.getItem();
                        if (item instanceof SporeWeaponData) {
                            SporeWeaponData data = (SporeWeaponData)item;
                            data.abstractMutationBuffs(livingEntity, ownerLiving, this.spearItem, data);
                        }
                    }
                    if (fireAspectLevel > 0) {
                        entity.setRemainingFireTicks(80 * fireAspectLevel);
                    }
                    ThrownSickle.abstractEffects(this.spearItem, livingEntity);
                    this.doPostHurtEffects(livingEntity);
                }
            }
        }
        this.hookedEntity = entity;
        this.state = SickelState.HOOKED_IN_ENTITY;
        this.playSound(soundevent, 1.0f, 1.0f);
    }

    protected boolean tryPickup(Player player) {
        return false;
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.hookedBlockPos = result.getLocation();
        this.state = SickelState.HOOKED_BLOCK;
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return Ssounds.INFECTED_WEAPON_HIT_BLOCK.get();
    }

    public SickelState getHookState() {
        return this.state;
    }

    public Entity getHookedEntity() {
        return this.hookedEntity;
    }

    public Vec3 getHookedBlockPos() {
        return this.hookedBlockPos;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Sickle", 10)) {
            CompoundTag sickleTag = tag.getCompound("Sickle");
            this.spearItem = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)sickleTag).orElse(new ItemStack((ItemLike)Sitems.SICKLE.get()));
        }
        this.dealtDamage = tag.getBoolean("DealtDamage");
        if (this.getOwner() != null) {
            tag.putUUID("OwnerUUID", this.getOwner().getUUID());
        }
        this.entityData.set(COLOR, (Object)tag.getInt("color"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.put("Sickle", this.spearItem.save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        tag.putBoolean("DealtDamage", this.dealtDamage);
        tag.putInt("color", ((Integer)this.entityData.get(COLOR)).intValue());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        Entity entity = this.getOwner();
        if (entity != null) {
            Entity entity1;
            UUID uuid1 = entity.getUUID();
            if (!this.level().isClientSide && (entity1 = ((ServerLevel)this.level()).getEntity(uuid1)) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity1;
                this.setOwner((Entity)livingEntity);
            }
        }
    }

    public void tickDespawn() {
        if (this.pickup != AbstractArrow.Pickup.ALLOWED) {
            super.tickDespawn();
        }
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    public static void abstractEffects(ItemStack stack, LivingEntity livingEntity) {
        if (Senchantments.hasEnchant((LevelAccessor)livingEntity.level(), stack, Senchantments.CORROSIVE_POTENCY)) {
            livingEntity.addEffect(new MobEffectInstance(Seffects.CORROSION, 200, 1));
        }
        if (Senchantments.hasEnchant((LevelAccessor)livingEntity.level(), stack, Senchantments.GASTRIC_SPEWAGE)) {
            for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                livingEntity.addEffect(instance);
            }
        }
        if (Senchantments.hasEnchant((LevelAccessor)livingEntity.level(), stack, Senchantments.CRYOGENIC_ASPECT)) {
            livingEntity.setTicksFrozen(livingEntity.getTicksFrozen() + 300);
        }
    }

    public static enum SickelState {
        FLYING,
        HOOKED_IN_ENTITY,
        HOOKED_BLOCK;

    }
}

