/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Fluids.BileLiquid;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Senchantments;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Sitems;
import com.Harbinger.Spore.core.Ssounds;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownSpear
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.defineId(ThrownSpear.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(ThrownSpear.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(ThrownSpear.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private ItemStack spearItem = new ItemStack((ItemLike)Sitems.INFECTED_SPEAR.get());
    private boolean dealtDamage;
    public int clientSideReturnTridentTickCount;

    public ThrownSpear(Level p_37569_, ItemStack stack, LivingEntity owner, int color) {
        super(Sentities.THROWN_SPEAR.get(), p_37569_);
        this.setOwner((Entity)owner);
        this.spearItem = stack.copy();
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(stack));
        this.entityData.set(ID_FOIL, (Object)stack.hasFoil());
        this.entityData.set(COLOR, (Object)color);
    }

    public ThrownSpear(Level level) {
        super(Sentities.THROWN_SPEAR.get(), level);
    }

    public ThrownSpear(EntityType<ThrownSpear> thrownSpearEntityType, Level level) {
        super(thrownSpearEntityType, level);
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_LOYALTY, (Object)0);
        builder.define(ID_FOIL, (Object)false);
        builder.define(COLOR, (Object)0);
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.getOwner();
        byte i = (Byte)this.entityData.get(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3 vec3 = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + vec3.y * 0.015 * (double)i, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double d0 = 0.05 * (double)i;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.tick();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !(entity instanceof ServerPlayer) || !entity.isSpectator();
        }
        return false;
    }

    protected ItemStack getPickupItem() {
        return this.spearItem.copy();
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Sitems.INFECTED_SPEAR.get());
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 p_37575_, Vec3 p_37576_) {
        return this.dealtDamage ? null : super.findHitEntity(p_37575_, p_37576_);
    }

    protected void onHitEntity(EntityHitResult hit) {
        Entity entity = hit.getEntity();
        float f = (float)((Integer)SConfig.SERVER.spear_damage.get()).intValue() + 0.5f * (float)EnchantmentHelper.getItemEnchantmentLevel(Senchantments.getEnchantment((LevelAccessor)this.level(), (ResourceKey<Enchantment>)Enchantments.SHARPNESS), (ItemStack)this.spearItem);
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().trident((Entity)this, (Entity)(entity1 == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = Ssounds.INFECTED_WEAPON_HIT_ENTITY.get();
        if (entity.hurt(damagesource, f)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            if (entity instanceof LivingEntity) {
                int j;
                LivingEntity livingEntity = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    LivingEntity ownerLiving = (LivingEntity)entity1;
                    Item item = this.spearItem.getItem();
                    if (item instanceof SporeWeaponData) {
                        SporeWeaponData data = (SporeWeaponData)item;
                        data.abstractMutationBuffs(livingEntity, ownerLiving, this.spearItem, data);
                    }
                }
                if ((j = EnchantmentHelper.getItemEnchantmentLevel(Senchantments.getEnchantment((LevelAccessor)this.level(), (ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT), (ItemStack)this.spearItem)) > 0) {
                    entity.setRemainingFireTicks(80 * j);
                }
                ThrownSpear.abstractEffects(this.spearItem, livingEntity);
                this.doPostHurtEffects(livingEntity);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        float f1 = 1.0f;
        this.playSound(soundevent, f1, 1.0f);
    }

    protected boolean tryPickup(Player p_150196_) {
        return super.tryPickup(p_150196_) || this.isNoPhysics() && this.ownedBy((Entity)p_150196_) && p_150196_.getInventory().add(this.getPickupItem());
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return Ssounds.INFECTED_WEAPON_HIT_BLOCK.get();
    }

    public void playerTouch(Player p_37580_) {
        if (this.ownedBy((Entity)p_37580_) || this.getOwner() == null) {
            super.playerTouch(p_37580_);
        }
    }

    private byte getLoyaltyFromItem(ItemStack stack) {
        byte var10000;
        Level var3 = this.level();
        if (var3 instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)var3;
            var10000 = (byte)Mth.clamp((int)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverlevel, (ItemStack)stack, (Entity)this), (int)0, (int)127);
        } else {
            var10000 = 0;
        }
        return var10000;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.dealtDamage = compound.getBoolean("DealtDamage");
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(this.getPickupItemStackOrigin()));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DealtDamage", this.dealtDamage);
    }

    public void tickDespawn() {
        byte i = (Byte)this.entityData.get(ID_LOYALTY);
        if (this.pickup != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.tickDespawn();
        }
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }

    public static void abstractEffects(ItemStack stack, LivingEntity livingEntity) {
        if (Senchantments.hasEnchant((LevelAccessor)livingEntity.level(), stack, Senchantments.CORROSIVE_POTENCY)) {
            livingEntity.addEffect(new MobEffectInstance(Seffects.CORROSION, 200, 1));
        }
        if (Senchantments.hasEnchant((LevelAccessor)livingEntity.level(), stack, Senchantments.GASTRIC_SPEWAGE)) {
            for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                livingEntity.addEffect(instance);
            }
        }
        if (Senchantments.hasEnchant((LevelAccessor)livingEntity.level(), stack, Senchantments.CRYOGENIC_ASPECT)) {
            livingEntity.setTicksFrozen(livingEntity.getTicksFrozen() + 300);
        }
    }
}

