/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.Fluids.BileLiquid;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Sitems;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class ThrownTumor
extends ThrowableItemProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(ThrownTumor.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public Holder<MobEffect> mobEffect;
    public int duration = 600;
    public int potion_level = 1;
    public Level.ExplosionInteraction explode = Level.ExplosionInteraction.NONE;

    public ThrownTumor(EntityType<? extends ThrownTumor> type, Level level) {
        super(type, level);
    }

    public ThrownTumor(Level level, LivingEntity entity) {
        super(Sentities.THROWN_TUMOR.get(), entity, level);
    }

    public ThrownTumor(Level level) {
        super(Sentities.THROWN_TUMOR.get(), level);
    }

    public int getTumorType() {
        return this.entityData == null ? 0 : (Integer)this.entityData.get(TYPE);
    }

    @NotNull
    protected Item getDefaultItem() {
        int type = this.getTumorType();
        return switch (type) {
            case 1 -> (Item)Sitems.SICKEN_TUMOR.get();
            case 2 -> (Item)Sitems.CALCIFIED_TUMOR.get();
            case 3 -> (Item)Sitems.FROZEN_TUMOR.get();
            case 4 -> (Item)Sitems.BILE_TUMOR.get();
            default -> (Item)Sitems.TUMOR.get();
        };
    }

    public void handleEntityEvent(byte value) {
        if (value == 3) {
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    public void setMobEffect(Holder<MobEffect> effect) {
        this.mobEffect = effect;
    }

    public void setExplode(Level.ExplosionInteraction value) {
        this.explode = value;
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), (float)((Integer)SConfig.SERVER.tumor_explosion.get()).intValue(), this.explode);
            AABB aabb = this.getBoundingBox().inflate(3.0);
            List entities = this.level().getEntities((Entity)this, aabb);
            switch ((Integer)this.entityData.get(TYPE)) {
                case 0: {
                    this.summonPotionEffects();
                    break;
                }
                case 1: {
                    this.poisonTargets(entities);
                    break;
                }
                case 2: {
                    this.damageTargets(entities);
                    break;
                }
                case 3: {
                    this.freezeTargets(entities);
                    break;
                }
                case 4: {
                    this.bileTargets(entities);
                }
            }
            this.discard();
        }
    }

    public void summonPotionEffects() {
        AreaEffectCloud cloud = (AreaEffectCloud)EntityType.AREA_EFFECT_CLOUD.create(this.level());
        if (this.mobEffect != null && cloud != null) {
            cloud.addEffect(new MobEffectInstance(this.mobEffect, this.duration, this.potion_level));
            cloud.setDuration(160);
            cloud.setRadius(2.0f);
            cloud.moveTo(this.getX(), this.getY(), this.getZ());
            this.level().addFreshEntity((Entity)cloud);
        }
    }

    public void poisonTargets(List<Entity> entityList) {
        for (Entity entity : entityList) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 1));
            livingEntity.addEffect(new MobEffectInstance(Seffects.CORROSION, 200, 1));
        }
    }

    public void bileTargets(List<Entity> entityList) {
        for (Entity entity : entityList) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                livingEntity.addEffect(instance);
            }
        }
    }

    public void freezeTargets(List<Entity> entityList) {
        for (Entity entity : entityList) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.invulnerableTime = 0;
            livingEntity.hurt(this.level().damageSources().freeze(), 5.0f);
            livingEntity.setTicksFrozen(this.getTicksFrozen() + 200);
        }
    }

    public void damageTargets(List<Entity> entityList) {
        for (Entity entity : entityList) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            Entity entity2 = this.getOwner();
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity2;
            livingEntity.hurtTime = 0;
            livingEntity.invulnerableTime = 0;
            livingEntity.hurt(this.level().damageSources().mobProjectile((Entity)this, living), 10.0f);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TYPE, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(TYPE, (Object)tag.getInt("type"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("type", ((Integer)this.entityData.get(TYPE)).intValue());
    }

    public void setType(int value) {
        this.entityData.set(TYPE, (Object)value);
    }
}

