/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Sitems;
import java.util.Random;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class Vomit
extends AbstractArrow
implements ItemSupplier {
    public Vomit(Level level) {
        super(Sentities.ACID.get(), level);
    }

    public Vomit(EntityType<Vomit> vomitEntityType, Level level) {
        super(vomitEntityType, level);
    }

    public ItemStack getItem() {
        return new ItemStack((ItemLike)Sitems.ACID.get());
    }

    public void tick() {
        super.tick();
        if (this.inGround || this.isInFluidType()) {
            this.discard();
        }
    }

    public static Vomit shoot(Level world, LivingEntity entity, Random random, float power, double damage, int knockback) {
        Vomit entityarrow = new Vomit(Sentities.ACID.get(), world);
        entityarrow.setOwner((Entity)entity);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 0.1f, 0.0f);
        entityarrow.setBaseDamage(damage);
        world.addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }

    public static Vomit shoot(LivingEntity entity, LivingEntity target, float damage) {
        Vomit entityarrow = new Vomit(Sentities.ACID.get(), entity.level());
        entityarrow.setOwner((Entity)entity);
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 2.0;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.1f, dz, 2.0f, 12.0f);
        entityarrow.setBaseDamage(damage);
        entity.level().addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        LivingEntity living;
        Entity entity = hitResult.getEntity();
        if (entity instanceof LivingEntity && Utilities.TARGET_SELECTOR.Test(living = (LivingEntity)entity)) {
            super.onHitEntity(hitResult);
            this.levels(living);
        }
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    private void levels(LivingEntity living) {
        int level = 0;
        MobEffectInstance instance = living.getEffect(Seffects.CORROSION);
        if (instance != null) {
            level = instance.getAmplifier() + 1;
        }
        living.addEffect(new MobEffectInstance(Seffects.CORROSION, 300, level));
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.SLIME_JUMP_SMALL;
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }
}

