/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Projectile;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Fluids.BileLiquid;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Sparticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class VomitHohlBall
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> ORES = SynchedEntityData.defineId(VomitHohlBall.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> MEAT = SynchedEntityData.defineId(VomitHohlBall.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public VomitHohlBall(Level level) {
        super(Sentities.VOMIT_BALL.get(), level);
    }

    public VomitHohlBall(EntityType<VomitHohlBall> acidBallEntityType, Level level) {
        super(acidBallEntityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ORES, (Object)false);
        builder.define(MEAT, (Object)false);
    }

    public ItemStack getItem() {
        return ItemStack.EMPTY;
    }

    public void setOres(boolean val) {
        this.entityData.set(ORES, (Object)val);
    }

    public void setMeat(boolean val) {
        this.entityData.set(MEAT, (Object)val);
    }

    public void tick() {
        super.tick();
        this.makeBile((Boolean)this.entityData.get(MEAT));
        if (((Boolean)this.entityData.get(ORES)).booleanValue()) {
            this.makeOre();
        }
        if (this.inGround || this.isInFluidType()) {
            this.discard();
        }
    }

    private void makeBile(boolean val) {
        for (int i = 0; i < 8; ++i) {
            float movement1 = (this.random.nextFloat() - this.random.nextFloat()) * 0.5f;
            float movement2 = (this.random.nextFloat() - this.random.nextFloat()) * 0.5f;
            float movement3 = (this.random.nextFloat() - this.random.nextFloat()) * 0.5f;
            this.level().addParticle(val ? (ParticleOptions)Sparticles.VOMIT_BONE.get() : (ParticleOptions)Sparticles.VOMIT.get(), this.getX() + (double)movement1, this.getY() + (double)movement2, this.getZ() + (double)movement3, 0.0, 0.0, 0.0);
        }
    }

    private void makeOre() {
        for (int i = 0; i < 4; ++i) {
            float movement1 = (this.random.nextFloat() - this.random.nextFloat()) * 0.5f;
            float movement2 = (this.random.nextFloat() - this.random.nextFloat()) * 0.5f;
            float movement3 = (this.random.nextFloat() - this.random.nextFloat()) * 0.5f;
            this.level().addParticle((ParticleOptions)Sparticles.VOMIT_ORES.get(), this.getX() + (double)movement1, this.getY() + (double)movement2, this.getZ() + (double)movement3, 0.0, 0.0, 0.0);
        }
    }

    public static VomitHohlBall shoot(Level world, LivingEntity entity, float power, double damage, int knockback, boolean ore, boolean meat) {
        VomitHohlBall entityarrow = new VomitHohlBall(Sentities.VOMIT_BALL.get(), world);
        entityarrow.setOwner((Entity)entity);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setBaseDamage(damage);
        entityarrow.setOres(ore);
        entityarrow.setMeat(meat);
        world.addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }

    public static VomitHohlBall shoot(LivingEntity entity, LivingEntity target, float damage, boolean ore, boolean meat) {
        VomitHohlBall entityarrow = new VomitHohlBall(Sentities.VOMIT_BALL.get(), entity.level());
        entityarrow.setOwner((Entity)entity);
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 2.0;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 2.0f, 4.0f);
        entityarrow.setBaseDamage(damage);
        entityarrow.setOres(ore);
        entityarrow.setMeat(meat);
        entity.level().addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        this.discard();
    }

    protected ItemStack getPickupItem() {
        return ItemStack.EMPTY;
    }

    protected ItemStack getDefaultPickupItem() {
        return ItemStack.EMPTY;
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        LivingEntity living;
        Entity entity = hitResult.getEntity();
        if (entity instanceof LivingEntity && Utilities.TARGET_SELECTOR.Test(living = (LivingEntity)entity)) {
            super.onHitEntity(hitResult);
            this.addStuff(living);
        }
    }

    void addStuff(LivingEntity living) {
        if (Math.random() < 0.1) {
            living.addEffect(new MobEffectInstance(Seffects.CORROSION, 100, 1));
        }
        if (Math.random() < 0.1) {
            for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                living.addEffect(instance);
            }
        }
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.SLIME_JUMP_SMALL;
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }
}

