/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.Organoids.Usurper;
import com.Harbinger.Spore.Sentities.Organoids.Verwa;
import com.Harbinger.Spore.Sentities.Projectile.FleshBomb;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Sitems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.fluids.FluidType;

public class ArenaEntity
extends UtilityEntity {
    public static final EntityDataAccessor<Integer> BORROW = SynchedEntityData.defineId(ArenaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> EMERGE = SynchedEntityData.defineId(ArenaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> WAVE_SIZE = SynchedEntityData.defineId(ArenaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> WAVE_LEVEL = SynchedEntityData.defineId(ArenaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> SPECIAL_SPAWNS = SynchedEntityData.defineId(ArenaEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> START = SynchedEntityData.defineId(ArenaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private List<Entity> waveHosts = new ArrayList<Entity>();
    public List<FleshBomb.BombType> bombTypes = new ArrayList<FleshBomb.BombType>(){
        {
            this.add(FleshBomb.BombType.BASIC);
            this.add(FleshBomb.BombType.FLAME);
            this.add(FleshBomb.BombType.BILE);
            this.add(FleshBomb.BombType.ACID);
        }
    };

    public ArenaEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BORROW, (Object)0);
        builder.define(EMERGE, (Object)0);
        builder.define(WAVE_SIZE, (Object)0);
        builder.define(WAVE_LEVEL, (Object)0);
        builder.define(SPECIAL_SPAWNS, (Object)0);
        builder.define(START, (Object)false);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setWaveSize(compoundTag.getInt("size"));
        this.setWaveLevel(compoundTag.getInt("level"));
        this.setAmountOfSpecialSpawns(compoundTag.getInt("special"));
        this.startWave(compoundTag.getBoolean("start"));
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putInt("size", this.getWaveSize());
        compoundTag.putInt("level", this.getWaveLevel());
        compoundTag.putInt("special", this.getSpecialSpawns());
        compoundTag.putBoolean("start", this.isWaveActive());
    }

    public void setWaveSize(int size) {
        this.entityData.set(WAVE_SIZE, (Object)size);
    }

    public void setWaveLevel(int level) {
        this.entityData.set(WAVE_LEVEL, (Object)level);
    }

    public void setAmountOfSpecialSpawns(int amount) {
        this.entityData.set(SPECIAL_SPAWNS, (Object)amount);
    }

    public int getWaveSize() {
        return (Integer)this.entityData.get(WAVE_SIZE);
    }

    public int getWaveLevel() {
        return (Integer)this.entityData.get(WAVE_LEVEL);
    }

    public int getSpecialSpawns() {
        return (Integer)this.entityData.get(SPECIAL_SPAWNS);
    }

    public void startWave(boolean value) {
        this.entityData.set(START, (Object)value);
    }

    public boolean isWaveActive() {
        return (Boolean)this.entityData.get(START);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, 0.1).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ARMOR, 1.0).add(Attributes.FOLLOW_RANGE, 8.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
    }

    public boolean isEmerging() {
        return (Integer)this.entityData.get(EMERGE) > 0;
    }

    public void tickEmerging() {
        int emerging = (Integer)this.entityData.get(EMERGE);
        if (emerging > 60) {
            this.recalculateHosts();
            emerging = -1;
        }
        this.entityData.set(EMERGE, (Object)(emerging + 1));
    }

    public boolean isBurrowing() {
        return (Integer)this.entityData.get(BORROW) > 0;
    }

    public void tickBurrowing() {
        int burrowing = (Integer)this.entityData.get(BORROW);
        if (burrowing > 60) {
            burrowing = -1;
            if (this.isWaveActive()) {
                this.dropLoot();
            }
            this.discard();
        }
        this.entityData.set(BORROW, (Object)(burrowing + 1));
    }

    public int getEmerge() {
        return (Integer)this.entityData.get(EMERGE);
    }

    public int getBorrow() {
        return (Integer)this.entityData.get(BORROW);
    }

    public boolean hurt(DamageSource source, float p_21017_) {
        if (source.is(DamageTypes.FELL_OUT_OF_WORLD)) {
            return super.hurt(source, p_21017_);
        }
        return false;
    }

    public void recalculateHosts() {
        this.waveHosts.clear();
        this.waveHosts = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(16.0), entity -> entity instanceof LivingEntity && !(entity instanceof UtilityEntity) && !(entity instanceof Infected));
        if (!this.waveHosts.isEmpty()) {
            if (!this.isWaveActive()) {
                this.compareEntity(this.waveHosts);
            }
            for (Entity entity2 : this.waveHosts) {
                if (!(entity2.getY() > this.getY() + 3.0) || !(Math.random() < (double)0.1f)) continue;
                this.summonUsurper();
            }
        }
    }

    public boolean removeWhenFarAway(double p_21542_) {
        return false;
    }

    public void compareEntity(List<Entity> entities) {
        for (Entity entity : entities) {
            int i;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            for (i = 0; i < living.getArmorValue(); ++i) {
                if (i % 5 == 0) {
                    this.setWaveSize(this.getWaveSize() + 1);
                }
                if (i % 7 != 0) continue;
                this.setWaveLevel(this.getWaveLevel() + 1);
            }
            i = 0;
            while ((float)i < living.getMaxHealth()) {
                if (i % 4 == 0) {
                    this.setWaveSize(this.getWaveSize() + 1);
                }
                if (i % 50 == 0) {
                    this.setWaveLevel(this.getWaveLevel() + 1);
                }
                ++i;
            }
            if (living.hasEffect(Seffects.SYMBIOSIS)) {
                this.setAmountOfSpecialSpawns(this.getSpecialSpawns() + 1);
            }
            if (living instanceof InventoryCarrier) {
                InventoryCarrier carrier = (InventoryCarrier)living;
                int l = 0;
                boolean f = false;
                for (int e = 0; e < carrier.getInventory().getContainerSize(); ++e) {
                    ItemStack stack = carrier.getInventory().getItem(e);
                    if (stack.getItem().getFoodProperties(stack, null) != null) {
                        l += stack.getCount();
                    }
                    if (l % 32 != 0) continue;
                    this.setAmountOfSpecialSpawns(this.getSpecialSpawns() + 1);
                }
            }
            this.startWave(true);
        }
    }

    public void summonVerva(boolean special, List<? extends String> mob) {
        int X = this.random.nextInt(-16, 16);
        int Z = this.random.nextInt(-16, 16);
        String creature = mob.get(this.random.nextInt(mob.size()));
        Verwa verva = new Verwa(Sentities.VERVA.get(), this.level());
        verva.randomTeleport(this.getX() + (double)X, this.getY(), this.getZ() + (double)Z, false);
        verva.setStoredMob(creature);
        verva.tickEmerging();
        this.level().addFreshEntity((Entity)verva);
        if (special) {
            this.setAmountOfSpecialSpawns(this.getSpecialSpawns() - 1);
        } else {
            this.setWaveSize(this.getWaveSize() - 1);
        }
        if (this.getWaveLevel() >= 2 && Math.random() < (double)((float)(this.getWaveLevel() - 1) * 0.05f)) {
            this.summonBomb();
        }
    }

    public void summonUsurper() {
        int X = this.random.nextInt(-16, 16);
        int Z = this.random.nextInt(-16, 16);
        Usurper verva = new Usurper(Sentities.USURPER.get(), this.level());
        verva.randomTeleport(this.getX() + (double)X, this.getY(), this.getZ() + (double)Z, false);
        verva.tickEmerging();
        this.level().addFreshEntity((Entity)verva);
    }

    public void summonBomb() {
        int X = this.random.nextInt(-32, 32);
        int Z = this.random.nextInt(-32, 32);
        FleshBomb.BombType type = this.bombTypes.get(this.random.nextInt(this.bombTypes.size()));
        FleshBomb verva = new FleshBomb(this.level(), (LivingEntity)this, 10.0f, type, this.random.nextInt(2, 5));
        verva.setLivingEntityPredicate(Utilities.TARGET_SELECTOR_PREDICATE);
        verva.moveTo(this.getX() + (double)X, this.getY() + 100.0, this.getZ() + (double)Z);
        this.level().addFreshEntity((Entity)verva);
    }

    public Map<Integer, List<? extends String>> getWaveSpawns() {
        HashMap<Integer, List<? extends String>> values = new HashMap<Integer, List<? extends String>>();
        values.put(0, (List)SConfig.DATAGEN.raid_level_1.get());
        values.put(1, (List)SConfig.DATAGEN.raid_level_2.get());
        values.put(2, (List)SConfig.DATAGEN.raid_level_3.get());
        return values;
    }

    public void calculateSummons() {
        int e = this.getWaveSize() > 3 ? this.random.nextInt(4) : this.getWaveSize();
        int wave = Math.min(this.getWaveLevel(), 2);
        if (this.getWaveSize() <= 0 && this.checkForInfected() && this.isWaveActive()) {
            this.tickBurrowing();
            return;
        }
        for (int i = 0; i < e; ++i) {
            boolean special = this.getSpecialSpawns() > 0 && Math.random() < (double)0.1f;
            this.summonVerva(special, special ? (List<? extends String>)SConfig.DATAGEN.special.get() : this.getWaveSpawns().get(wave));
        }
        this.playSound(SoundEvents.BELL_RESONATE);
    }

    public boolean checkForInfected() {
        AABB aabb = this.getBoundingBox().inflate(8.0);
        List list = this.level().getEntities((Entity)this, aabb, entity -> (entity instanceof Infected || entity instanceof UtilityEntity) && !(entity instanceof ArenaEntity));
        return list.size() < 4;
    }

    public void tick() {
        super.tick();
        if (this.isBurrowing()) {
            this.tickBurrowing();
        }
        if (this.isEmerging()) {
            this.tickEmerging();
        }
        if (this.tickCount % 300 == 0) {
            this.calculateSummons();
        }
        if (this.tickCount % 40 == 0) {
            this.recalculateHosts();
        }
    }

    public void dropLoot() {
        for (String string : (List)SConfig.DATAGEN.drops.get()) {
            int i;
            Item item = Utilities.tryToCreateStack(ResourceLocation.parse((String)string)).getItem();
            int n = i = this.getWaveLevel() > 0 ? this.random.nextInt(this.getWaveLevel(), 3 * this.getWaveLevel()) : 1;
            if (!(Math.random() < (double)(0.2f * (float)Math.min(1, this.getWaveLevel())))) continue;
            ItemStack itemStack = new ItemStack((ItemLike)item, i);
            ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), itemStack);
            this.level().addFreshEntity((Entity)itemEntity);
        }
    }

    public boolean canBeSeenAsEnemy() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean isInvulnerable() {
        return true;
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (player.getItemInHand(hand).getItem() == Sitems.VIGIL_EYE.get()) {
            this.discard();
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }
}

