/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.Sentities.HitboxesForParts;
import com.Harbinger.Spore.Sentities.Organoids.Mound;
import com.Harbinger.Spore.Sitems.Reaver;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CorpseEntity
extends Entity {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> OWNER_ADA = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> INFLATION = SynchedEntityData.defineId(CorpseEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final SimpleContainer inventory = new SimpleContainer(20);

    public CorpseEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TYPE, (Object)0);
        builder.define(OWNER_ADA, (Object)false);
        builder.define(COLOR, (Object)0);
        builder.define(TIMER, (Object)0);
        builder.define(INFLATION, (Object)Float.valueOf(1.0f));
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public void addToInventory(ItemStack stack) {
        this.inventory.addItem(stack);
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.setCorpseType(compoundTag.getInt("corpse_type"));
        this.setColor(compoundTag.getInt("color"));
        this.entityData.set(TIMER, (Object)compoundTag.getInt("timer"));
        this.setOwnerAda(compoundTag.getBoolean("owner_ada"));
        this.setInflation(compoundTag.getFloat("inflation"));
        ListTag listtag = compoundTag.getList("Items", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.getCompound(i);
            int j = (compoundtag.getByte("Slot") & 0xFF) % this.inventory.getContainerSize();
            this.inventory.setItem(j, ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundtag).orElse(ItemStack.EMPTY));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt("corpse_type", this.getCorpseType());
        compoundTag.putInt("color", this.getColor());
        compoundTag.putInt("timer", ((Integer)this.entityData.get(TIMER)).intValue());
        compoundTag.putBoolean("owner_ada", this.getOwnerAda());
        compoundTag.putFloat("inflation", this.getInflation());
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.putByte("Slot", (byte)i);
            listtag.add((Object)itemstack.save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        }
        compoundTag.put("Items", (Tag)listtag);
    }

    public void setCorpseType(int e) {
        this.entityData.set(TYPE, (Object)e);
    }

    public int getCorpseType() {
        return (Integer)this.entityData.get(TYPE);
    }

    public void setColor(int e) {
        this.entityData.set(COLOR, (Object)e);
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public void setOwnerAda(boolean e) {
        this.entityData.set(OWNER_ADA, (Object)e);
    }

    public boolean getOwnerAda() {
        return (Boolean)this.entityData.get(OWNER_ADA);
    }

    public int getTimer() {
        return (Integer)this.entityData.get(TIMER);
    }

    public void setInflation(float e) {
        this.entityData.set(INFLATION, (Object)Float.valueOf(e));
    }

    public float getInflation() {
        return ((Float)this.entityData.get(INFLATION)).floatValue();
    }

    public InteractionResult interactAt(Player player, Vec3 hitVec, InteractionHand hand) {
        if (!this.level().isClientSide && player.getItemInHand(hand).getItem() instanceof Reaver && Math.random() < (double)0.3f) {
            this.summonItem(HitboxesForParts.byId(this.getCorpseType()).getCalamityType().getStack());
            this.playSound(Ssounds.REAVER_REAVE.get());
        }
        this.createLoot();
        return InteractionResult.SUCCESS;
    }

    public boolean hurt(DamageSource p_19946_, float p_19947_) {
        this.createLoot();
        return super.hurt(p_19946_, p_19947_);
    }

    private void createLoot() {
        if (!this.level().isClientSide) {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack stack = this.inventory.getItem(i);
                if (stack.isEmpty()) continue;
                this.summonItem(stack);
                this.inventory.setItem(i, ItemStack.EMPTY);
                break;
            }
            if (this.inventory.isEmpty()) {
                this.summonItem(HitboxesForParts.byId(this.getCorpseType()).getCalamityType().getStack());
                this.discard();
            }
        }
    }

    public boolean isPickable() {
        return true;
    }

    public void summonItem(ItemStack stack) {
        ItemEntity entity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack);
        this.level().addFreshEntity((Entity)entity);
    }

    public boolean mayInteract(Level p_146843_, BlockPos p_146844_) {
        return true;
    }

    public void tick() {
        Vec3 motion;
        super.tick();
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.05, 0.0));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.onGround() && this.getDeltaMovement().lengthSqr() > 1.0E-4) {
            motion = this.getDeltaMovement();
            double horizSpeed = Math.sqrt(motion.x * motion.x + motion.z * motion.z);
            this.setYRot((float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.29577951308232));
            this.setXRot((float)(Mth.atan2((double)motion.y, (double)horizSpeed) * 57.29577951308232));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        if (this.onGround()) {
            motion = this.getDeltaMovement();
            if (motion.lengthSqr() > 0.01) {
                this.setDeltaMovement(motion.multiply(0.5, -0.5, 0.5));
            } else {
                this.setDeltaMovement(Vec3.ZERO);
            }
        }
        if (this.tickCount % 20 == 0) {
            this.tickTimer();
        }
    }

    private void tickTimer() {
        int time = (Integer)this.entityData.get(TIMER);
        if (time < 300) {
            this.entityData.set(TIMER, (Object)(++time));
        } else {
            this.summonBiomass();
        }
    }

    private void summonBiomass() {
        if (this.level().isClientSide) {
            return;
        }
        if (Math.random() < 0.1) {
            Mound mound = new Mound(Sentities.MOUND.get(), this.level());
            mound.moveTo(this.position());
            mound.tickEmerging();
            this.level().addFreshEntity((Entity)mound);
        } else {
            AABB aabb = this.getBoundingBox().inflate(1.0);
            for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
                BlockState blockState = this.level().getBlockState(blockpos);
                if (!blockState.isAir() || !(Math.random() < (double)0.2f)) continue;
                FallingBlockEntity.fall((Level)this.level(), (BlockPos)blockpos, (BlockState)((Block)Sblocks.REMAINS.get()).defaultBlockState());
            }
        }
        this.discard();
    }

    public boolean isNoGravity() {
        return false;
    }

    public boolean shouldBeSaved() {
        return true;
    }

    public HitboxesForParts getVariant() {
        return HitboxesForParts.byId(this.getCorpseType() & 0xFF);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (TYPE.equals(key)) {
            this.refreshDimensions();
            this.setBoundingBox(this.getDimensions(this.getPose()).makeBoundingBox(this.position()));
        }
    }

    public EntityDimensions getDimensions(Pose pose) {
        HitboxesForParts parts = this.getVariant();
        return EntityDimensions.scalable((float)parts.getWidth(), (float)parts.getHeight()).scale(this.getInflation());
    }
}

