/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.Sentities.AI.FloatDiveGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.BufferAI;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.FoliageSpread;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sparticles;
import com.Harbinger.Spore.core.Ssounds;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class GastGeber
extends EvolvedInfected
implements FoliageSpread {
    public static final EntityDataAccessor<BlockPos> SPREAD_POINT = SynchedEntityData.defineId(GastGeber.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    public static final EntityDataAccessor<Integer> TIME_ROOTED = SynchedEntityData.defineId(GastGeber.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> AGGRESSION = SynchedEntityData.defineId(GastGeber.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> SPREAD_INTERVAL = SynchedEntityData.defineId(GastGeber.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int maxCounter = (Integer)SConfig.SERVER.gastgeber_spread_cooldown.get();
    public final int maxRootTime;

    public GastGeber(EntityType<? extends Infected> type, Level level) {
        super(type, level);
        this.maxRootTime = (Integer)SConfig.SERVER.gastgeber_root_time.get();
    }

    @Override
    public boolean removeWhenFarAway(double p_21542_) {
        return false;
    }

    @Override
    public boolean blockBreakingParameter(BlockState blockstate, BlockPos blockpos) {
        float value = blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos);
        return this.tickCount % 20 == 0 && value > 0.0f && value <= (float)this.getBreaking();
    }

    public int getBreaking() {
        return (Integer)SConfig.SERVER.experiment_bd.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.gastgeber_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.gastgeber_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.gastgeber_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.ATTACK_KNOCKBACK, 3.0);
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.gastgaber_loot.get();
    }

    @Override
    public boolean canStarve() {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.GAST_AMBIENT.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    @Override
    protected void addRegularGoals() {
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal(this, 1.5, true){

            public boolean canUse() {
                return super.canUse() && GastGeber.this.getAggression() > 0;
            }
        });
        this.goalSelector.addGoal(3, (Goal)new FindPlaceToInfect(this));
        this.goalSelector.addGoal(6, (Goal)new FloatDiveGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new BufferAI(this));
    }

    public boolean isRooted() {
        return this.getTimeRooted() > 0;
    }

    public BlockPos getRootPoint() {
        return (BlockPos)this.entityData.get(SPREAD_POINT);
    }

    public void setRootPoint(BlockPos pos) {
        this.entityData.set(SPREAD_POINT, (Object)pos);
    }

    public int getTimeRooted() {
        return (Integer)this.entityData.get(TIME_ROOTED);
    }

    public void setTimeRooted(int value) {
        this.entityData.set(TIME_ROOTED, (Object)value);
    }

    public int getAggression() {
        return (Integer)this.entityData.get(AGGRESSION);
    }

    public void setAggression(int value) {
        this.entityData.set(AGGRESSION, (Object)value);
    }

    public int getSpreadInterval() {
        return (Integer)this.entityData.get(SPREAD_INTERVAL);
    }

    public void setSpreadInterval(int value) {
        this.entityData.set(SPREAD_INTERVAL, (Object)value);
    }

    @Override
    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SPREAD_POINT, (Object)BlockPos.ZERO);
        builder.define(TIME_ROOTED, (Object)0);
        builder.define(AGGRESSION, (Object)0);
        builder.define(SPREAD_INTERVAL, (Object)0);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        int x = tag.getInt("spreadX");
        int y = tag.getInt("spreadY");
        int z = tag.getInt("spreadZ");
        this.setRootPoint(new BlockPos(x, y, z));
        this.setTimeRooted(tag.getInt("root"));
        this.setAggression(tag.getInt("anger"));
        this.setSpreadInterval(tag.getInt("spread"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("spreadX", this.getRootPoint().getX());
        tag.putInt("spreadY", this.getRootPoint().getY());
        tag.putInt("spreadZ", this.getRootPoint().getZ());
        tag.putInt("root", this.getTimeRooted());
        tag.putInt("anger", this.getAggression());
        tag.putInt("spread", this.getSpreadInterval());
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() instanceof LivingEntity) {
            this.setAggression(30);
            this.setTimeRooted(0);
        }
        return super.hurt(source, amount);
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 120, 2));
        }
        return super.doHurtTarget(entity);
    }

    public void tick() {
        super.tick();
        if (this.isRooted() && this.onGround()) {
            this.makeStuckInBlock(Blocks.AIR.defaultBlockState(), new Vec3(0.0, 1.0, 0.0));
        }
        if (this.tickCount % 20 == 0 && this.isAlive()) {
            if (this.getAggression() > 0) {
                this.setAggression(this.getAggression() - 1);
            }
            if (this.isRooted()) {
                this.setTimeRooted(this.getTimeRooted() - 1);
                if (this.getSpreadInterval() < maxCounter) {
                    this.setSpreadInterval(this.getSpreadInterval() + 1);
                    if (this.getSpreadInterval() == maxCounter - 1) {
                        this.playSound(Ssounds.PUFF.get());
                    }
                } else {
                    if (((Boolean)SConfig.SERVER.mound_foliage.get()).booleanValue()) {
                        this.SpreadInfection(this.level(), ((Integer)SConfig.SERVER.gastgeber_range.get()).intValue(), this.getOnPos());
                    } else {
                        this.SpreadEffect();
                    }
                    this.setSpreadInterval(0);
                }
                if (this.getHealth() < this.getMaxHealth()) {
                    this.setHealth(this.getHealth() + 1.0f);
                }
            }
        }
        if (this.tickCount % 200 == 0 && this.isRooted() && this.getTarget() != null) {
            this.playSound(Ssounds.GAST_AMBIENT.get(), 2.0f, 2.0f);
            this.SpreadEffect();
        }
        if (this.tickCount % 1200 == 0 && !this.isRooted() && this.getAggression() <= 0) {
            this.findNewPos();
        }
    }

    public void SpreadEffect() {
        Level entity2;
        AABB aabb = this.getBoundingBox().inflate(16.0);
        List entities = this.level().getEntities((Entity)this, aabb, e -> {
            LivingEntity living;
            return e instanceof LivingEntity && this.TARGET_SELECTOR.test(living = (LivingEntity)e);
        });
        for (Level entity2 : entities) {
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity2;
            living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 400, 0));
            living.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 600, 3));
        }
        entity2 = this.level();
        if (entity2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity2;
            double x0 = this.getX() - ((double)this.random.nextFloat() - 0.2) * 0.2;
            double y0 = this.getY() + ((double)this.random.nextFloat() - 0.5) * 0.5 * 10.0;
            double z0 = this.getZ() + ((double)this.random.nextFloat() - 0.2) * 0.2;
            serverLevel.sendParticles((ParticleOptions)Sparticles.BLOOD_PARTICLE.get(), x0, y0, z0, 12, 0.0, 0.0, 0.0, 1.0);
        }
    }

    @Override
    public void aiStep() {
        super.aiStep();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getSpreadInterval() > maxCounter - 3) {
                double x0 = this.getX() - ((double)this.random.nextFloat() - 0.2) * 0.2;
                double y0 = this.getY() + ((double)this.random.nextFloat() - 0.5) * 0.5 * 10.0;
                double z0 = this.getZ() + ((double)this.random.nextFloat() - 0.2) * 0.2;
                serverLevel.sendParticles((ParticleOptions)Sparticles.SPORE_PARTICLE.get(), x0, y0, z0, 9, 0.0, 0.0, 0.0, 1.0);
            }
        }
    }

    public void findNewPos() {
        BlockPos pos = this.getOnPos();
        int x = this.random.nextInt(-32, 32);
        int z = this.random.nextInt(-32, 32);
        int y = this.random.nextInt(-6, 6);
        BlockPos repos = new BlockPos(pos.getX() + x, pos.getY() + y, pos.getZ() + z);
        this.setRootPoint(repos);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        if (TIME_ROOTED.equals(dataAccessor) && this.getTimeRooted() == 0) {
            this.findNewPos();
        }
        if (EVOLUTION_POINTS.equals(dataAccessor) && this.getEvoPoints() > 0) {
            this.setKills(this.getKills() + 1);
            this.setEvoPoints(this.getEvoPoints() - 1);
        }
        super.onSyncedDataUpdated(dataAccessor);
    }

    private static class FindPlaceToInfect
    extends Goal {
        private final GastGeber geber;
        public int tryTicks;

        public FindPlaceToInfect(GastGeber geber1) {
            this.geber = geber1;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.geber.isRooted() || this.geber.getAggression() > 0) {
                return false;
            }
            if (this.geber.level().getBlockState(this.geber.getRootPoint().above()) != Blocks.AIR.defaultBlockState()) {
                this.geber.findNewPos();
                return false;
            }
            return this.geber.getRootPoint() != BlockPos.ZERO;
        }

        protected void moveMobToBlock() {
            this.geber.getNavigation().moveTo((double)this.geber.getRootPoint().getX() + 0.5, (double)this.geber.getRootPoint().getY(), (double)this.geber.getRootPoint().getZ() + 0.5, 1.0);
        }

        public void start() {
            this.moveMobToBlock();
            this.tryTicks = 0;
            super.start();
        }

        public void tick() {
            super.tick();
            ++this.tryTicks;
            if (this.geber.getRootPoint() != BlockPos.ZERO && this.shouldRecalculatePath()) {
                this.geber.getNavigation().moveTo((double)this.geber.getRootPoint().getX(), (double)this.geber.getRootPoint().getY(), (double)this.geber.getRootPoint().getZ(), 1.0);
            }
            if (this.geber.getRootPoint() != BlockPos.ZERO && this.geber.getRootPoint().closerToCenterThan((Position)this.geber.position(), 9.0)) {
                this.geber.setTimeRooted(this.geber.maxRootTime);
            }
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }
    }
}

