/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.ArmorPersentageBypass;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.Variants.IllusionVariants;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.SdamageTypes;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Ssounds;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public class Illusion
extends UtilityEntity
implements ArmorPersentageBypass,
Enemy {
    private static final EntityDataAccessor<Boolean> SEE_ABLE = SynchedEntityData.defineId(Illusion.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> BODY = SynchedEntityData.defineId(Illusion.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(Illusion.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.defineId(Illusion.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ADVANCED = SynchedEntityData.defineId(Illusion.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Illusion(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SEE_ABLE, (Object)true);
        builder.define(ADVANCED, (Object)false);
        builder.define(TYPE, (Object)0);
        builder.define(TARGET_ID, (Object)0);
        builder.define(BODY, (Object)"spore:knight");
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("type", ((Integer)this.entityData.get(TYPE)).intValue());
        tag.putInt("target_id", ((Integer)this.entityData.get(TARGET_ID)).intValue());
        tag.putBoolean("see_able", ((Boolean)this.entityData.get(SEE_ABLE)).booleanValue());
        tag.putBoolean("advanced", ((Boolean)this.entityData.get(ADVANCED)).booleanValue());
        tag.putString("body", (String)this.entityData.get(BODY));
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.entityData.set(SEE_ABLE, (Object)tag.getBoolean("see_able"));
        this.entityData.set(ADVANCED, (Object)tag.getBoolean("advanced"));
        this.entityData.set(TYPE, (Object)tag.getInt("type"));
        this.entityData.set(TARGET_ID, (Object)tag.getInt("target_id"));
        this.entityData.set(BODY, (Object)tag.getString("body"));
        super.readAdditionalSaveData(tag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    public boolean canBeSeenByAnyone() {
        return (Boolean)this.entityData.get(SEE_ABLE);
    }

    public int getTargetId() {
        return (Integer)this.entityData.get(TARGET_ID);
    }

    public void setTargetId(int value) {
        this.entityData.set(TARGET_ID, (Object)value);
    }

    public void setAdvanced(boolean value) {
        this.entityData.set(ADVANCED, (Object)value);
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, livingEntity -> this.getSeeAble() && this.TARGET_SELECTOR.test(livingEntity)));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, livingEntity -> !this.getSeeAble() && livingEntity.getId() == this.getTargetId()));
        this.goalSelector.addGoal(3, (Goal)new CustomMeleeAttackGoal(this, 1.3, true));
    }

    public void setTypeVariant(IllusionVariants variant) {
        this.entityData.set(TYPE, (Object)(variant.getVariant() & 0xFF));
    }

    public int getTypeVariant() {
        return (Integer)this.entityData.get(TYPE);
    }

    public void setBody(String i) {
        this.entityData.set(BODY, (Object)i);
    }

    public String getBody() {
        return (String)this.entityData.get(BODY);
    }

    public void setSeeAble(boolean value) {
        this.entityData.set(SEE_ABLE, (Object)value);
    }

    public boolean getSeeAble() {
        return (Boolean)this.entityData.get(SEE_ABLE);
    }

    public boolean hurt(DamageSource source, float p_21017_) {
        if (source.getEntity() != null) {
            this.discard();
        }
        return false;
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        return this.getSeeAble() ? super.getCustomDamage(entity) : SdamageTypes.mental_damage(entity);
    }

    public void tick() {
        super.tick();
        if (this.tickCount % 800 == 0 && !this.getSeeAble()) {
            this.discard();
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.getSeeAble()) {
                livingEntity.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 400, 2));
            } else {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
            }
            if (((Boolean)this.entityData.get(ADVANCED)).booleanValue()) {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 0));
            }
        }
        this.discard();
        return super.doHurtTarget(entity);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return Ssounds.MADNESS.get();
    }

    public int getAmbientSoundInterval() {
        return 200;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        IllusionVariants variant = (IllusionVariants)((Object)Util.getRandom((Object[])IllusionVariants.values(), (RandomSource)this.random));
        this.setTypeVariant(variant);
        this.setBody(variant.getEntityValue());
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public IllusionVariants getVariant() {
        return IllusionVariants.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public float amountOfDamage(float value) {
        return this.getSeeAble() ? 0.0f : (float)((Double)SConfig.SERVER.halucinations_damage.get() * 1.0);
    }

    public boolean addEffect(MobEffectInstance p_147208_, @Nullable Entity p_147209_) {
        return false;
    }
}

