/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.SBlockEntities.LivingStructureBlocks;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.MovementControls.InfectedWallMovementControl;
import com.Harbinger.Spore.Sentities.Organoids.Mound;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Sentities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class InfectionTendril
extends UtilityEntity {
    private static final EntityDataAccessor<BlockPos> SEARCH_AREA = SynchedEntityData.defineId(InfectionTendril.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(InfectionTendril.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> MOUND_AGE = SynchedEntityData.defineId(InfectionTendril.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public InfectionTendril(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.moveControl = new InfectedWallMovementControl((Mob)this);
        this.navigation = new WallClimberNavigation((Mob)this, level);
    }

    public boolean removeWhenFarAway(double p_21542_) {
        return false;
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int s) {
        this.entityData.set(LIFE, (Object)s);
    }

    public int getAgeM() {
        return (Integer)this.entityData.get(MOUND_AGE);
    }

    public void setAgeM(int s) {
        this.entityData.set(MOUND_AGE, (Object)s);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MOUND_AGE, (Object)2);
        builder.define(LIFE, (Object)4800);
        builder.define(SEARCH_AREA, (Object)BlockPos.ZERO);
    }

    public void setSearchArea(BlockPos blockPos) {
        this.entityData.set(SEARCH_AREA, (Object)blockPos);
    }

    BlockPos getSearchArea() {
        return (BlockPos)this.entityData.get(SEARCH_AREA);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("mound_age", this.getAgeM());
        tag.putInt("life", this.getLife());
        tag.putInt("AreaX", this.getSearchArea().getX());
        tag.putInt("AreaY", this.getSearchArea().getY());
        tag.putInt("AreaZ", this.getSearchArea().getZ());
        super.addAdditionalSaveData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.setAgeM(tag.getInt("mound_age"));
        this.setLife(tag.getInt("life"));
        int i = tag.getInt("AreaX");
        int j = tag.getInt("AreaY");
        int k = tag.getInt("AreaZ");
        this.setSearchArea(new BlockPos(i, j, k));
        super.readAdditionalSaveData(tag);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(2, (Goal)new GoToArea(this));
        super.registerGoals();
    }

    public void travel(Vec3 p_32858_) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(0.1f, p_32858_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement());
        } else {
            super.travel(p_32858_);
        }
    }

    public boolean isInvulnerable() {
        return true;
    }

    public void tick() {
        super.tick();
        if (this.isAlive() && (Integer)this.entityData.get(LIFE) > 0) {
            this.entityData.set(LIFE, (Object)((Integer)this.entityData.get(LIFE) - 1));
        }
        if (this.getSearchArea() != BlockPos.ZERO && this.random.nextInt(40) == 0) {
            if ((double)Math.abs(this.getSearchArea().getX()) - Math.abs(this.getX()) < 6.0 && (double)Math.abs(this.getSearchArea().getZ()) - Math.abs(this.getZ()) < 6.0) {
                this.teleport();
            }
            if (!this.onGround() && this.horizontalCollision && this.verticalCollision) {
                this.teleport();
            }
        }
    }

    public void aiStep() {
        if ((Integer)this.entityData.get(LIFE) == 0) {
            this.discard();
        }
        if (this.random.nextInt(0, 10) == 0) {
            this.Spread((Entity)this, this.level(), 0.3);
        }
        super.aiStep();
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    protected boolean teleport() {
        if (!this.level().isClientSide() && this.isAlive()) {
            double d0 = (double)this.getSearchArea().getX() + (double)this.random.nextInt(-8, 8);
            double d1 = this.getSearchArea().getY();
            double d2 = (double)this.getSearchArea().getZ() + (double)this.random.nextInt(-8, 8);
            this.Spread((Entity)this, this.level(), 1.2);
            return this.randomTeleport(d0, d1, d2, false);
        }
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, 0.15);
    }

    private void Spread(Entity entity, Level level, double value) {
        AABB aabb = entity.getBoundingBox().inflate(value);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            Container container;
            Mound mound;
            BlockState nord = level.getBlockState(blockpos.north());
            BlockState south = level.getBlockState(blockpos.south());
            BlockState west = level.getBlockState(blockpos.west());
            BlockState east = level.getBlockState(blockpos.east());
            BlockState above = level.getBlockState(blockpos.above());
            BlockState below = level.getBlockState(blockpos.below());
            boolean nordT = !nord.isSolidRender((BlockGetter)level, blockpos.north());
            boolean southT = !south.isSolidRender((BlockGetter)level, blockpos.south());
            boolean westT = !west.isSolidRender((BlockGetter)level, blockpos.west());
            boolean eastT = !east.isSolidRender((BlockGetter)level, blockpos.east());
            boolean aboveT = !above.isSolidRender((BlockGetter)level, blockpos.above());
            boolean belowT = !below.isSolidRender((BlockGetter)level, blockpos.below());
            BlockState blockstate = level.getBlockState(blockpos);
            if (Math.random() < 0.02 && blockstate.isSolidRender((BlockGetter)level, blockpos) && (nordT || southT || westT || eastT || aboveT || belowT)) {
                for (String str : (List)SConfig.DATAGEN.block_infection.get()) {
                    String[] string = str.split("\\|");
                    Block blockBase = Utilities.tryToCreateBlock(ResourceLocation.parse((String)string[0]));
                    Block blockBase2 = Utilities.tryToCreateBlock(ResourceLocation.parse((String)string[1]));
                    if (!blockstate.getBlock().equals(blockBase)) continue;
                    level.setBlock(blockpos, blockBase2.defaultBlockState(), 3);
                }
            }
            if (above.isAir() && blockstate.isSolidRender((BlockGetter)level, blockpos) && Math.random() < 0.1) {
                level.setBlock(blockpos.above(), ((Block)Sblocks.MYCELIUM_VEINS.get()).defaultBlockState(), 3);
            }
            BlockEntity blockEntity = this.level().getBlockEntity(blockpos);
            if (blockstate.is((Block)Sblocks.REMAINS.get())) {
                mound = new Mound(Sentities.MOUND.get(), level);
                mound.setMaxAge(this.getAgeM());
                mound.tickEmerging();
                mound.setPos((double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5);
                level.addFreshEntity((Entity)mound);
                level.removeBlock(blockpos, false);
                this.discard();
                continue;
            }
            if (blockEntity instanceof Container && this.isChestWithFood(container = (Container)blockEntity)) {
                this.eatTheFood(container);
                mound = new Mound(Sentities.MOUND.get(), level);
                mound.setMaxAge(1);
                mound.tickEmerging();
                mound.setPos((double)blockpos.getX() + 0.5, blockpos.getY() + 1, (double)blockpos.getZ() + 0.5);
                level.addFreshEntity((Entity)mound);
                level.removeBlock(blockpos.above(), false);
                this.discard();
                continue;
            }
            if (blockstate.is((Block)Sblocks.HIVE_SPAWN.get()) || blockstate.is((Block)Sblocks.BIOMASS_LUMP.get())) {
                if (!(blockEntity instanceof LivingStructureBlocks)) continue;
                LivingStructureBlocks structureBlocks = (LivingStructureBlocks)blockEntity;
                structureBlocks.setKills(structureBlocks.getKills() + (Integer)SConfig.SERVER.mound_tendril_feed.get());
                this.discard();
                continue;
            }
            if (!blockstate.is(Blocks.SPAWNER)) continue;
            level.setBlock(blockpos, ((Block)Sblocks.OVERGROWN_SPAWNER.get()).defaultBlockState(), 2);
            this.discard();
        }
    }

    public boolean addEffect(MobEffectInstance p_182397_, @Nullable Entity p_182398_) {
        return false;
    }

    private boolean isChestWithFood(Container container) {
        return container.hasAnyMatching(item -> item.getFoodProperties(null) != null);
    }

    private void eatTheFood(Container container) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack stack = container.getItem(i);
            if (stack.getFoodProperties(null) == null) continue;
            stack.setCount(0);
        }
    }

    static class GoToArea
    extends Goal {
        InfectionTendril tendril;
        public int tryTicks;

        public GoToArea(InfectionTendril t) {
            this.tendril = t;
        }

        public boolean canUse() {
            return this.tendril.getSearchArea() != null;
        }

        protected void moveMobToBlock() {
            this.tendril.getNavigation().moveTo((double)this.tendril.getSearchArea().getX() + 0.5, (double)(this.tendril.getSearchArea().getY() + 1), (double)this.tendril.getSearchArea().getZ() + 0.5, 1.0);
        }

        public void start() {
            this.moveMobToBlock();
            this.tryTicks = 0;
            super.start();
        }

        public void tick() {
            super.tick();
            ++this.tryTicks;
            if (this.tendril.getSearchArea() != null && this.shouldRecalculatePath()) {
                this.tendril.getNavigation().moveTo((double)this.tendril.getSearchArea().getX(), (double)this.tendril.getSearchArea().getY(), (double)this.tendril.getSearchArea().getZ(), 1.0);
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }
    }
}

