/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.Projectile.ThrownBlockProjectile;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class InfestedConstruct
extends UtilityEntity
implements RangedAttackMob,
Enemy {
    public static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.defineId(InfestedConstruct.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DISPENSER = SynchedEntityData.defineId(InfestedConstruct.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> MACHINE_HEALTH = SynchedEntityData.defineId(InfestedConstruct.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Integer> METAL_RESERVE = SynchedEntityData.defineId(InfestedConstruct.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Double maXmachineHp = (Double)SConfig.SERVER.inf_machine_hp.get();
    public final Map<Item, Integer> metalAndValues;
    @Nullable
    private BlockPos Targetpos;
    private int attackAnimationTick;

    public InfestedConstruct(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.navigation = new WallClimberNavigation((Mob)this, this.level());
        this.metalAndValues = this.getValues();
    }

    @Override
    public List<? extends String> getDropList() {
        return this.isActive() ? (List)SConfig.DATAGEN.construct_loot.get() : null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.inf_cons_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.inf_cons_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.inf_cons_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 2.0);
    }

    public boolean removeWhenFarAway(double value) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SporeSavedData data = SporeSavedData.getDataLocation(serverLevel);
            return data != null && data.getAmountOfHiveminds() >= (Integer)SConfig.SERVER.proto_spawn_world_mod.get() && value > 256.0;
        }
        return false;
    }

    public void aiStep() {
        super.aiStep();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        this.attackAnimationTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        entity.hurtMarked = true;
        entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, 0.8, 0.0));
        this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 600, 0));
            livingEntity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 600, 0));
        }
        return super.doHurtTarget(entity);
    }

    public void handleEntityEvent(byte value) {
        if (value == 4) {
            this.attackAnimationTick = 10;
            this.playSound(SoundEvents.IRON_GOLEM_ATTACK, 1.0f, 1.0f);
        } else {
            super.handleEntityEvent(value);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    private boolean canRangeAttack() {
        LivingEntity livingEntity = this.getTarget();
        return this.isActive() && livingEntity != null && livingEntity.getY() - 2.0 > this.getY();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ACTIVE, (Object)true);
        builder.define(DISPENSER, (Object)false);
        builder.define(METAL_RESERVE, (Object)0);
        builder.define(MACHINE_HEALTH, (Object)Float.valueOf((float)(maXmachineHp * 1.0)));
    }

    public void setActive(boolean value) {
        this.entityData.set(ACTIVE, (Object)value);
    }

    public boolean isActive() {
        return (Boolean)this.entityData.get(ACTIVE);
    }

    public void setDispenser(boolean value) {
        this.entityData.set(DISPENSER, (Object)value);
    }

    public boolean isDispenser() {
        return (Boolean)this.entityData.get(DISPENSER);
    }

    public void setMachineHealth(float value) {
        this.entityData.set(MACHINE_HEALTH, (Object)Float.valueOf(value));
    }

    public float getMachineHealth() {
        return ((Float)this.entityData.get(MACHINE_HEALTH)).floatValue();
    }

    public void setMetalReserve(int value) {
        this.entityData.set(METAL_RESERVE, (Object)value);
    }

    public int getMetalReserve() {
        return (Integer)this.entityData.get(METAL_RESERVE);
    }

    @Nullable
    public BlockPos getTargetPos() {
        return this.Targetpos;
    }

    public void setTargetPos(@Nullable BlockPos pos) {
        this.Targetpos = pos;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setActive(tag.getBoolean("active"));
        this.setMachineHealth(tag.getFloat("machine_hp"));
        this.entityData.set(DISPENSER, (Object)tag.getBoolean("dispenser"));
        this.entityData.set(METAL_RESERVE, (Object)tag.getInt("metal"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("active", this.isActive());
        tag.putFloat("machine_hp", this.getMachineHealth());
        tag.putBoolean("dispenser", ((Boolean)this.entityData.get(DISPENSER)).booleanValue());
        tag.putInt("metal", ((Integer)this.entityData.get(METAL_RESERVE)).intValue());
    }

    protected void registerGoals() {
        super.registerGoals();
        this.addTargettingGoals();
        this.goalSelector.addGoal(3, (Goal)new AOEMeleeAttackGoal(this, this, 1.2, false, 1.5, 2.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 6.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(4, (Goal)new SearchAroundGoal(this));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public boolean isNoAi() {
        return super.isNoAi() || !this.isActive();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    private List<DamageSource> resistentSources() {
        ArrayList<DamageSource> resistentSources = new ArrayList<DamageSource>();
        resistentSources.add(this.level().damageSources().onFire());
        resistentSources.add(this.level().damageSources().inFire());
        resistentSources.add(this.level().damageSources().lava());
        resistentSources.add(this.level().damageSources().hotFloor());
        return resistentSources;
    }

    public boolean hurt(DamageSource source, float value) {
        if (this.invulnerableTime == 0) {
            float f = value = this.resistentSources().contains(source) ? value / 2.0f : value;
            if (!(this.getMachineHealth() > 0.0f)) {
                return super.hurt(source, value);
            }
            float damage = this.getDamageAfterArmorAbsorb(source, value);
            this.setMachineHealth(damage > this.getMachineHealth() ? 0.0f : this.getMachineHealth() - damage);
            this.invulnerableTime = 10;
            this.hurtTime = 10;
            this.playHurtSound(source);
            return true;
        }
        return false;
    }

    public boolean hasLineOfSightBlocks(BlockPos pos) {
        BlockHitResult raytraceresult = this.level().clip(new ClipContext(this.getEyePosition(1.0f), new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        BlockPos position = raytraceresult.getBlockPos();
        return pos.equals((Object)position) || this.level().isEmptyBlock(pos) || this.level().getBlockEntity(pos) == this.level().getBlockEntity(position);
    }

    protected int calculateFallDamage(float p_21237_, float p_21238_) {
        return 0;
    }

    public void awardKillScore(Entity p_19953_, int p_19954_, DamageSource p_19955_) {
        super.awardKillScore(p_19953_, p_19954_, p_19955_);
        this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 400, 0));
    }

    public boolean addEffect(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (((MobEffect)effectInstance.getEffect().value()).isBeneficial() || effectInstance.getEffect() == Seffects.CORROSION) {
            return super.addEffect(effectInstance, entity);
        }
        return false;
    }

    public void performRangedAttack(LivingEntity livingEntity, float v) {
        this.attackAnimationTick = 10;
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        BlockState state = this.getBlock();
        if (!this.level().isClientSide && state != null) {
            ThrownBlockProjectile thrownBlockProjectile = new ThrownBlockProjectile(this.level(), (LivingEntity)this, Float.valueOf(10.0f), state, this.TARGET_SELECTOR);
            double dx = livingEntity.getX() - this.getX();
            double dy = livingEntity.getY() + (double)livingEntity.getEyeHeight() - 1.0;
            double dz = livingEntity.getZ() - this.getZ();
            thrownBlockProjectile.moveTo(this.getX(), this.getY() + 1.5, this.getZ());
            thrownBlockProjectile.shoot(dx, dy - thrownBlockProjectile.getY() + Math.hypot(dx, dz) * (double)0.05f, dz, 1.0f, 6.0f);
            this.level().addFreshEntity((Entity)thrownBlockProjectile);
        }
    }

    public BlockState getBlock() {
        AABB aabb = this.getBoundingBox().inflate(0.2);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState blockstate = this.level().getBlockState(blockpos);
            if (!(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) < 5.0f) || !(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) >= 0.0f) || blockstate.isAir()) continue;
            this.level().destroyBlock(blockpos, false);
            return blockstate;
        }
        return null;
    }

    public Map<Item, Integer> getValues() {
        HashMap<Item, Integer> values = new HashMap<Item, Integer>();
        for (String string : (List)SConfig.SERVER.cons_blocks.get()) {
            String[] strings = string.split("\\|");
            int value = Integer.parseInt(strings[1]);
            Item stack = Utilities.tryToCreateStack(ResourceLocation.parse((String)strings[0])).getItem();
            if (value <= 0) continue;
            values.put(stack, value);
        }
        return values;
    }

    public void tick() {
        LivingEntity target;
        super.tick();
        if (this.tickCount % 40 == 0) {
            if (EventHooks.canEntityGrief((Level)this.level(), (Entity)this) && this.horizontalCollision) {
                this.griefBlocks();
            }
            if ((double)this.getMachineHealth() < maXmachineHp && (Integer)this.entityData.get(METAL_RESERVE) > 0) {
                this.setMachineHealth(this.getMachineHealth() + 1.0f);
                this.entityData.set(METAL_RESERVE, (Object)((Integer)this.entityData.get(METAL_RESERVE) - 1));
            }
            if (this.hasEffect(Seffects.CORROSION)) {
                this.setMachineHealth(this.getMachineHealth() - 2.0f);
            }
        }
        if (this.tickCount % 200 == 0) {
            if (!this.isActive()) {
                this.callUponInfected();
            }
            this.searchBlocks();
        }
        if (this.tickCount % 100 == 0 && this.isDispenser() && this.isActive() && (target = this.getTarget()) != null && this.hasLineOfSight((Entity)target)) {
            this.performDispenserShot(target);
        }
        if (this.tickCount % 60 == 0 && this.canRangeAttack() && (target = this.getTarget()) != null && this.hasLineOfSight((Entity)target)) {
            this.performRangedAttack(target, 0.0f);
        }
    }

    private void griefBlocks() {
        AABB aabb = this.getBoundingBox().inflate(0.5, 0.0, 0.5).move(0.0, 1.0, 0.0);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState blockstate = this.level().getBlockState(blockpos);
            if (!this.blockBreakingParameter(blockstate, blockpos)) continue;
            this.interactBlock(blockpos, this.level());
        }
    }

    public boolean blockBreakingParameter(BlockState blockstate, BlockPos blockpos) {
        float value = blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos);
        return this.tickCount % 20 == 0 && value > 0.0f && value <= (float)this.getBreaking();
    }

    public int getBreaking() {
        return (Integer)SConfig.SERVER.hyper_bd.get();
    }

    public boolean interactBlock(BlockPos blockPos, Level level) {
        BlockState state = level.getBlockState(blockPos);
        if (Utilities.biomass().contains(state)) {
            return level.setBlock(blockPos, ((Block)Sblocks.MEMBRANE_BLOCK.get()).defaultBlockState(), 3);
        }
        return level.destroyBlock(blockPos, false, (Entity)this);
    }

    protected SoundEvent getAmbientSound() {
        return this.isActive() ? Ssounds.CONSTRUCT_AMBIENT.get() : null;
    }

    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return this.getMachineHealth() > 0.0f || !this.isActive() ? SoundEvents.IRON_GOLEM_HURT : Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.IRON_GOLEM_STEP;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        if (dataAccessor.equals(ACTIVE)) {
            this.refreshDimensions();
            if (this.isActive()) {
                this.setMachineHealth((float)(maXmachineHp * 1.0));
                this.setHealth(this.getMaxHealth());
            }
        }
    }

    public void searchBlocks() {
        AABB aabb = this.getBoundingBox().inflate(32.0, 4.0, 32.0);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState block = this.level().getBlockState(blockpos);
            if (!this.metalAndValues.containsKey(block.getBlock().asItem()) || !this.hasLineOfSightBlocks(blockpos) || !(this.random.nextFloat() < 0.5f)) continue;
            this.setTargetPos(blockpos);
            break;
        }
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        EntityDimensions dimensions = super.getDefaultDimensions(pose);
        if (!this.isActive()) {
            return dimensions.scale(1.0f, 0.4f);
        }
        return dimensions;
    }

    public void callUponInfected() {
        AABB aabb = this.getBoundingBox().inflate(8.0);
        List infected = this.level().getEntities((Entity)this, aabb, entity -> entity instanceof Infected && !(entity instanceof Hyper));
        for (Entity entity2 : infected) {
            if (!(entity2 instanceof Infected)) continue;
            Infected infected1 = (Infected)entity2;
            infected1.setSearchPos(this.getOnPos());
            if (!(infected1.distanceToSqr((Entity)this) < 30.0)) continue;
            this.setActive(true);
            infected1.discard();
            Level level = this.level();
            if (!(level instanceof ServerLevel)) break;
            ServerLevel serverLevel = (ServerLevel)level;
            double x0 = this.getX() - ((double)this.random.nextFloat() - 0.1) * 0.1;
            double y0 = this.getY() + ((double)this.random.nextFloat() - 0.25) * 0.15 * 5.0;
            double z0 = this.getZ() + ((double)this.random.nextFloat() - 0.1) * 0.1;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x0, y0, z0, 2, 0.0, 0.0, 0.0, 1.0);
            break;
        }
    }

    public boolean canBeSeenAsEnemy() {
        return super.canBeSeenAsEnemy() && this.isActive();
    }

    public void performDispenserShot(LivingEntity entity) {
        Arrow abstractarrow = new Arrow(this.level(), (LivingEntity)this, ItemStack.EMPTY, null);
        double d0 = entity.getX() - this.getX();
        double d1 = entity.getY(0.3333333333333333) - abstractarrow.getY();
        double d2 = entity.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 600));
        if (Math.random() < (double)0.4f) {
            abstractarrow.setRemainingFireTicks(160);
        }
        abstractarrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound(SoundEvents.DISPENSER_LAUNCH, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)abstractarrow);
    }

    public void die(DamageSource p_21014_) {
        super.die(p_21014_);
        this.dropIron();
    }

    private void dropIron() {
        ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)Items.IRON_INGOT, this.random.nextInt(1, 5)));
        this.level().addFreshEntity((Entity)itemEntity);
    }

    public static class SearchAroundGoal
    extends Goal {
        private final InfestedConstruct construct;
        public int tryTicks;

        public SearchAroundGoal(InfestedConstruct construct) {
            this.construct = construct;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return this.construct.getTargetPos() != null && this.construct.getTarget() == null;
        }

        protected void moveToBlock(BlockPos pos) {
            if (pos != null) {
                this.construct.navigation.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 1.0);
            }
        }

        public void start() {
            this.moveToBlock(this.construct.getTargetPos());
            this.tryTicks = 0;
            super.start();
        }

        public boolean canContinueToUse() {
            return this.construct.getTarget() == null;
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            super.tick();
            ++this.tryTicks;
            BlockPos pos = this.construct.getTargetPos();
            if (pos != null && this.shouldRecalculatePath()) {
                this.moveToBlock(pos);
            }
            if (pos != null && pos.closerToCenterThan((Position)this.construct.position(), 3.5)) {
                this.assimilateMetal(pos, this.construct.level());
                this.construct.setTargetPos(null);
                this.construct.searchBlocks();
            }
        }

        public void assimilateMetal(BlockPos pos, Level level) {
            Item item = level.getBlockState(pos).getBlock().asItem();
            try {
                this.construct.setMetalReserve(this.construct.getMetalReserve() + this.construct.metalAndValues.get(item));
            }
            catch (Exception exception) {
                // empty catch block
            }
            level.destroyBlock(pos, false, (Entity)this.construct);
            this.construct.playSound(SoundEvents.IRON_GOLEM_REPAIR);
            if (item == Items.DISPENSER) {
                this.construct.setDispenser(true);
            }
        }
    }
}

