/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.core.Sblocks;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.fml.ModList;

public class NukeEntity
extends Entity {
    private static final EntityDataAccessor<Float> INIT_RANGE = SynchedEntityData.defineId(NukeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> RANGE = SynchedEntityData.defineId(NukeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> INIT_DURATION = SynchedEntityData.defineId(NukeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.defineId(NukeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(NukeEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public Predicate<LivingEntity> livingEntityPredicate = entity -> true;

    public NukeEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.setInitRange(1.0f);
        this.setRange(6.0f);
        this.setInitDuration(0);
        this.setDuration(600);
        this.setDamage(10.0f);
    }

    public void setInitRange(float value) {
        this.entityData.set(INIT_RANGE, (Object)Float.valueOf(value));
    }

    public void setRange(float value) {
        this.entityData.set(RANGE, (Object)Float.valueOf(value));
    }

    public void setInitDuration(int value) {
        this.entityData.set(INIT_DURATION, (Object)value);
    }

    public void setDuration(int value) {
        this.entityData.set(DURATION, (Object)value);
    }

    public void setDamage(float value) {
        this.entityData.set(DAMAGE, (Object)Float.valueOf(value));
    }

    public float getInitRange() {
        return ((Float)this.entityData.get(INIT_RANGE)).floatValue();
    }

    public float getRange() {
        return ((Float)this.entityData.get(RANGE)).floatValue();
    }

    public int getInitDuration() {
        return (Integer)this.entityData.get(INIT_DURATION);
    }

    public int getDuration() {
        return (Integer)this.entityData.get(DURATION);
    }

    public float getDamage() {
        return ((Float)this.entityData.get(DAMAGE)).floatValue();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(INIT_RANGE, (Object)Float.valueOf(1.0f));
        builder.define(RANGE, (Object)Float.valueOf(6.0f));
        builder.define(INIT_DURATION, (Object)0);
        builder.define(DURATION, (Object)600);
        builder.define(DAMAGE, (Object)Float.valueOf(10.0f));
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.setInitRange(compoundTag.getFloat("init_range"));
        this.setRange(compoundTag.getFloat("range"));
        this.setInitDuration(compoundTag.getInt("init_duration"));
        this.setDuration(compoundTag.getInt("duration"));
        this.setDamage(compoundTag.getFloat("damage"));
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putFloat("init_range", this.getInitRange());
        compoundTag.putFloat("range", this.getRange());
        compoundTag.putInt("init_duration", this.getInitDuration());
        compoundTag.putInt("duration", this.getDuration());
        compoundTag.putFloat("damage", this.getDamage());
    }

    public void tick() {
        if (!this.level().isClientSide) {
            this.calculateRange();
            if (this.getInitDuration() >= this.getDuration()) {
                this.discard();
            }
            if (this.tickCount % 10 == 0) {
                this.hurtEntities();
                this.damageAround(this.level(), this.getInitRange() + 4.0f, this.getOnPos());
            }
            if (this.getInitDuration() == 1) {
                this.playNukeSound();
            }
        }
        super.tick();
    }

    private void calculateRange() {
        int remainingDuration;
        if (this.getDuration() > this.getInitDuration()) {
            this.setInitDuration(this.getInitDuration() + 1);
        }
        if ((remainingDuration = this.getDuration() - this.getInitDuration()) > 0) {
            this.setInitRange(this.getInitRange() + this.getRange() / (float)remainingDuration);
        } else {
            this.setInitRange(this.getInitRange());
        }
    }

    public void hurtEntities() {
        AABB aabb = this.getBoundingBox().inflate((double)(this.getInitRange() + 5.0f));
        List entities = this.level().getEntities((Entity)this, aabb, entity -> entity instanceof LivingEntity);
        for (Entity entity2 : entities) {
            LivingEntity living;
            if (!(entity2 instanceof LivingEntity) || !this.livingEntityPredicate.test(living = (LivingEntity)entity2)) continue;
            living.setRemainingFireTicks(200);
            this.addEffect(living);
            living.hurt(this.damageSources().inFire(), this.getDamage());
            living.hurtTime = 10;
            living.invulnerableTime = 10;
        }
    }

    public void addEffect(LivingEntity living) {
        if (ModList.get().isLoaded("alexscaves")) {
            Holder<MobEffect> effect = Utilities.tryToCreateEffect(ResourceLocation.parse((String)"alexscaves:irradiated"));
            if (effect != Seffects.MYCELIUM) {
                living.addEffect(new MobEffectInstance(effect, 1200, 1));
            }
        } else {
            living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 1200, 1));
        }
    }

    public void playNukeSound() {
        AABB aabb = this.getBoundingBox().inflate(32.0);
        List players = this.level().getEntities((Entity)this, aabb, entity -> entity instanceof ServerPlayer);
        for (Entity entity2 : players) {
            if (!(entity2 instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)entity2;
            serverPlayer.playNotifySound(Ssounds.NUKE.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    private void damageAround(Level level, double range, BlockPos pos) {
        int i = 0;
        while ((double)i <= 2.0 * range) {
            int j = 0;
            while ((double)j <= 2.0 * range) {
                int k = 0;
                while ((double)k <= 2.0 * range) {
                    double distance = Mth.sqrt((float)((float)(((double)i - range) * ((double)i - range) + ((double)j - range) * ((double)j - range) + ((double)k - range) * ((double)k - range))));
                    if (distance < range + 0.5) {
                        BlockPos blockpos = pos.offset(i - (int)range, j - (int)range, k - (int)range);
                        BlockState blockstate = level.getBlockState(blockpos);
                        if (blockstate.is(Blocks.WATER)) {
                            level.setBlockAndUpdate(blockpos, Blocks.AIR.defaultBlockState());
                        } else if (Math.random() < 0.1 && blockstate.isSolidRender((BlockGetter)level, blockpos) && level.getBlockState(blockpos.above()).isAir()) {
                            BlockState state = Math.random() < 0.5 ? Blocks.FIRE.defaultBlockState() : ((Block)Sblocks.ACID.get()).defaultBlockState();
                            level.setBlock(blockpos.above(), state, 3);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

