/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sparticles;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class ScentEntity
extends UtilityEntity {
    private static final EntityDataAccessor<Boolean> OVERCHARGED = SynchedEntityData.defineId(ScentEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public ScentEntity(EntityType<? extends PathfinderMob> mob, Level level) {
        super(mob, level);
    }

    public boolean isInvulnerable() {
        return true;
    }

    public void tick() {
        if (this.isAlive()) {
            this.getPersistentData().putInt("dissipate", 1 + this.getPersistentData().getInt("dissipate"));
            if (this.getPersistentData().getInt("dissipate") >= (Integer)SConfig.SERVER.scent_life.get()) {
                this.discard();
            }
            if (((Boolean)SConfig.SERVER.scent_summon.get()).booleanValue()) {
                this.getPersistentData().putInt("summon", 1 + this.getPersistentData().getInt("summon"));
                if (this.getPersistentData().getInt("summon") >= (Integer)SConfig.SERVER.scent_summon_cooldown.get() && !this.level().isClientSide && (this.getOvercharged() || this.checkForNonInfected((Entity)this))) {
                    this.Summon((LivingEntity)this);
                }
            }
        }
        super.tick();
    }

    boolean checkForNonInfected(Entity entity) {
        AABB boundingBox = entity.getBoundingBox().inflate(16.0);
        List entities = entity.level().getEntities(entity, boundingBox, EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        for (Entity en : entities) {
            LivingEntity livingEntity;
            if (!(en instanceof LivingEntity) || !this.TARGET_SELECTOR.test(livingEntity = (LivingEntity)en)) continue;
            return true;
        }
        return false;
    }

    public boolean getOvercharged() {
        return (Boolean)this.entityData.get(OVERCHARGED);
    }

    public void setOvercharged(boolean b) {
        this.entityData.set(OVERCHARGED, (Object)b);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("overcharged", ((Boolean)this.entityData.get(OVERCHARGED)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(OVERCHARGED, (Object)tag.getBoolean("overcharged"));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(OVERCHARGED, (Object)false);
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0);
    }

    public void aiStep() {
        super.aiStep();
        if (!this.onGround()) {
            this.getDeltaMovement().add(0.0, -0.01, 0.0);
        }
        if (((Boolean)SConfig.SERVER.scent_particles.get()).booleanValue()) {
            int i = Mth.floor((double)this.getX());
            int j = Mth.floor((double)this.getY());
            int k = Mth.floor((double)this.getZ());
            Level world = this.level();
            RandomSource randomSource = this.random;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int l = 0; l < 14; ++l) {
                blockpos$mutableblockpos.set(i + Mth.nextInt((RandomSource)randomSource, (int)-6, (int)6), j + Mth.nextInt((RandomSource)randomSource, (int)-6, (int)6), k + Mth.nextInt((RandomSource)randomSource, (int)-6, (int)6));
                BlockState blockstate = world.getBlockState((BlockPos)blockpos$mutableblockpos);
                if (blockstate.isSolidRender((BlockGetter)world, (BlockPos)blockpos$mutableblockpos)) continue;
                world.addParticle((ParticleOptions)Sparticles.SPORE_PARTICLE.get(), (double)blockpos$mutableblockpos.getX() + randomSource.nextDouble(), (double)blockpos$mutableblockpos.getY() + randomSource.nextDouble(), (double)blockpos$mutableblockpos.getZ() + randomSource.nextDouble(), 0.0, 0.1, 0.0);
                if (!this.getOvercharged()) continue;
                world.addParticle((ParticleOptions)Sparticles.BLOOD_PARTICLE.get(), (double)blockpos$mutableblockpos.getX() + randomSource.nextDouble(), (double)blockpos$mutableblockpos.getY() + randomSource.nextDouble(), (double)blockpos$mutableblockpos.getZ() + randomSource.nextDouble(), 0.0, 0.1, 0.0);
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public void Summon(LivingEntity entity) {
        ServerLevelAccessor world = (ServerLevelAccessor)entity.level();
        Level level = entity.level();
        Random rand = new Random();
        int d = this.random.nextInt(0, 3);
        int r = this.random.nextInt(-12, 12);
        int c = this.random.nextInt(-12, 12);
        List ev = (List)SConfig.SERVER.inf_summon.get();
        if (world.isEmptyBlock(new BlockPos((int)this.getX() + r, (int)this.getY() + d, (int)this.getZ() + c))) {
            for (int i = 0; i < 1; ++i) {
                int randomIndex = rand.nextInt(ev.size());
                ResourceLocation randomElement1 = ResourceLocation.parse((String)((String)ev.get(randomIndex)));
                EntityType<?> randomElement = Utilities.tryToCreateEntity(randomElement1);
                Mob waveentity = (Mob)randomElement.create(level);
                assert (waveentity != null);
                waveentity.setPos(entity.getX() + (double)r, entity.getY() + 0.5 + (double)d, entity.getZ() + (double)c);
                waveentity.finalizeSpawn(world, level.getCurrentDifficultyAt(new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ())), MobSpawnType.NATURAL, null);
                this.getPersistentData().putInt("summon", 0);
                if (this.getOvercharged()) {
                    List buffer = (List)SConfig.SERVER.scent_effects_buff.get();
                    if (waveentity instanceof Infected) {
                        Infected infected = (Infected)waveentity;
                        int k = (Integer)SConfig.SERVER.scent_kills.get();
                        infected.setKills(this.random.nextInt(k, k + 3));
                        infected.setEvoPoints(this.random.nextInt(k, k + 3));
                        infected.setEvolution((Integer)SConfig.SERVER.evolution_age_human.get() / 2);
                        infected.setLinked(true);
                    }
                    for (int l = 0; l < 1; ++l) {
                        ResourceLocation randomElement2 = ResourceLocation.parse((String)((String)buffer.get(randomIndex)));
                        Holder<MobEffect> randomElement3 = Utilities.tryToCreateEffect(randomElement2);
                        waveentity.addEffect(new MobEffectInstance(randomElement3, 3600, 0));
                    }
                }
                level.addFreshEntity((Entity)waveentity);
            }
        }
    }

    public boolean addEffect(MobEffectInstance p_182397_, @Nullable Entity p_182398_) {
        return false;
    }
}

