/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.Sentities.AI.CustomMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.HybridPathNavigation;
import com.Harbinger.Spore.Sentities.ArmorPersentageBypass;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.MovementControls.InfectedWallMovementControl;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Specter
extends UtilityEntity
implements Enemy,
ArmorPersentageBypass {
    public static final EntityDataAccessor<Boolean> INVISIBLE = SynchedEntityData.defineId(Specter.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> BIOMASS = SynchedEntityData.defineId(Specter.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> STOMACH = SynchedEntityData.defineId(Specter.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final List<BlockState> states = new ArrayList<BlockState>(){
        {
            this.add(Blocks.TORCH.defaultBlockState());
            this.add(Blocks.REDSTONE_TORCH.defaultBlockState());
            this.add(Blocks.TNT.defaultBlockState());
        }
    };
    @Nullable
    private BlockPos Targetpos;

    public Specter(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.moveControl = new InfectedWallMovementControl((Mob)this);
        this.navigation = new HybridPathNavigation((Mob)this, this.level());
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.gastgaber_loot.get();
    }

    public void travel(Vec3 vec) {
        if (this.isEffectiveAi() && this.isInFluidType()) {
            this.moveRelative(0.1f, vec);
            this.move(MoverType.SELF, this.getDeltaMovement());
            Vec3 vec3 = this.moveControl.getWantedY() > this.getY() ? new Vec3(0.0, 0.01, 0.0) : new Vec3(0.0, -0.01, 0.0);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.75).add(vec3));
            if (this.navigation.canFloat() && this.getRandom().nextFloat() < 0.4f) {
                this.getJumpControl().jump();
            }
        } else {
            super.travel(vec);
        }
    }

    public boolean removeWhenFarAway(double value) {
        return false;
    }

    public boolean dampensVibrations() {
        return this.isInvisible();
    }

    public boolean canBeSeenByAnyone() {
        return !this.isInvisible();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, (Double)SConfig.SERVER.specter_hp.get() * (Double)SConfig.SERVER.global_health.get()).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.ATTACK_DAMAGE, (Double)SConfig.SERVER.specter_damage.get() * (Double)SConfig.SERVER.global_damage.get()).add(Attributes.ARMOR, (Double)SConfig.SERVER.specter_armor.get() * (Double)SConfig.SERVER.global_armor.get()).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.STEP_HEIGHT, 1.0).add(Attributes.ATTACK_KNOCKBACK, 3.0);
    }

    private void buffAI() {
        if (this.getHealth() < this.getMaxHealth() && !this.hasEffect(MobEffects.REGENERATION)) {
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 400, this.getHealth() < this.getMaxHealth() / 2.0f ? 1 : 0));
            this.setBiomass(this.getBiomass() - 1);
        }
        if (this.isOnFire() && !this.hasEffect(MobEffects.FIRE_RESISTANCE)) {
            this.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 200, 0));
            this.setBiomass(this.getBiomass() - 1);
        }
    }

    protected void registerGoals() {
        this.addTargettingGoals();
        this.goalSelector.addGoal(3, (Goal)new CustomMeleeAttackGoal(this, this, 1.2, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 4.0 + (double)(entity.getBbWidth() * entity.getBbWidth());
            }
        });
        this.goalSelector.addGoal(4, (Goal)new SearchAroundGoal(this));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        super.registerGoals();
    }

    public void setInvisible(boolean value) {
        this.entityData.set(INVISIBLE, (Object)value);
    }

    public boolean isInvisible() {
        return (Boolean)this.entityData.get(INVISIBLE);
    }

    public void setBiomass(int value) {
        this.entityData.set(BIOMASS, (Object)value);
    }

    public int getBiomass() {
        return (Integer)this.entityData.get(BIOMASS);
    }

    public void setStomach(int value) {
        this.entityData.set(STOMACH, (Object)value);
    }

    public int getStomach() {
        return (Integer)this.entityData.get(STOMACH);
    }

    @Nullable
    public BlockPos getTargetPos() {
        return this.Targetpos;
    }

    public void setTargetPos(@Nullable BlockPos pos) {
        this.Targetpos = pos;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(INVISIBLE, (Object)false);
        builder.define(STOMACH, (Object)0);
        builder.define(BIOMASS, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setInvisible(tag.getBoolean("invisible"));
        this.setBiomass(tag.getInt("biomass"));
        this.setStomach(tag.getInt("stomach"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("invisible", this.isInvisible());
        tag.putInt("biomass", this.getBiomass());
        tag.putInt("stomach", this.getStomach());
    }

    private boolean food(Container container) {
        return container.hasAnyMatching(item -> item.getFoodProperties((LivingEntity)this) != null);
    }

    public void searchBlocks() {
        AABB aabb = this.getBoundingBox().inflate(32.0, 4.0, 32.0);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            Container container;
            BlockState block = this.level().getBlockState(blockpos);
            BlockEntity blockEntity = this.level().getBlockEntity(blockpos);
            if (!states.contains(block) && (!(blockEntity instanceof Container) || !this.food(container = (Container)blockEntity)) || !this.hasLineOfSightBlocks(blockpos) || !(this.random.nextFloat() < 0.5f)) continue;
            this.setTargetPos(blockpos);
            break;
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 200, 1));
            livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 100, 0));
        }
        return super.doHurtTarget(entity);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public void awardKillScore(Entity p_19953_, int p_19954_, DamageSource p_19955_) {
        this.setBiomass(this.getBiomass() + 1);
        super.awardKillScore(p_19953_, p_19954_, p_19955_);
    }

    public boolean blockBreakingParameter(BlockState blockstate, BlockPos blockpos) {
        float value = blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos);
        return this.tickCount % 20 == 0 && value > 0.0f && value <= (float)this.getBreaking();
    }

    public int getBreaking() {
        return (Integer)SConfig.SERVER.hyper_bd.get();
    }

    public boolean hasLineOfSightBlocks(BlockPos pos) {
        BlockHitResult raytraceresult = this.level().clip(new ClipContext(this.getEyePosition(1.0f), new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        BlockPos position = raytraceresult.getBlockPos();
        return pos.equals((Object)position) || this.level().isEmptyBlock(pos) || this.level().getBlockEntity(pos) == this.level().getBlockEntity(position);
    }

    public void tick() {
        super.tick();
        if (this.tickCount % 200 == 0) {
            this.searchBlocks();
            if ((float)this.getStomach() > 10.0f) {
                this.setBiomass(this.getBiomass() + 1);
                this.setStomach(this.getStomach() - 10);
            }
        }
        if (this.tickCount % 20 == 0 && this.getBiomass() > 0) {
            this.buffAI();
        }
        if (this.tickCount % 40 == 0 && this.horizontalCollision && EventHooks.canEntityGrief((Level)this.level(), (Entity)this)) {
            this.griefBlocks(this.getTarget());
        }
    }

    public void setTarget(@Nullable LivingEntity entity) {
        super.setTarget(entity);
        this.setInvisible(entity != null && entity.distanceToSqr((Entity)this) > 50.0);
    }

    private void griefBlocks(LivingEntity livingEntity) {
        AABB aabb = livingEntity != null && livingEntity.getY() > this.getY() ? this.getBoundingBox().inflate(-0.2, 0.5, -0.2).move(0.0, 0.5, 0.0) : this.getBoundingBox().inflate(0.5).move(0.0, 0.5, 0.0);
        for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
            BlockState blockstate = this.level().getBlockState(blockpos);
            if (!this.blockBreakingParameter(blockstate, blockpos)) continue;
            this.interactBlock(blockpos, this.level());
        }
    }

    protected SoundEvent getAmbientSound() {
        return this.isInvisible() ? null : Ssounds.SPECTER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_34327_) {
        return Ssounds.EVOLVE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.ZOMBIE_STEP;
    }

    public boolean hasLineOfSight(Entity entity) {
        InventoryCarrier carrier;
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).hasEffect(Seffects.MARKER)) {
            return true;
        }
        if (entity instanceof InventoryCarrier && (carrier = (InventoryCarrier)entity).getInventory().hasAnyMatching(item -> item.getFoodProperties((LivingEntity)this) != null)) {
            return true;
        }
        return super.hasLineOfSight(entity);
    }

    public boolean interractWithBlock(BlockPos pos) {
        Container container;
        BlockEntity blockEntity = this.level().getBlockEntity(pos);
        if (blockEntity instanceof Container && this.food(container = (Container)blockEntity)) {
            for (int i = 0; i < container.getContainerSize(); ++i) {
                ItemStack stack = container.getItem(i);
                FoodProperties properties = stack.getFoodProperties((LivingEntity)this);
                if (properties == null) continue;
                int amount = stack.getCount() > 1 ? this.random.nextInt(stack.getCount()) : stack.getCount();
                this.playSound(SoundEvents.GENERIC_EAT);
                stack.shrink(amount);
                this.setStomach(this.getStomach() + (int)((float)properties.nutrition() + properties.saturation()) * amount);
            }
        } else {
            this.level().destroyBlock(pos, true, (Entity)this);
        }
        return true;
    }

    public boolean hurt(DamageSource source, float p_21017_) {
        if (source.getEntity() != null && this.random.nextFloat() < 0.1f) {
            ScentEntity scent = new ScentEntity(Sentities.SCENT.get(), this.level());
            scent.moveTo(this.getX(), this.getY(), this.getZ());
            this.level().addFreshEntity((Entity)scent);
        }
        return super.hurt(source, p_21017_);
    }

    protected int calculateFallDamage(float p_21237_, float p_21238_) {
        return super.calculateFallDamage(p_21237_, p_21238_) - 15;
    }

    @Override
    public float amountOfDamage(float value) {
        return (float)((Double)SConfig.SERVER.specter_damage.get() * (Double)SConfig.SERVER.global_damage.get() / 4.0);
    }

    public boolean interactBlock(BlockPos blockPos, Level level) {
        BlockState state = level.getBlockState(blockPos);
        return level.destroyBlock(blockPos, false, (Entity)this);
    }

    public static class SearchAroundGoal
    extends Goal {
        private final Specter specter;
        public int tryTicks;

        public SearchAroundGoal(Specter specter) {
            this.specter = specter;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return this.specter.getTargetPos() != null && this.specter.getTarget() == null;
        }

        protected void moveToBlock(BlockPos pos) {
            if (pos != null) {
                this.specter.navigation.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 1.0);
            }
        }

        public void start() {
            this.moveToBlock(this.specter.getTargetPos());
            this.tryTicks = 0;
            super.start();
        }

        public boolean canContinueToUse() {
            return this.specter.getTarget() == null;
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            super.tick();
            ++this.tryTicks;
            BlockPos pos = this.specter.getTargetPos();
            if (pos != null && this.shouldRecalculatePath()) {
                this.moveToBlock(pos);
            }
            if (pos != null && pos.closerToCenterThan((Position)this.specter.position(), 3.5)) {
                this.specter.interractWithBlock(pos);
                this.openChest(pos);
                this.specter.setTargetPos(null);
                this.specter.searchBlocks();
            }
        }

        public void openChest(BlockPos pos) {
            BlockEntity entity = this.specter.level().getBlockEntity(pos);
            if (entity instanceof ChestBlockEntity) {
                ChestBlockEntity chestBlock = (ChestBlockEntity)entity;
                this.specter.playSound(SoundEvents.CHEST_OPEN);
                this.specter.level().blockEvent(pos, chestBlock.getBlockState().getBlock(), 1, 1);
                this.specter.level().updateNeighborsAt(pos, chestBlock.getBlockState().getBlock());
                this.specter.level().updateNeighborsAt(pos.below(), chestBlock.getBlockState().getBlock());
            }
        }
    }
}

