/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.Calamities.Hinderburg;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Ssounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.EventHooks;

public class TumoroidNuke
extends UtilityEntity {
    public static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.defineId(Hinderburg.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> OVERCLOCKED = SynchedEntityData.defineId(Hinderburg.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> BUSTER = SynchedEntityData.defineId(Hinderburg.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private Hinderburg hinderburg;

    public TumoroidNuke(Level level, Hinderburg hinderburg) {
        super(Sentities.TUMOROID_NUKE.get(), level);
        this.hinderburg = hinderburg;
        this.moveTo(hinderburg.getX(), hinderburg.getY(), hinderburg.getZ());
        this.setYBodyRot(hinderburg.getYRot());
        this.setTimer(80);
    }

    public TumoroidNuke(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TIMER, (Object)0);
        builder.define(OVERCLOCKED, (Object)false);
        builder.define(BUSTER, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("timer", ((Integer)this.entityData.get(TIMER)).intValue());
        tag.putBoolean("overclocked", ((Boolean)this.entityData.get(OVERCLOCKED)).booleanValue());
        tag.putBoolean("buster", ((Boolean)this.entityData.get(BUSTER)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(TIMER, (Object)tag.getInt("timer"));
        this.entityData.set(OVERCLOCKED, (Object)tag.getBoolean("overclocked"));
        this.entityData.set(BUSTER, (Object)tag.getBoolean("buster"));
    }

    public int getTimer() {
        return (Integer)this.entityData.get(TIMER);
    }

    public void setTimer(int e) {
        this.entityData.set(TIMER, (Object)e);
    }

    private void tickTimer() {
        this.setTimer(this.getTimer() - 1);
    }

    public void setOverclocked(boolean value) {
        this.entityData.set(OVERCLOCKED, (Object)value);
    }

    public void setBuster(boolean value) {
        this.entityData.set(BUSTER, (Object)value);
    }

    public void tick() {
        super.tick();
        this.tickTimer();
        if (this.getTimer() <= 0) {
            if (((Boolean)this.entityData.get(BUSTER)).booleanValue()) {
                this.explodeNuke(new BlockPos(0, 0, 0), (Boolean)this.entityData.get(OVERCLOCKED), (Integer)SConfig.SERVER.hinden_explosion.get() / 2);
                this.explodeNuke(new BlockPos(0, -5, 0), (Boolean)this.entityData.get(OVERCLOCKED), (Integer)SConfig.SERVER.hinden_explosion.get() / 2);
                this.explodeNuke(new BlockPos(0, -10, 0), (Boolean)this.entityData.get(OVERCLOCKED), (Integer)SConfig.SERVER.hinden_explosion.get() / 2);
            } else {
                this.explodeNuke(new BlockPos(0, 0, 0), (Boolean)this.entityData.get(OVERCLOCKED), (Integer)SConfig.SERVER.hinden_explosion.get());
            }
        }
    }

    protected SoundEvent getAmbientSound() {
        return Ssounds.WOMB_AMBIENT.get();
    }

    protected int calculateFallDamage(float value1, float value2) {
        if (!this.level().isClientSide && EventHooks.canEntityGrief((Level)this.level(), (Entity)this) && this.fallDistance > 4.0f) {
            AABB aabb = this.getBoundingBox().inflate(1.0);
            for (BlockPos blockpos : BlockPos.betweenClosed((int)Mth.floor((double)aabb.minX), (int)Mth.floor((double)aabb.minY), (int)Mth.floor((double)aabb.minZ), (int)Mth.floor((double)aabb.maxX), (int)Mth.floor((double)aabb.maxY), (int)Mth.floor((double)aabb.maxZ))) {
                BlockState blockstate = this.level().getBlockState(blockpos);
                if (!(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) < 3.0f) || !(blockstate.getDestroySpeed((BlockGetter)this.level(), blockpos) >= 0.0f)) continue;
                this.level().destroyBlock(blockpos, false, (Entity)this);
            }
        }
        return super.calculateFallDamage(value1, value2);
    }

    public boolean hurt(DamageSource p_21016_, float p_21017_) {
        return false;
    }

    public void explodeNuke(BlockPos offset, boolean fire, int value) {
        if (!this.level().isClientSide) {
            Level level;
            UtilityEntity entity = this.hinderburg != null ? this.hinderburg : this;
            Level.ExplosionInteraction explosion$blockinteraction = EventHooks.canEntityGrief((Level)this.level(), (Entity)this) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
            this.level().explode((Entity)entity, this.getX() + (double)offset.getX(), this.getY() + (double)offset.getY(), this.getZ() + (double)offset.getZ(), (float)value, explosion$blockinteraction);
            if (fire && (level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Utilities.convertBlocks(serverLevel, (Entity)this, this.getOnPos(), 14.0, Blocks.FIRE.defaultBlockState());
            }
            this.level().playSound((Entity)this, this.blockPosition(), Ssounds.TUMOROID_EXPLOSION.get(), SoundSource.MASTER, 1.0f, 1.0f);
            this.discard();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.FOLLOW_RANGE, 4.0);
    }
}

