/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Utility;

import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.core.Sentities;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class WaveEntity
extends UtilityEntity {
    public PathfinderMob owner;
    private int life;

    public WaveEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    public WaveEntity(Level level, PathfinderMob entity) {
        super(Sentities.WAVE.get(), level);
        this.owner = entity;
        this.life = 160;
        this.moveTo(this.owner.getX(), this.owner.getY(), this.owner.getZ());
        this.setTarget(this.owner.getTarget());
    }

    public void tick() {
        super.tick();
        if (this.life <= 0 || this.owner == null || this.getTarget() == null) {
            this.discard();
        } else {
            --this.life;
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new AOEMeleeAttackGoal(this, 1.1, false, 2.0, 1.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        super.registerGoals();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, 0.35).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.STEP_HEIGHT, 1.5).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public boolean hurt(DamageSource p_21016_, float p_21017_) {
        return false;
    }

    public void aiStep() {
        Level level;
        super.aiStep();
        BlockState block = this.level().getBlockState(this.getOnPos());
        Item item = block.getBlock().asItem();
        double x = this.getX() + (double)this.random.nextInt(-2, 2);
        double z = this.getZ() + (double)this.random.nextInt(-2, 2);
        if (item != ItemStack.EMPTY.getItem() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)item)), x, this.getY(), z, 3, ((double)this.random.nextFloat() - 1.0) * 0.08, ((double)this.random.nextFloat() - 1.0) * 0.08, ((double)this.random.nextFloat() - 1.0) * 0.08, (double)0.15f);
        }
    }

    @Override
    public boolean doHurtTarget(Entity entity) {
        entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, 0.1, 0.0));
        this.discard();
        return super.doHurtTarget(entity);
    }
}

