/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sevents;

import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Fluids.BileLiquid;
import com.Harbinger.Spore.Sentities.ArmorPersentageBypass;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Protector;
import com.Harbinger.Spore.Sentities.EvolvingInfected;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import com.Harbinger.Spore.Sentities.Utility.Illusion;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import com.Harbinger.Spore.Sitems.BaseWeapons.DamagePiercingModifier;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeBaseArmor;
import com.Harbinger.Spore.Sitems.PCI;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Senchantments;
import com.Harbinger.Spore.core.Sentities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class DamageHandeling {
    private static float clampMin(float current, float min) {
        return Math.max(current, min);
    }

    public static void DefenseBypass(LivingDamageEvent.Pre event) {
        Level lvl;
        Entity summoner;
        CompoundTag tag;
        Level lvl2;
        Entity summoner2;
        Mob mob;
        CompoundTag tag2;
        MobEffectInstance inst;
        LivingEntity living;
        Object protectorList;
        Infected victim;
        Player player;
        float dmg;
        Entity attacker = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        float modified = dmg = event.getNewDamage();
        if (attacker instanceof Player) {
            PCI pci;
            ItemStack weapon;
            Item item;
            player = (Player)attacker;
            if (target.getItemBySlot(EquipmentSlot.CHEST).isEmpty() && (item = (weapon = player.getMainHandItem()).getItem()) instanceof PCI && (pci = (PCI)item).getCharge(weapon) > 0 && !player.getCooldowns().isOnCooldown((Item)pci)) {
                float targetHealth = target.getHealth();
                int charge = pci.getCharge(weapon);
                int dmgMod = (Integer)SConfig.SERVER.pci_damage_multiplier.get();
                int freezeDamage = (float)charge >= targetHealth ? (int)targetHealth : charge;
                boolean freeze = target.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES);
                modified = DamageHandeling.clampMin(modified, freeze ? freezeDamage * dmgMod : freezeDamage);
                target.setTicksFrozen(600);
                pci.setCharge(weapon, charge - freezeDamage);
                player.getCooldowns().addCooldown((Item)pci, (int)Math.ceil(targetHealth / 5.0f) * 20);
                pci.playSound(player);
            }
        }
        if (target instanceof Infected && !((victim = (Infected)target) instanceof Protector)) {
            LivingEntity le;
            LivingEntity lAttacker;
            LivingEntity livingEntity = lAttacker = attacker instanceof LivingEntity ? (le = (LivingEntity)attacker) : null;
            if (lAttacker != null) {
                protectorList = SporeSavedData.protectorList();
                Iterator targetHealth = protectorList.iterator();
                while (targetHealth.hasNext()) {
                    Protector protector = (Protector)targetHealth.next();
                    if (!protector.isAlive() || !(protector.distanceTo((Entity)lAttacker) < 64.0f) || lAttacker.isSpectator() || !Utilities.TARGET_SELECTOR.Test(lAttacker)) continue;
                    protector.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 100, 0));
                    protector.setTarget(lAttacker);
                }
            }
        }
        if (attacker instanceof ArmorPersentageBypass) {
            ArmorPersentageBypass bypass = (ArmorPersentageBypass)attacker;
            float minimum = bypass.amountOfDamage(dmg);
            modified = DamageHandeling.clampMin(modified, minimum);
        }
        if (attacker instanceof LivingEntity && (protectorList = (living = (LivingEntity)attacker).getMainHandItem().getItem()) instanceof DamagePiercingModifier) {
            DamagePiercingModifier pierce = (DamagePiercingModifier)protectorList;
            float minimum = pierce.getMinimalDamage(dmg);
            modified = DamageHandeling.clampMin(modified, minimum);
        }
        if (attacker instanceof UtilityEntity && !(attacker instanceof Illusion) && (inst = target.getEffect(Seffects.MADNESS)) != null) {
            int level = inst.getAmplifier();
            int dur = inst.getDuration() + 1200;
            boolean jump = dur < 12000;
            target.addEffect(new MobEffectInstance(Seffects.MADNESS, jump ? dur : dur - 12000, jump ? level : level + 1));
        }
        if (target instanceof Player) {
            player = (Player)target;
            for (ItemStack stack : player.getArmorSlots()) {
                Item protector = stack.getItem();
                if (!(protector instanceof SporeBaseArmor)) continue;
                SporeBaseArmor armor = (SporeBaseArmor)protector;
                modified += armor.calculateAdditionalDamage(event.getSource(), stack, dmg);
            }
        }
        if (attacker instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)attacker;
            int fire = 0;
            int thornLevel = 0;
            for (ItemStack stack : sp.getInventory().armor) {
                SporeBaseArmor base;
                Item freezeDamage = stack.getItem();
                if (freezeDamage instanceof SporeBaseArmor && (base = (SporeBaseArmor)freezeDamage).getVariant(stack) == SporeArmorMutations.CHARRED) {
                    fire += 2;
                }
                if (!(stack.getItem() instanceof ArmorItem)) continue;
                thornLevel += thornLevel;
            }
            if (fire > 0) {
                target.setRemainingFireTicks(fire * 20);
            }
        }
        if (attacker instanceof LivingEntity) {
            Infected infected;
            living = (LivingEntity)attacker;
            int thornLevel = 0;
            int mutagenic = 0;
            int unwavering = 0;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack;
                if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || (stack = target.getItemBySlot(slot)).isEmpty()) continue;
                if (Senchantments.hasEnchant((LevelAccessor)target.level(), stack, Senchantments.SERRATED_THORNS)) {
                    ++thornLevel;
                }
                if (Senchantments.hasEnchant((LevelAccessor)target.level(), stack, Senchantments.MUTAGENIC_REACTANT)) {
                    ++mutagenic;
                }
                if (!Senchantments.hasEnchant((LevelAccessor)target.level(), stack, Senchantments.UNWAVERING_NATURE)) continue;
                ++unwavering;
            }
            if (thornLevel > 0) {
                DamageHandeling.handleSpikes(thornLevel, living);
            }
            if (mutagenic > 0) {
                DamageHandeling.mutagenicLevel(mutagenic, target);
            }
            if (unwavering > 0) {
                DamageHandeling.unWavering(unwavering, target);
            }
            if (Senchantments.hasEnchant((LevelAccessor)living.level(), living.getItemBySlot(EquipmentSlot.HEAD), Senchantments.VORACIOUS_MAW) && Math.random() < (double)0.1f && living instanceof Player) {
                Player player2 = (Player)living;
                player2.playNotifySound(SoundEvents.GENERIC_EAT, SoundSource.AMBIENT, 1.0f, 1.0f);
                player2.getFoodData().eat(6, 0.0f);
            }
            if (Senchantments.hasEnchant((LevelAccessor)living.level(), living.getItemBySlot(EquipmentSlot.MAINHAND), Senchantments.CORROSIVE_POTENCY)) {
                target.addEffect(new MobEffectInstance(Seffects.CORROSION, 60, 1));
            }
            if (Senchantments.hasEnchant((LevelAccessor)living.level(), living.getItemBySlot(EquipmentSlot.MAINHAND), Senchantments.UNWAVERING_NATURE)) {
                target.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 600, 1));
            }
            if (Senchantments.hasEnchant((LevelAccessor)living.level(), living.getItemBySlot(EquipmentSlot.MAINHAND), Senchantments.CRYOGENIC_ASPECT)) {
                target.setTicksFrozen(target.getTicksFrozen() + 300);
            }
            if (Senchantments.hasEnchant((LevelAccessor)living.level(), living.getItemBySlot(EquipmentSlot.MAINHAND), Senchantments.GASTRIC_SPEWAGE)) {
                for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                    target.addEffect(instance);
                }
            }
            if (Senchantments.hasEnchant((LevelAccessor)living.level(), living.getItemBySlot(EquipmentSlot.MAINHAND), Senchantments.MUTAGENIC_REACTANT) && Math.random() < 0.1 && target instanceof Infected && (infected = (Infected)target) instanceof EvolvingInfected) {
                EvolvingInfected evolvedInfected = (EvolvingInfected)((Object)infected);
                if (evolvedInfected instanceof EvolvedInfected) {
                    EvolvedInfected evolved = (EvolvedInfected)((Object)evolvedInfected);
                    evolved.setEvolution((Integer)SConfig.SERVER.evolution_age_human.get());
                    evolved.setEvoPoints(evolved.getEvoPoints() + (Integer)SConfig.SERVER.min_kills_hyper.get());
                } else {
                    infected.setEvolution((Integer)SConfig.SERVER.evolution_age_human.get());
                    infected.setEvoPoints(infected.getEvoPoints() + (Integer)SConfig.SERVER.min_kills.get());
                }
                if (living instanceof Player) {
                    Player player3 = (Player)living;
                    player3.getFoodData().setFoodLevel(player3.getFoodData().getFoodLevel() / 2);
                }
            }
        }
        if (attacker instanceof Mob && (tag2 = (mob = (Mob)attacker).getPersistentData()).contains("hivemind") && (summoner2 = (lvl2 = mob.level()).getEntity(tag2.getInt("hivemind"))) instanceof Proto) {
            Proto proto = (Proto)summoner2;
            proto.praisedForDecision(tag2.getInt("decision"), tag2.getInt("member"));
        }
        if (target instanceof Mob && (tag = (mob = (Mob)target).getPersistentData()).contains("hivemind") && (summoner = (lvl = mob.level()).getEntity(tag.getInt("hivemind"))) instanceof Proto) {
            Proto proto = (Proto)summoner;
            proto.punishForDecision(tag.getInt("decision"), tag.getInt("member"));
        }
        event.setNewDamage(modified);
    }

    public static void handleSpikes(int thornLevel, LivingEntity living) {
        int duration = 40 + thornLevel * 40;
        living.hurt(living.damageSources().thorns((Entity)living), 3.5f * (float)thornLevel);
        if (Math.random() < 0.5) {
            living.addEffect(new MobEffectInstance(MobEffects.POISON, duration, 0, false, true));
        } else {
            living.addEffect(new MobEffectInstance(Seffects.CORROSION, duration, 0, false, true));
        }
    }

    public static void mutagenicLevel(int mutagenic, LivingEntity living) {
        if (Math.random() < 0.2) {
            for (int i = 0; i < mutagenic; ++i) {
                MobEffectInstance effect = DamageHandeling.badMutations().get(living.getRandom().nextInt(DamageHandeling.badMutations().size()));
                living.addEffect(effect);
            }
        }
    }

    public static void unWavering(int nature, LivingEntity living) {
        for (int i = 0; i < nature; ++i) {
            if (!living.hasEffect(Seffects.MYCELIUM)) {
                living.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 600, 0));
            }
            if (!(Math.random() < 0.05)) continue;
            ScentEntity scent = new ScentEntity(Sentities.SCENT.get(), living.level());
            scent.moveTo(living.getX(), living.getY(), living.getZ());
            living.level().addFreshEntity((Entity)scent);
        }
    }

    public static List<MobEffectInstance> badMutations() {
        ArrayList<MobEffectInstance> values = new ArrayList<MobEffectInstance>();
        values.add(new MobEffectInstance(MobEffects.WEAKNESS, 160, 0));
        values.add(new MobEffectInstance(MobEffects.POISON, 80, 0));
        values.add(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 0));
        values.add(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
        return values;
    }
}

