/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sevents;

import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.Projectile.AcidBall;
import com.Harbinger.Spore.Sentities.Projectile.BileProjectile;
import com.Harbinger.Spore.Sentities.Projectile.FleshBomb;
import com.Harbinger.Spore.Sentities.Projectile.StingerProjectile;
import com.Harbinger.Spore.Sentities.Projectile.Vomit;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import com.Harbinger.Spore.core.SConfig;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public class DespawnSystem {
    private static int tickCounter = 0;
    private static final int CHECK_INTERVAL = 1200;

    public static void tickMobCleaner(MinecraftServer server) {
        if (++tickCounter >= 1200) {
            if (server != null) {
                for (ServerLevel level : server.getAllLevels()) {
                    DespawnSystem.cleanUpMobs(level);
                }
            }
            tickCounter = 0;
        }
    }

    private static void cleanUpMobs(ServerLevel level) {
        ArrayList<Infected> infected = new ArrayList<Infected>();
        ArrayList<Object> projectileExcess = new ArrayList<Object>();
        ArrayList<EvolvedInfected> evolved = new ArrayList<EvolvedInfected>();
        ArrayList<Hyper> hyper = new ArrayList<Hyper>();
        ArrayList<Organoid> organoid = new ArrayList<Organoid>();
        ArrayList<ScentEntity> scent = new ArrayList<ScentEntity>();
        for (Entity entity : level.getAllEntities()) {
            Entity entity2;
            if (((List)SConfig.SERVER.despawn_blacklist.get()).contains(entity.getEncodeId()) || entity.hasCustomName()) continue;
            Objects.requireNonNull(entity);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Organoid.class, EvolvedInfected.class, Hyper.class, ScentEntity.class, Infected.class, AcidBall.class, BileProjectile.class, StingerProjectile.class, Vomit.class, FleshBomb.class}, (Object)entity2, n)) {
                case 0: {
                    Organoid o = (Organoid)entity2;
                    organoid.add(o);
                    break;
                }
                case 1: {
                    EvolvedInfected e = (EvolvedInfected)entity2;
                    evolved.add(e);
                    break;
                }
                case 2: {
                    Hyper h = (Hyper)entity2;
                    hyper.add(h);
                    break;
                }
                case 3: {
                    ScentEntity s = (ScentEntity)entity2;
                    scent.add(s);
                    break;
                }
                case 4: {
                    Infected i = (Infected)entity2;
                    infected.add(i);
                    break;
                }
                case 5: {
                    AcidBall i = (AcidBall)entity2;
                    projectileExcess.add((Object)i);
                    break;
                }
                case 6: {
                    BileProjectile i = (BileProjectile)entity2;
                    projectileExcess.add((Object)i);
                    break;
                }
                case 7: {
                    StingerProjectile i = (StingerProjectile)entity2;
                    projectileExcess.add((Object)i);
                    break;
                }
                case 8: {
                    Vomit i = (Vomit)entity2;
                    projectileExcess.add((Object)i);
                    break;
                }
                case 9: {
                    FleshBomb i = (FleshBomb)entity2;
                    projectileExcess.add((Object)i);
                    break;
                }
            }
        }
        DespawnSystem.despawnExcess(level, infected, (Integer)SConfig.SERVER.max_infected_cap.get());
        DespawnSystem.despawnExcess(level, evolved, (Integer)SConfig.SERVER.max_evolved_cap.get());
        DespawnSystem.despawnExcess(level, hyper, (Integer)SConfig.SERVER.max_hyper_cap.get());
        DespawnSystem.despawnExcess(level, organoid, (Integer)SConfig.SERVER.max_organoid_cap.get());
        DespawnSystem.despawnExcess(level, scent, (Integer)SConfig.SERVER.max_scent_cap.get());
        DespawnSystem.despawnExcess(level, projectileExcess, 100);
    }

    private static <T extends Entity> void despawnExcess(ServerLevel level, List<T> entities, int cap) {
        if (entities.size() <= cap) {
            return;
        }
        int toRemove = entities.size() - cap;
        int despawns = 0;
        List players = level.getPlayers(p -> true);
        if (players.isEmpty()) {
            for (int i = 0; i < toRemove; ++i) {
                Entity entity = (Entity)entities.get(i);
                entity.discard();
                ++despawns;
            }
        } else {
            entities.sort(Comparator.comparingDouble(e -> level.getNearestPlayer(e, -1.0) != null ? e.distanceToSqr((Entity)Objects.requireNonNull(level.getNearestPlayer(e, -1.0))) : Double.MAX_VALUE).reversed());
            for (int i = 0; i < toRemove; ++i) {
                Entity entity = (Entity)entities.get(i);
                entity.discard();
                ++despawns;
            }
        }
        System.out.println("Despawned " + despawns + " mobs in level: " + String.valueOf(level.dimension().location()));
    }
}

