/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sevents;

import com.Harbinger.Spore.ExtremelySusThings.ChunkLoadRequest;
import com.Harbinger.Spore.ExtremelySusThings.ChunkLoaderHelper;
import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.Organoid;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.BasicInfected.InfectedDrowned;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Protector;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import com.Harbinger.Spore.Sevents.Commands;
import com.Harbinger.Spore.Sevents.DamageHandeling;
import com.Harbinger.Spore.Sevents.DespawnSystem;
import com.Harbinger.Spore.Sevents.Infection;
import com.Harbinger.Spore.Sevents.LivingTickEvent;
import com.Harbinger.Spore.Sevents.MobAttributes;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeBaseArmor;
import com.Harbinger.Spore.Spore;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.SblockEntities;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import com.Harbinger.Spore.core.Sitems;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="spore")
public class HandlerEvents {
    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        DespawnSystem.tickMobCleaner(event.getServer());
        ChunkLoaderHelper.tick();
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            ChunkLoadRequest.loadChunkData(level);
        }
    }

    @SubscribeEvent
    public static void TickEvents(PlayerTickEvent.Pre event) {
        int amplifier;
        LivingTickEvent.TickEffects(event);
        Player player = event.getEntity();
        Level level = player.level();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            Item item;
            ItemStack armorStack;
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || (armorStack = player.getItemBySlot(slot)).isEmpty() || !((item = armorStack.getItem()) instanceof SporeBaseArmor)) continue;
            SporeBaseArmor sporeBaseArmor = (SporeBaseArmor)item;
            if (level.isClientSide) continue;
            sporeBaseArmor.tickArmor(player, level);
        }
        Holder<MobEffect> madnessHolder = Seffects.MADNESS;
        MobEffectInstance effectInstance = player.getEffect(madnessHolder);
        if (effectInstance != null && effectInstance.getDuration() == 1 && (amplifier = effectInstance.getAmplifier()) > 0) {
            player.removeEffect(madnessHolder);
            player.addEffect(new MobEffectInstance(madnessHolder, 12000, amplifier - 1));
        }
    }

    @SubscribeEvent
    private static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, SblockEntities.SURGERY_TABLE_ENTITY.get(), (blockEntity, context) -> blockEntity.getItemHandler());
    }

    @SubscribeEvent
    private static void registerAttributes(EntityAttributeCreationEvent event) {
        MobAttributes.registerAttributes(event);
    }

    @SubscribeEvent
    public static void Command(RegisterCommandsEvent event) {
        Commands.Command(event);
    }

    @SubscribeEvent
    public static void TickEvents(EntityTickEvent.Pre event) {
        LivingTickEvent.TickEvents(event);
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        Infection.onEntityDeath(event);
    }

    @SubscribeEvent
    public static void DefenseBypass(LivingDamageEvent.Pre event) {
        DamageHandeling.DefenseBypass(event);
    }

    @SubscribeEvent
    public static void NoSleep(CanPlayerSleepEvent event) {
        ServerPlayer player = event.getEntity();
        if (player.hasEffect(Seffects.UNEASY)) {
            player.displayClientMessage((Component)Component.translatable((String)"uneasy.message"), true);
            event.setProblem(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        LivingEntity living;
        Entity entity;
        if (event.getProjectile() instanceof Snowball && event.getRayTraceResult().getType() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)event.getRayTraceResult()).getEntity()) instanceof LivingEntity && (living = (LivingEntity)entity).canFreeze()) {
            living.setTicksFrozen(living.getTicksFrozen() + 100);
        }
    }

    @SubscribeEvent
    public static void DiscardProto(EntityLeaveLevelEvent event) {
        Entity entity;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof Protector) {
            Protector protector = (Protector)entity2;
            SporeSavedData.removeProtector(protector);
        }
        if ((entity = event.getEntity()) instanceof Proto) {
            Proto proto = (Proto)entity;
            entity = event.getLevel();
            if (entity instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)entity;
                SporeSavedData.removeHivemind(level, proto);
            }
        }
    }

    @SubscribeEvent
    public static void LoadCalamity(EntityEvent.EnteringSection event) {
        Proto proto;
        ChunkLoadRequest request;
        String id;
        UUID ownerId;
        ChunkPos chunk;
        SectionPos NewChunk;
        Entity OldChunk;
        ServerLevel level;
        Calamity calamity;
        Entity entity = event.getEntity();
        if (entity instanceof Calamity && (entity = (calamity = (Calamity)entity).level()) instanceof ServerLevel) {
            level = (ServerLevel)entity;
            if (calamity.getSearchArea() != BlockPos.ZERO) {
                OldChunk = event.getOldPos();
                NewChunk = event.getNewPos();
                if (((Boolean)SConfig.SERVER.calamity_chunk.get()).booleanValue() && event.didChunkChange() && OldChunk != NewChunk && calamity.getSearchArea() != BlockPos.ZERO) {
                    chunk = NewChunk.chunk();
                    ownerId = calamity.getUUID();
                    id = "calamity_" + String.valueOf(ownerId) + "_" + chunk.toString();
                    request = new ChunkLoadRequest((ResourceKey<Level>)level.dimension(), new ChunkPos[]{chunk}, 0, id, 600L, ownerId);
                    ChunkLoaderHelper.addRequest(request);
                }
            }
        }
        if ((OldChunk = event.getEntity()) instanceof Proto && (OldChunk = (proto = (Proto)OldChunk).level()) instanceof ServerLevel) {
            level = (ServerLevel)OldChunk;
            if (((Boolean)SConfig.SERVER.proto_chunk.get()).booleanValue()) {
                OldChunk = event.getOldPos();
                NewChunk = event.getNewPos();
                if (event.didChunkChange() && OldChunk != NewChunk) {
                    chunk = NewChunk.chunk();
                    ownerId = proto.getUUID();
                    id = "hivemind_" + String.valueOf(ownerId) + "_" + chunk.toString();
                    request = new ChunkLoadRequest((ResourceKey<Level>)level.dimension(), new ChunkPos[]{chunk}, 0, id, 12000L, ownerId);
                    ChunkLoaderHelper.addRequest(request);
                }
            }
        }
    }

    @SubscribeEvent
    public static void FallProt(LivingFallEvent event) {
        if (event.getEntity().getItemBySlot(EquipmentSlot.FEET).getItem() == Sitems.INF_UP_BOOTS.get()) {
            event.setDistance(event.getDistance() - 25.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingSpawned(EntityJoinLevelEvent event) {
        if (event != null) {
            Entity entity;
            Object object = event.getEntity();
            if (object instanceof Protector) {
                Protector protector = (Protector)object;
                SporeSavedData.addProtector(protector);
            }
            if ((entity = event.getEntity()) instanceof Proto) {
                Proto proto = (Proto)entity;
                entity = event.getLevel();
                if (entity instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)entity;
                    SporeSavedData.addHivemind(serverLevel, proto);
                }
            }
            if ((object = event.getEntity()) instanceof PathfinderMob) {
                String[] iterations;
                String[] mod;
                PathfinderMob mob = (PathfinderMob)object;
                for (String string : (List)SConfig.SERVER.attack.get()) {
                    if (string.endsWith(":")) {
                        mod = string.split(":");
                        if (!Objects.equals(mod[0], (iterations = mob.getEncodeId().split(":"))[0])) continue;
                        mob.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Infected.class, false));
                        mob.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Calamity.class, false));
                        mob.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Organoid.class, false));
                        continue;
                    }
                    if (!((List)SConfig.SERVER.attack.get()).contains(mob.getEncodeId())) continue;
                    mob.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Infected.class, false));
                    mob.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Calamity.class, false));
                    mob.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)mob, Organoid.class, false));
                }
                for (String string : (List)SConfig.SERVER.flee.get()) {
                    if (string.endsWith(":")) {
                        mod = string.split(":");
                        if (!Objects.equals(mod[0], (iterations = mob.getEncodeId().split(":"))[0])) continue;
                        mob.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal(mob, Infected.class, 6.0f, 1.0, 0.9));
                        mob.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal(mob, UtilityEntity.class, 8.0f, 1.0, 0.9));
                        continue;
                    }
                    if (!((List)SConfig.SERVER.flee.get()).contains(mob.getEncodeId())) continue;
                    mob.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal(mob, Infected.class, 6.0f, 1.0, 0.9));
                    mob.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal(mob, UtilityEntity.class, 8.0f, 1.0, 0.9));
                }
            }
        }
    }

    private static List<EntityType<?>> blacklist() {
        ArrayList values = new ArrayList();
        values.add(Sentities.PLAGUED.get());
        values.add(Sentities.LACERATOR.get());
        values.add(Sentities.BIOBLOOB.get());
        values.add(Sentities.SAUGLING.get());
        return values;
    }

    @SubscribeEvent
    public static void SpawnPlacement(RegisterSpawnPlacementsEvent event) {
        for (DeferredHolder type : Sentities.SPORE_ENTITIES.getEntries()) {
            EntityType entityType = (EntityType)type.get();
            if (HandlerEvents.blacklist().contains(entityType)) continue;
            try {
                event.register(entityType, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, UtilityEntity::checkMonsterInfectedRules, RegisterSpawnPlacementsEvent.Operation.AND);
            }
            catch (Exception e) {
                String id = entityType.getDescriptionId();
                Spore.LOGGER.warn("Could not apply custom placement {}: {}", (Object)id, (Object)e.getMessage());
            }
        }
    }

    @SubscribeEvent
    public static void FishingAnInfectedDrowned(ItemFishedEvent event) {
        if (event != null && Math.random() < 0.05 && event.getHookEntity().isOpenWaterFishing()) {
            InfectedDrowned infectedDrowned = new InfectedDrowned((EntityType<? extends Infected>)Sentities.INF_DROWNED.get(), event.getEntity().level());
            infectedDrowned.moveTo(event.getHookEntity().getX(), event.getHookEntity().getY(), event.getHookEntity().getZ());
            infectedDrowned.setKills(1);
            infectedDrowned.setTarget((LivingEntity)event.getEntity());
            event.getEntity().level().addFreshEntity((Entity)infectedDrowned);
        }
    }

    @SubscribeEvent
    public static void ExplosiveBite(LivingEntityUseItemEvent.Finish event) {
        if (event != null && !event.getEntity().level().isClientSide) {
            LivingEntity entity;
            Item item = event.getItem().getItem();
            if (item == Sitems.ROASTED_TUMOR.get() && Math.random() < 0.2) {
                entity = event.getEntity();
                entity.level().explode(null, entity.getX(), entity.getY(), entity.getZ(), 0.5f, Level.ExplosionInteraction.NONE);
            }
            if (item == Sitems.MILKY_SACK.get()) {
                entity = event.getEntity();
                ArrayList effectsToRemove = new ArrayList();
                entity.getActiveEffects().forEach(mobEffectInstance -> {
                    if (!((MobEffect)mobEffectInstance.getEffect().value()).isBeneficial()) {
                        effectsToRemove.add(mobEffectInstance);
                    }
                });
                effectsToRemove.forEach(mobEffectInstance -> entity.removeEffect(mobEffectInstance.getEffect()));
            }
        }
    }

    @SubscribeEvent
    public static void ProtectFromEffect(MobEffectEvent.Applicable event) {
        LivingEntity living = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (instance != null) {
            if (instance == Seffects.MYCELIUM && Utilities.helmetList().contains(living.getItemBySlot(EquipmentSlot.HEAD).getItem())) {
                event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            }
            if (living.getItemBySlot(EquipmentSlot.HEAD).getItem() == Sitems.INF_UP_HELMET.get() && instance == Seffects.MADNESS && instance.getAmplifier() < 1) {
                event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            }
        }
    }
}

