/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sevents;

import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.BaseEntities.EvolvedInfected;
import com.Harbinger.Spore.Sentities.BaseEntities.Hyper;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BasicInfected.InfectedPlayer;
import com.Harbinger.Spore.Sentities.Hyper.Hvindicator;
import com.Harbinger.Spore.Sentities.Organoids.Proto;
import com.Harbinger.Spore.Sentities.Signal;
import com.Harbinger.Spore.Sentities.Utility.GastGeber;
import com.Harbinger.Spore.Sentities.Utility.InfestedConstruct;
import com.Harbinger.Spore.Sentities.Utility.ScentEntity;
import com.Harbinger.Spore.Sitems.BaseWeapons.DeathRewardingWeapon;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sentities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class Infection {
    public static void setItemBySlot(Player player, EquipmentSlot slot, Mob entity) {
        entity.setItemSlot(slot, player.getItemBySlot(slot));
        entity.setDropChance(slot, 0.0f);
    }

    public static void onEntityDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity;
        ItemStack stack;
        Item item;
        LivingEntity entity = event.getEntity();
        if (entity.level().isClientSide) {
            return;
        }
        Level level = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        Entity entity2 = event.getSource().getEntity();
        if (entity2 instanceof LivingEntity && (item = (stack = (livingEntity = (LivingEntity)entity2).getMainHandItem()).getItem()) instanceof DeathRewardingWeapon) {
            DeathRewardingWeapon weapon = (DeathRewardingWeapon)item;
            weapon.computeAfterEffect(entity, livingEntity, stack);
        }
        if (entity instanceof Infected) {
            Infected infected = (Infected)entity;
            if (((Boolean)SConfig.SERVER.scent_spawn.get()).booleanValue() && infected.getTicksFrozen() <= 0 && level instanceof ServerLevel) {
                AABB area;
                List scents;
                ServerLevel serverLevel = (ServerLevel)level;
                if (Math.random() < (double)((float)((Integer)SConfig.SERVER.scent_spawn_chance.get()).intValue() / 100.0f) && (scents = level.getEntitiesOfClass(ScentEntity.class, area = infected.getBoundingBox().inflate(16.0))).size() < (Integer)SConfig.SERVER.scent_cap.get()) {
                    ScentEntity scent = new ScentEntity(Sentities.SCENT.get(), (Level)serverLevel);
                    scent.setOvercharged(infected.getLinked());
                    scent.moveTo(x, y + 4.0, z, level.getRandom().nextFloat() * 360.0f, 0.0f);
                    level.addFreshEntity((Entity)scent);
                }
            }
        }
        if (entity instanceof EvolvedInfected) {
            EvolvedInfected evolved = (EvolvedInfected)entity;
            if (Math.random() < 0.2) {
                AreaEffectCloud cloud = new AreaEffectCloud(level, x, y, z);
                cloud.setRadius(2.5f);
                cloud.setRadiusOnUse(-0.5f);
                cloud.setWaitTime(10);
                cloud.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 40, 0));
                cloud.setDuration(cloud.getDuration() / 2);
                cloud.setRadiusPerTick(-cloud.getRadius() / (float)cloud.getDuration());
                level.addFreshEntity((Entity)cloud);
                AABB alertBox = evolved.getBoundingBox().inflate(30.0);
                List nearby = level.getEntities((Entity)evolved, alertBox);
                for (Entity e : nearby) {
                    if (!(e instanceof Infected)) continue;
                    Infected ally = (Infected)e;
                    ally.setSearchPos(new BlockPos((int)x, (int)y, (int)z));
                }
            }
        }
        if (entity instanceof Infected) {
            Infected inf = (Infected)entity;
            if (event.getSource().getEntity() != null && inf.getLinked()) {
                double chance = (Double)SConfig.SERVER.proto_calamity.get() / 100.0;
                if (inf instanceof EvolvedInfected && Math.random() < chance) {
                    Infection.callProto((Entity)inf);
                }
                if (inf instanceof Hyper && Math.random() < chance * 2.0) {
                    Infection.callProto((Entity)inf);
                }
                if (inf instanceof GastGeber && Math.random() < chance * 4.0) {
                    Infection.callProto((Entity)inf);
                }
            }
        }
        if (entity instanceof Player && (player = (Player)entity).hasEffect(Seffects.MYCELIUM) && ((Boolean)SConfig.SERVER.inf_player.get()).booleanValue()) {
            InfectedPlayer infectedPlayer = new InfectedPlayer(Sentities.INF_PLAYER.get(), level);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR && slot.getType() != EquipmentSlot.Type.HAND) continue;
                Infection.setItemBySlot(player, slot, (Mob)infectedPlayer);
            }
            infectedPlayer.setSkin();
            infectedPlayer.moveTo(x, y, z);
            infectedPlayer.setCustomName(player.getName());
            level.addFreshEntity((Entity)infectedPlayer);
        }
        if (entity.hasEffect(Seffects.MYCELIUM) && !(entity instanceof Player) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (String entry : (List)SConfig.SERVER.inf_human_conv.get()) {
                Entity result;
                ResourceLocation id;
                EntityType<?> type;
                String[] parts = entry.split("\\|");
                if (parts.length < 2 || (type = Utilities.tryToCreateEntity(id = ResourceLocation.parse((String)parts[1]))) == null || !parts[0].equals(entity.getEncodeId()) || (result = type.create((Level)serverLevel)) == null) continue;
                result.setCustomName(entity.getCustomName());
                result.setPos(entity.position());
                if (result instanceof Mob) {
                    Mob mob = (Mob)result;
                    mob.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.CONVERSION, null);
                }
                if (result instanceof Infected) {
                    Infected converted = (Infected)result;
                    converted.setOrigin(entity.getEncodeId());
                }
                serverLevel.addFreshEntity(result);
                entity.discard();
                break;
            }
            if (entity instanceof IronGolem) {
                IronGolem golem = (IronGolem)entity;
                if (Math.random() < (Double)SConfig.SERVER.machine_infestation.get() / 100.0) {
                    InfestedConstruct construct = new InfestedConstruct(Sentities.INF_CONSTRUCT.get(), (Level)serverLevel);
                    construct.setPos(golem.position());
                    construct.setHealth(10.0f);
                    construct.setMachineHealth(0.0f);
                    construct.setActive(false);
                    construct.setCustomName(golem.getCustomName());
                    serverLevel.addFreshEntity((Entity)construct);
                    golem.discard();
                }
            }
        }
        Infection.giveRewards(event.getSource().getEntity(), entity);
        Infection.awardHivemind(event.getSource().getEntity(), entity);
    }

    private static void callProto(Entity entity) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        List<Proto> protos = SporeSavedData.getHiveminds(serverLevel);
        if (!protos.isEmpty()) {
            for (Proto proto : protos) {
                if (!(proto.distanceTo(entity) <= (float)((Integer)SConfig.SERVER.proto_range.get()).intValue())) continue;
                proto.setSignal(new Signal(true, BlockPos.containing((Position)entity.position())));
                break;
            }
        }
    }

    private static void giveRewards(Entity source, LivingEntity victim) {
        if (source instanceof Hvindicator) {
            Hvindicator hv = (Hvindicator)source;
            hv.awardSkull(victim);
        }
    }

    private static void awardHivemind(Entity source, LivingEntity victim) {
        Entity summoner;
        Mob mob;
        CompoundTag data;
        if (source instanceof Mob && (data = (mob = (Mob)source).getPersistentData()).contains("hivemind") && (summoner = mob.level().getEntity(data.getInt("hivemind"))) instanceof Proto) {
            Proto proto = (Proto)summoner;
            int decision = data.getInt("decision");
            proto.adjustWeightsForDecision(decision, 0.1);
        }
    }
}

