/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sevents;

import com.Harbinger.Spore.Effect.SporeEffectsHandler;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorData;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsBaseItem;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Senchantments;
import com.Harbinger.Spore.core.Ssounds;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class LivingTickEvent {
    private static final TagKey<Block> tag = BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"spore:fungal_blocks"));

    public static void TickEvents(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        for (MobEffectInstance instance : living.getActiveEffects()) {
            SporeEffectsHandler handler;
            int amp = instance.getAmplifier();
            MobEffect effect = (MobEffect)instance.getEffect().value();
            if (!(effect instanceof SporeEffectsHandler) || !(handler = (SporeEffectsHandler)effect).isDurationEffectTick(instance.getDuration(), amp)) continue;
            handler.triggerEffects(living, amp);
        }
        if (living instanceof Player) {
            int level;
            Player player = (Player)living;
            MobEffectInstance effectInstance = player.getEffect(Seffects.MADNESS);
            if (effectInstance != null && effectInstance.getDuration() == 1 && (level = effectInstance.getAmplifier()) > 0) {
                effectInstance.update(new MobEffectInstance(Seffects.MADNESS, 12000, level - 1));
            }
            if (player.tickCount % 400 == 0 && player.level().isClientSide) {
                AABB aabb = player.getBoundingBox().inflate(5.0);
                ArrayList list = new ArrayList();
                BlockPos.betweenClosedStream((AABB)aabb).forEach(blockPos -> {
                    BlockPos immutablePos = blockPos.immutable();
                    if (player.level().getBlockState(immutablePos).is(tag)) {
                        list.add(immutablePos);
                    }
                });
                if (list.size() > 4) {
                    player.playSound(Ssounds.AREA_AMBIENT.get());
                }
            }
        }
    }

    public static void TickEffects(PlayerTickEvent.Pre event) {
        MobEffectInstance symbiosis;
        MobEffectInstance corrosion;
        Player player = event.getEntity();
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (player.tickCount % 60 == 0 && (corrosion = player.getEffect(Seffects.CORROSION)) != null) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                SporeArmorData data;
                ItemStack stack;
                if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR || (stack = player.getItemBySlot(slot)).isEmpty() || !stack.isDamageableItem()) continue;
                Item item = stack.getItem();
                if (item instanceof SporeArmorData && !(data = (SporeArmorData)item).tooHurt(stack)) {
                    return;
                }
                int newDamage = stack.getDamageValue() + corrosion.getAmplifier() + 1;
                if (newDamage >= stack.getMaxDamage() || newDamage == stack.getDamageValue()) continue;
                stack.setDamageValue(newDamage);
            }
        }
        if (player.tickCount % 200 == 0 && (symbiosis = player.getEffect(Seffects.SYMBIOSIS)) != null) {
            int healAmount = (symbiosis.getAmplifier() + 1) * 2;
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack stack = player.getInventory().getItem(i);
                if (!LivingTickEvent.shouldHealStack(player, stack)) continue;
                Item item = stack.getItem();
                if (item instanceof SporeToolsBaseItem) {
                    SporeToolsBaseItem base = (SporeToolsBaseItem)item;
                    base.healTool(stack, healAmount);
                } else {
                    item = stack.getItem();
                    if (item instanceof SporeArmorData) {
                        SporeArmorData base = (SporeArmorData)item;
                        base.healTool(stack, healAmount);
                    }
                }
                int newDamage = Math.max(0, stack.getDamageValue() - healAmount);
                stack.setDamageValue(newDamage);
            }
        }
    }

    private static boolean shouldHealStack(Player player, ItemStack stack) {
        return !stack.isEmpty() && stack.isDamaged() && Senchantments.hasEnchant((LevelAccessor)player.level(), stack, Senchantments.SYMBIOTIC_RECONSTITUTION);
    }
}

