/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems.Agents;

import com.Harbinger.Spore.Client.ClientModEvents;
import com.Harbinger.Spore.Sitems.BaseItem2;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Sitems;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public abstract class AbstractSyringe
extends BaseItem2 {
    public AbstractSyringe() {
        super(new Item.Properties().stacksTo(16));
        Sitems.TINTABLE_ITEMS.add(this);
    }

    public abstract int getColor();

    public UseAnim getUseAnimation(ItemStack p_43417_) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack p_43419_) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (level.isClientSide) {
                ClientModEvents.openInjectionScreen(player);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity living, InteractionHand hand) {
        this.useSyringe(stack, living);
        return super.interactLivingEntity(stack, player, living, hand);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity living, int value) {
        if (this.getUseDuration(stack) - value > 40) {
            this.useSyringe(stack, living);
        }
        super.releaseUsing(stack, level, living, value);
    }

    public abstract void useSyringe(ItemStack var1, LivingEntity var2);

    protected void addMycelium(LivingEntity living) {
        living.playSound(Ssounds.SYRINGE_INJECT.get(), 1.0f, 1.0f);
        living.addEffect(new MobEffectInstance(Seffects.MYCELIUM, 300, 0));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"universal_shift_rightclick").withStyle(ChatFormatting.YELLOW));
    }
}

