/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems.Agents;

import com.Harbinger.Spore.Sitems.Agents.AbstractSyringe;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorData;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorMutations;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class ArmorSyringe
extends AbstractSyringe {
    private final SporeArmorMutations mutations;

    public ArmorSyringe(SporeArmorMutations mutations) {
        this.mutations = mutations;
    }

    @Override
    public int getColor() {
        return this.mutations.getColor();
    }

    @Override
    public void useSyringe(ItemStack stack, LivingEntity living) {
        switch (this.mutations) {
            case REINFORCED: {
                living.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 200, 1));
                break;
            }
            case SKELETAL: {
                living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 400, 1));
                break;
            }
            case DROWNED: {
                living.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 600, 0));
                break;
            }
            case CHARRED: {
                living.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 600, 0));
            }
        }
        stack.shrink(1);
        this.addMycelium(living);
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction clickAction, Player player) {
        ItemStack itemStack = slot.getItem();
        Item item = itemStack.getItem();
        if (item instanceof SporeArmorData) {
            SporeArmorData weaponData = (SporeArmorData)item;
            if (clickAction == ClickAction.SECONDARY) {
                player.playNotifySound(Ssounds.SYRINGE_INJECT.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                weaponData.setVariant(this.mutations, itemStack);
                stack.shrink(1);
                return true;
            }
        }
        return false;
    }

    public SporeArmorMutations getMutations() {
        return this.mutations;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.mutation").getString() + Component.translatable((String)this.mutations.getName()).getString())));
    }
}

