/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems.Agents;

import com.Harbinger.Spore.Sitems.Agents.AbstractSyringe;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class WeaponSyringe
extends AbstractSyringe {
    private final SporeToolsMutations mutations;

    public WeaponSyringe(SporeToolsMutations mutations) {
        this.mutations = mutations;
    }

    @Override
    public int getColor() {
        return this.mutations.getColor();
    }

    @Override
    public void useSyringe(ItemStack stack, LivingEntity living) {
        switch (this.mutations) {
            case VAMPIRIC: {
                living.heal(4.0f);
                living.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 400, 1));
                break;
            }
            case CALCIFIED: {
                living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 600, 0));
                break;
            }
            case BEZERK: {
                living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 400, 0));
                living.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 200, 0));
                break;
            }
            case TOXIC: {
                living.addEffect(new MobEffectInstance(MobEffects.POISON, 300, 0));
                break;
            }
            case ROTTEN: {
                living.addEffect(new MobEffectInstance(MobEffects.WITHER, 300, 0));
            }
        }
        stack.shrink(1);
        this.addMycelium(living);
    }

    public SporeToolsMutations getMutations() {
        return this.mutations;
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction clickAction, Player player) {
        ItemStack itemStack = slot.getItem();
        Item item = itemStack.getItem();
        if (item instanceof SporeWeaponData) {
            SporeWeaponData weaponData = (SporeWeaponData)item;
            if (clickAction == ClickAction.SECONDARY) {
                player.playNotifySound(Ssounds.SYRINGE_INJECT.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
                weaponData.setVariant(this.mutations, itemStack);
                stack.shrink(1);
                return true;
            }
        }
        return false;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.mutation").getString() + Component.translatable((String)this.mutations.getName()).getString())));
    }
}

