/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems.BaseWeapons;

import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorMutations;
import com.Harbinger.Spore.core.SdataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface SporeArmorData {
    default public boolean tooHurt(ItemStack stack) {
        return stack.getDamageValue() < stack.getMaxDamage() - 10;
    }

    default public double calculateTrueDefense(ItemStack stack, double defense) {
        double value = this.getAdditionalProtection(stack) * 0.01;
        if (value > 0.0) {
            return defense + defense * value;
        }
        return defense;
    }

    default public void setAdditionalProtection(double value, ItemStack stack) {
        stack.set(SdataComponents.ADDITIONAL_PROTECTION.get(), (Object)Float.valueOf((float)value));
    }

    default public double getAdditionalProtection(ItemStack itemStack) {
        return ((Float)itemStack.getOrDefault(SdataComponents.ADDITIONAL_PROTECTION.get(), (Object)Float.valueOf(0.0f))).floatValue();
    }

    default public double calculateTrueToughness(ItemStack stack, double defense) {
        double value = this.getAdditionalToughness(stack) * 0.01;
        if (value > 0.0) {
            return defense + defense * value;
        }
        return defense;
    }

    default public void setAdditionalToughness(double value, ItemStack stack) {
        stack.set(SdataComponents.ADDITIONAL_TOUGHNESS.get(), (Object)Float.valueOf((float)value));
    }

    default public double getAdditionalToughness(ItemStack itemStack) {
        return ((Float)itemStack.getOrDefault(SdataComponents.ADDITIONAL_TOUGHNESS.get(), (Object)Float.valueOf(0.0f))).floatValue();
    }

    default public void setLuck(int value, ItemStack stack) {
        stack.set(SdataComponents.ENCHANTING_LUCK.get(), (Object)value);
    }

    default public int getLuck(ItemStack itemStack) {
        return (Integer)itemStack.getOrDefault(SdataComponents.ENCHANTING_LUCK.get(), (Object)0);
    }

    default public SporeArmorMutations getVariant(ItemStack stack) {
        return SporeArmorMutations.byId(this.getTypeVariant(stack) & 0xFF);
    }

    default public int getTypeVariant(ItemStack stack) {
        return (Integer)stack.getOrDefault(SdataComponents.ARMOR_MUTATION.get(), (Object)0);
    }

    default public void setVariant(SporeArmorMutations variant, ItemStack stack) {
        stack.set(SdataComponents.ARMOR_MUTATION.get(), (Object)(variant.getId() & 0xFF));
    }

    default public void healTool(ItemStack stack, int value) {
        if (stack.getDamageValue() < stack.getMaxDamage()) {
            stack.setDamageValue(stack.getDamageValue() - value);
        }
        if (this.getMaxTrueAdditionalDurability(stack) > this.getAdditionalDurability(stack)) {
            this.setAdditionalDurability(this.getAdditionalDurability(stack) + value, stack);
        }
    }

    default public int getMaxTrueAdditionalDurability(ItemStack stack) {
        return (int)((double)stack.getMaxDamage() * ((double)this.getMaxAdditionalDurability(stack) * 0.01));
    }

    default public int getMaxAdditionalDurability(ItemStack stack) {
        return (Integer)stack.getOrDefault(SdataComponents.MAX_ADDITIONAL_DURABILITY.get(), (Object)0);
    }

    default public void setMaxAdditionalDurability(int value, ItemStack stack) {
        stack.set(SdataComponents.MAX_ADDITIONAL_DURABILITY.get(), (Object)value);
    }

    default public int getAdditionalDurability(ItemStack stack) {
        return (Integer)stack.getOrDefault(SdataComponents.EXTRA_DURABILITY.get(), (Object)0);
    }

    default public void setAdditionalDurability(int value, ItemStack stack) {
        stack.set(SdataComponents.EXTRA_DURABILITY.get(), (Object)value);
    }

    default public void hurtExtraDurability(ItemStack stack, int value, @Nullable LivingEntity living) {
        this.setAdditionalDurability(this.getAdditionalDurability(stack) - value, stack);
    }
}

