/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems.BaseWeapons;

import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorData;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorMutations;
import com.Harbinger.Spore.core.Senchantments;
import com.Harbinger.Spore.core.Sitems;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SporeBaseArmor
extends ArmorItem
implements SporeArmorData {
    protected static final ResourceLocation[] BASE_ARMOR_ID = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"base_armor_boots"), ResourceLocation.withDefaultNamespace((String)"base_armor_leggings"), ResourceLocation.withDefaultNamespace((String)"base_armor_chestplate"), ResourceLocation.withDefaultNamespace((String)"base_armor_helmet")};
    protected static final ResourceLocation[] BASE_TOUGHNESS_ID = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"base_toughness_boots"), ResourceLocation.withDefaultNamespace((String)"base_toughness_leggings"), ResourceLocation.withDefaultNamespace((String)"base_toughness_chestplate"), ResourceLocation.withDefaultNamespace((String)"base_toughness_helmet")};
    protected static final ResourceLocation[] BASE_KNOCKBACK_ID = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"base_knockback_boots"), ResourceLocation.withDefaultNamespace((String)"base_knockback_leggings"), ResourceLocation.withDefaultNamespace((String)"base_knockback_chestplate"), ResourceLocation.withDefaultNamespace((String)"base_knockback_helmet")};
    protected static final ResourceLocation[] BASE_SPEED_ID = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"base_speed_boots"), ResourceLocation.withDefaultNamespace((String)"base_speed_leggings"), ResourceLocation.withDefaultNamespace((String)"base_speed_chestplate"), ResourceLocation.withDefaultNamespace((String)"base_speed_helmet")};
    protected static final ResourceLocation[] BASE_SWIM_ID = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"base_swim_boots"), ResourceLocation.withDefaultNamespace((String)"base_swim_leggings"), ResourceLocation.withDefaultNamespace((String)"base_swim_chestplate"), ResourceLocation.withDefaultNamespace((String)"base_swim_helmet")};
    protected static final ResourceLocation[] BASE_STEP_ID = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"base_step_boots"), ResourceLocation.withDefaultNamespace((String)"base_step_leggings"), ResourceLocation.withDefaultNamespace((String)"base_step_chestplate"), ResourceLocation.withDefaultNamespace((String)"base_step_helmet")};
    protected final int[] protection;
    protected final float toughness;
    protected float knockback;

    public SporeBaseArmor(ArmorItem.Type type, int[] durability, int[] protection, float toughness, float knockback) {
        super(ArmorMaterials.LEATHER, type, new Item.Properties().durability(durability[type.getSlot().getIndex()]));
        Sitems.TINTABLE_ITEMS.add((Item)this);
        Sitems.BIOLOGICAL_ITEMS.add((Item)this);
        this.protection = protection;
        this.toughness = toughness;
        this.knockback = knockback;
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return this.tooHurt(stack) ? this.getDynamicAttributeModifiers(stack) : super.getDefaultAttributeModifiers(stack);
    }

    public ItemAttributeModifiers getDynamicAttributeModifiers(ItemStack stack) {
        EquipmentSlot slot = this.type.getSlot();
        int index = this.type.getSlot().getIndex();
        double baseArmor = this.calculateTrueDefense(stack, this.protection[index]) + this.modifyProtection(stack, this.protection[index]);
        double baseToughness = this.calculateTrueToughness(stack, this.toughness) + this.modifyToughness(stack, this.toughness);
        double knockbackRes = (double)this.knockback + this.modifyKnockbackResistance(stack, this.knockback);
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder().add(Attributes.ARMOR, new AttributeModifier(BASE_ARMOR_ID[index], baseArmor, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)slot)).add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(BASE_TOUGHNESS_ID[index], baseToughness, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)slot));
        if (knockbackRes > 0.0) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(BASE_KNOCKBACK_ID[index], knockbackRes * (double)0.1f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)slot));
        }
        if (this.getVariant(stack) == SporeArmorMutations.DROWNED) {
            builder.add(NeoForgeMod.SWIM_SPEED, new AttributeModifier(BASE_SWIM_ID[index], 0.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.bySlot((EquipmentSlot)slot));
        }
        if (this.getVariant(stack) == SporeArmorMutations.REINFORCED || this.getVariant(stack) == SporeArmorMutations.SKELETAL) {
            double speedMod = this.getVariant(stack) == SporeArmorMutations.REINFORCED ? -0.01 : 0.01;
            builder.add(Attributes.MOVEMENT_SPEED, new AttributeModifier(BASE_SPEED_ID[index], speedMod, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), EquipmentSlotGroup.bySlot((EquipmentSlot)slot));
        }
        return builder.build();
    }

    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        return ResourceLocation.parse((String)"spore:textures/entity/empty.png");
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<Item> onBroken) {
        int durabilityLeft = stack.getMaxDamage() - stack.getDamageValue();
        if (durabilityLeft - amount <= 11 && entity != null) {
            entity.playSound(Ssounds.INFECTED_GEAR_BREAK.get());
        }
        if (this.tooHurt(stack)) {
            if (this.getAdditionalDurability(stack) > 0) {
                this.hurtExtraDurability(stack, amount, entity);
                return amount;
            }
            return super.damageItem(stack, this.calculateDurabilityLost(stack, amount), entity, onBroken);
        }
        return 0;
    }

    public void tickArmor(Player living, Level level) {
    }

    public int calculateDurabilityLost(ItemStack stack, int value) {
        if (this.getVariant(stack) == SporeArmorMutations.CHARRED) {
            return value * 2;
        }
        return value;
    }

    public Holder<SoundEvent> getEquipSound() {
        return Holder.direct((Object)Ssounds.INFECTED_GEAR_EQUIP.get());
    }

    public int getEnchantmentValue(ItemStack stack) {
        int luck = this.getLuck(stack);
        return luck > 0 ? luck : 1;
    }

    public double modifyProtection(ItemStack stack, double value) {
        if (this.getVariant(stack) == SporeArmorMutations.REINFORCED) {
            return value * (double)0.2f;
        }
        if (this.getVariant(stack) == SporeArmorMutations.SKELETAL) {
            return value * (double)-0.2f;
        }
        return 0.0;
    }

    public double modifyToughness(ItemStack stack, double value) {
        if (this.getVariant(stack) == SporeArmorMutations.SKELETAL) {
            return 1.0;
        }
        return 0.0;
    }

    public double modifyKnockbackResistance(ItemStack stack, double value) {
        return 0.0;
    }

    public float calculateAdditionalDamage(DamageSource source, ItemStack stack, float value) {
        if (this.getVariant(stack) == SporeArmorMutations.CHARRED && source.is(DamageTypeTags.IS_FIRE)) {
            return -value * 0.25f;
        }
        if (this.getVariant(stack) == SporeArmorMutations.DROWNED && source.is(DamageTypeTags.IS_FIRE)) {
            return value * 0.25f;
        }
        return 0.0f;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, components, tooltipFlag);
        if (!this.tooHurt(stack)) {
            components.add((Component)Component.translatable((String)"spore.item.hurt").withStyle(ChatFormatting.RED));
        }
        if (Screen.hasShiftDown()) {
            if (this.getAdditionalProtection(stack) > 0.0) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.armor_increase").getString() + this.getAdditionalProtection(stack) + "%")));
            }
            if (this.getAdditionalToughness(stack) > 0.0) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.toughness_increase").getString() + this.getAdditionalToughness(stack) + "%")));
            }
            if (this.getMaxAdditionalDurability(stack) > 0) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.durability_increase").getString() + this.getMaxAdditionalDurability(stack) + "%")));
            }
            if (this.getAdditionalDurability(stack) > 0) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.additional_durability").getString() + this.getAdditionalDurability(stack))));
            }
            if (this.getEnchantmentValue(stack) > 0) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.enchant").getString() + this.getEnchantmentValue(stack))));
            }
            if (this.getVariant(stack) != SporeArmorMutations.DEFAULT) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.mutation").getString() + Component.translatable((String)this.getVariant(stack).getName()).getString())));
            }
        }
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack itemStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        boolean shouldOverride;
        if (clickAction == ClickAction.SECONDARY && Senchantments.hasEnchant((LevelAccessor)player.level(), stack, Senchantments.VORACIOUS_MAW) && stack.getDamageValue() > 0) {
            if (itemStack.getFoodProperties((LivingEntity)player) == null) {
                return false;
            }
            stack.setDamageValue(this.getDamage(stack) - 50);
            itemStack.shrink(1);
            player.playNotifySound(SoundEvents.GENERIC_EAT, SoundSource.AMBIENT, 1.0f, 1.0f);
            return true;
        }
        boolean bl = shouldOverride = clickAction == ClickAction.SECONDARY && itemStack.getItem() == Sitems.SYRINGE.get() && this.getVariant(stack) != SporeArmorMutations.DEFAULT;
        if (shouldOverride) {
            this.setVariant(SporeArmorMutations.DEFAULT, stack);
            itemStack.shrink(1);
            player.playNotifySound(Ssounds.SYRINGE_SUCK.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        return shouldOverride;
    }
}

