/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems.BaseWeapons;

import com.Harbinger.Spore.Sitems.BaseItem;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import com.Harbinger.Spore.core.Senchantments;
import com.Harbinger.Spore.core.Sitems;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.extensions.IItemExtension;
import org.jetbrains.annotations.Nullable;

public class SporeToolsBaseItem
extends BaseItem
implements SporeWeaponData,
IItemExtension {
    protected final double meleeDamage;
    protected final double meleeReach;
    protected final double meleeRecharge;
    protected final int miningLevel;
    public static final ResourceLocation BASE_ATTACK_REACH_ID = ResourceLocation.withDefaultNamespace((String)"base_attack_reach");

    public SporeToolsBaseItem(double meleeDamage, double meleeReach, double meleeRecharge, int durability, int miningLevel, Tool toolComponentData) {
        super(new Item.Properties().stacksTo(1).durability(durability).component(DataComponents.TOOL, (Object)toolComponentData));
        this.meleeDamage = meleeDamage;
        this.meleeReach = meleeReach;
        this.meleeRecharge = meleeRecharge;
        this.miningLevel = miningLevel;
        Sitems.TINTABLE_ITEMS.add(this);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack itemStack) {
        return super.isValidRepairItem(stack, itemStack) || itemStack.getItem() == Sitems.BIOMASS.get();
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return this.tooHurt(stack) ? this.getDynamicAttributeModifiers(stack) : super.getDefaultAttributeModifiers(stack);
    }

    public ItemAttributeModifiers getDynamicAttributeModifiers(ItemStack stack) {
        double extraDamage = this.calculateTrueDamage(stack, this.meleeDamage) + this.modifyDamage(stack, this.meleeDamage);
        double extraRecharge = -this.meleeRecharge + this.modifyRecharge(stack);
        double extraReach = this.meleeReach + this.modifyRange(stack);
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, extraDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, extraRecharge, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(BASE_ATTACK_REACH_ID, extraReach, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public float getDestroySpeed(ItemStack stack, BlockState blockState) {
        return this.tooHurt(stack) ? (float)this.miningLevel : 1.0f;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        int durabilityLeft = stack.getMaxDamage() - stack.getDamageValue();
        if (durabilityLeft - amount <= 11) {
            entity.playSound(Ssounds.INFECTED_GEAR_BREAK.get());
        }
        if (durabilityLeft < 10) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        int luck = this.getLuck(stack);
        return luck > 0 ? luck : 1;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        if (!this.tooHurt(stack) && entity instanceof Player) {
            Player player = (Player)entity;
            player.getCooldowns().addCooldown((Item)this, 60);
        }
        return super.onEntitySwing(stack, entity, hand);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity living, LivingEntity entity) {
        if (this.tooHurt(stack)) {
            this.hurtTool(stack, entity, 1);
        }
        this.doEntityHurtAfterEffects(stack, living, entity);
        return super.hurtEnemy(stack, living, entity);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity living) {
        if (!this.tooHurt(stack)) {
            return false;
        }
        return super.mineBlock(stack, level, state, pos, living);
    }

    public boolean isBarVisible(ItemStack stack) {
        return super.isBarVisible(stack) || this.getAdditionalDurability(stack) > 0;
    }

    public int getBarColor(ItemStack stack) {
        if (this.getAdditionalDurability(stack) > 0) {
            return Mth.hsvToRgb((float)240.0f, (float)100.0f, (float)100.0f);
        }
        return super.getBarColor(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, components, tooltipFlag);
        if (!this.tooHurt(stack)) {
            components.add((Component)Component.translatable((String)"spore.item.hurt").withStyle(ChatFormatting.RED));
        }
        if (Screen.hasShiftDown()) {
            if (this.getAdditionalDamage(stack) > 0.0) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.damage_increase").getString() + this.getAdditionalDamage(stack) + "%")));
            }
            if (this.getMaxAdditionalDurability(stack) > 0) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.durability_increase").getString() + this.getMaxAdditionalDurability(stack) + "%")));
            }
            if (this.getAdditionalDurability(stack) > 0) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.additional_durability").getString() + this.getAdditionalDurability(stack))));
            }
            if (this.getEnchantmentValue(stack) > 1) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.enchant").getString() + this.getEnchantmentValue(stack))));
            }
            if (this.getVariant(stack) != SporeToolsMutations.DEFAULT) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.mutation").getString() + Component.translatable((String)this.getVariant(stack).getName()).getString())));
            }
        }
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack itemStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        boolean shouldOverride;
        if (clickAction == ClickAction.SECONDARY && Senchantments.hasEnchant((LevelAccessor)player.level(), stack, Senchantments.VORACIOUS_MAW) && stack.getDamageValue() > 0) {
            if (itemStack.getFoodProperties((LivingEntity)player) == null) {
                return false;
            }
            stack.setDamageValue(this.getDamage(stack) - 50);
            itemStack.shrink(1);
            player.playNotifySound(SoundEvents.GENERIC_EAT, SoundSource.AMBIENT, 1.0f, 1.0f);
            return true;
        }
        boolean bl = shouldOverride = clickAction == ClickAction.SECONDARY && itemStack.getItem() == Sitems.SYRINGE.get() && this.getVariant(stack) != SporeToolsMutations.DEFAULT;
        if (shouldOverride) {
            this.setVariant(SporeToolsMutations.DEFAULT, stack);
            itemStack.shrink(1);
            player.playNotifySound(Ssounds.SYRINGE_SUCK.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        return shouldOverride;
    }
}

