/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems.BaseWeapons;

import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsMutations;
import com.Harbinger.Spore.core.SdataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.Nullable;

public interface SporeWeaponData {
    default public boolean tooHurt(ItemStack stack) {
        return stack.getDamageValue() < stack.getMaxDamage() - 10;
    }

    default public double calculateTrueDamage(ItemStack stack, double meleeDamage) {
        double value = this.getAdditionalDamage(stack) * 0.01;
        if (value > 0.0) {
            return meleeDamage + meleeDamage * value;
        }
        return meleeDamage;
    }

    default public void setAdditionalDamage(double value, ItemStack stack) {
        stack.set(SdataComponents.ADDITIONAL_DAMAGE.get(), (Object)Float.valueOf((float)value));
    }

    default public double getAdditionalDamage(ItemStack itemStack) {
        return ((Float)itemStack.getOrDefault(SdataComponents.ADDITIONAL_DAMAGE.get(), (Object)Float.valueOf(0.0f))).floatValue();
    }

    default public int getMaxAdditionalDurability(ItemStack stack) {
        return (Integer)stack.getOrDefault(SdataComponents.MAX_ADDITIONAL_DURABILITY.get(), (Object)0);
    }

    default public void setMaxAdditionalDurability(int value, ItemStack stack) {
        stack.set(SdataComponents.MAX_ADDITIONAL_DURABILITY.get(), (Object)value);
    }

    default public int getAdditionalDurability(ItemStack stack) {
        return (Integer)stack.getOrDefault(SdataComponents.WEAPON_EXTRA_DURABILITY.get(), (Object)0);
    }

    default public void setAdditionalDurability(int value, ItemStack stack) {
        stack.set(SdataComponents.WEAPON_EXTRA_DURABILITY.get(), (Object)value);
    }

    default public void hurtTool(ItemStack stack, LivingEntity entity, int value) {
        int lostDurability = this.calculateDurabilityLostForMutations(value, stack);
        if (this.getAdditionalDurability(stack) > 0) {
            this.hurtExtraDurability(stack, lostDurability, entity);
        } else {
            stack.hurtAndBreak(lostDurability, entity, EquipmentSlot.MAINHAND);
        }
    }

    default public int calculateDurabilityLostForMutations(int value, ItemStack stack) {
        if (this.getVariant(stack) == SporeToolsMutations.TOXIC) {
            return value * 2;
        }
        if (this.getVariant(stack) == SporeToolsMutations.ROTTEN) {
            return value * 2;
        }
        return value;
    }

    default public void hurtExtraDurability(ItemStack stack, int value, @Nullable LivingEntity living) {
        this.setAdditionalDurability(this.getAdditionalDurability(stack) - value, stack);
    }

    default public void setLuck(int value, ItemStack stack) {
        stack.set(SdataComponents.ENCHANTING_LUCK.get(), (Object)value);
    }

    default public int getLuck(ItemStack itemStack) {
        return (Integer)itemStack.getOrDefault(SdataComponents.ENCHANTING_LUCK.get(), (Object)0);
    }

    default public SporeToolsMutations getVariant(ItemStack stack) {
        return SporeToolsMutations.byId(this.getTypeVariant(stack) & 0xFF);
    }

    default public int getTypeVariant(ItemStack stack) {
        return (Integer)stack.getOrDefault(SdataComponents.WEAPON_MUTATION.get(), (Object)0);
    }

    default public void setVariant(SporeToolsMutations variant, ItemStack stack) {
        stack.set(SdataComponents.WEAPON_MUTATION.get(), (Object)(variant.getId() & 0xFF));
    }

    default public boolean doesExtraKnockBack() {
        return false;
    }

    default public boolean reversedKnockback() {
        return false;
    }

    default public void doEntityHurtAfterEffects(ItemStack stack, LivingEntity victim, LivingEntity entity) {
        if (this.reversedKnockback()) {
            victim.knockback((double)1.2f, (double)(-Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180)))), (double)Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180))));
        }
        if (this.doesExtraKnockBack()) {
            victim.knockback((double)2.2f, (double)Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180)))));
        }
        if (this.getVariant(stack) == SporeToolsMutations.TOXIC) {
            victim.addEffect(new MobEffectInstance(Utilities.wrapHolder((MobEffect)MobEffects.POISON.value()), 60, 1));
        }
        if (this.getVariant(stack) == SporeToolsMutations.ROTTEN) {
            victim.addEffect(new MobEffectInstance(Utilities.wrapHolder((MobEffect)MobEffects.WITHER.value()), 60, 1));
        }
        if (this.getVariant(stack) == SporeToolsMutations.CALCIFIED) {
            victim.hurtMarked = true;
            double knockback = this.reversedKnockback() ? (double)(-Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180)))) : (double)Mth.sin((float)(entity.getYRot() * ((float)Math.PI / 180)));
            double knockback2 = this.reversedKnockback() ? (double)Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180) * ((float)Math.PI / 180))) : (double)(-Mth.cos((float)(entity.getYRot() * ((float)Math.PI / 180))));
            victim.knockback(1.5, knockback, knockback2);
        }
        if (this.getVariant(stack) == SporeToolsMutations.VAMPIRIC && entity.getHealth() < entity.getMaxHealth()) {
            entity.heal(2.0f);
        }
        if (this.getVariant(stack) == SporeToolsMutations.BEZERK && Math.random() < 0.3) {
            if (Math.random() < 0.5) {
                entity.addEffect(new MobEffectInstance(Utilities.wrapHolder((MobEffect)MobEffects.MOVEMENT_SPEED.value()), 60, 0));
            } else if (Math.random() < 0.5) {
                entity.addEffect(new MobEffectInstance(Utilities.wrapHolder((MobEffect)MobEffects.DAMAGE_BOOST.value()), 60, 0));
            } else {
                entity.addEffect(new MobEffectInstance(Utilities.wrapHolder((MobEffect)MobEffects.SATURATION.value()), 60, 0));
            }
        }
    }

    default public double modifyDamage(ItemStack stack, double value) {
        int[] sharpnessLevel = new int[]{0};
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantment, level) -> {
            if (enchantment.is(Enchantments.SHARPNESS)) {
                sharpnessLevel[0] = level;
            }
        });
        float sharpnessBonus = sharpnessLevel[0] > 0 ? (float)sharpnessLevel[0] * 0.5f + 1.0f : 0.0f;
        return (double)sharpnessBonus + (this.getVariant(stack) == SporeToolsMutations.VAMPIRIC ? this.calculateTrueDamage(stack, value) * -0.2 : 0.0);
    }

    default public double modifyRange(ItemStack stack) {
        return 0.0;
    }

    default public double modifyRecharge(ItemStack stack) {
        return this.getVariant(stack) == SporeToolsMutations.CALCIFIED ? -0.5 : 0.0;
    }

    default public int getMaxTrueAdditionalDurability(ItemStack stack) {
        return (int)((double)stack.getMaxDamage() * ((double)this.getMaxAdditionalDurability(stack) * 0.01));
    }

    default public void healTool(ItemStack stack, int value) {
        if (stack.getDamageValue() < stack.getMaxDamage()) {
            stack.setDamageValue(stack.getDamageValue() - value);
        }
        if (this.getMaxTrueAdditionalDurability(stack) > this.getAdditionalDurability(stack)) {
            this.setAdditionalDurability(this.getAdditionalDurability(stack) + value, stack);
        }
    }

    default public void abstractMutationBuffs(LivingEntity victim, LivingEntity owner, ItemStack stack, SporeWeaponData data) {
        if (data.getVariant(stack) == SporeToolsMutations.TOXIC) {
            victim.addEffect(new MobEffectInstance(Utilities.wrapHolder((MobEffect)MobEffects.POISON.value()), 60, 1));
        }
        if (data.getVariant(stack) == SporeToolsMutations.ROTTEN) {
            victim.addEffect(new MobEffectInstance(Utilities.wrapHolder((MobEffect)MobEffects.WITHER.value()), 60, 1));
        }
        if (data.getVariant(stack) == SporeToolsMutations.VAMPIRIC && owner.getHealth() < owner.getMaxHealth()) {
            owner.heal(2.0f);
        }
        if (data.getVariant(stack) == SporeToolsMutations.BEZERK && Math.random() < 0.3) {
            if (Math.random() < 0.5) {
                owner.addEffect(new MobEffectInstance(Utilities.wrapHolder((MobEffect)MobEffects.MOVEMENT_SPEED.value()), 60, 0));
            } else if (Math.random() < 0.5) {
                owner.addEffect(new MobEffectInstance(Utilities.wrapHolder((MobEffect)MobEffects.DAMAGE_BOOST.value()), 60, 0));
            } else {
                owner.addEffect(new MobEffectInstance(Utilities.wrapHolder((MobEffect)MobEffects.SATURATION.value()), 60, 0));
            }
        }
    }
}

