/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Client.ClientModEvents;
import com.Harbinger.Spore.Sitems.BaseItem;
import com.Harbinger.Spore.core.Senchantments;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class BiologicalReagent
extends BaseItem {
    private final AcceptedTypes type;
    private final ResourceKey<Enchantment> location;
    public static final TagKey<Item> ALL_TYPES = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"enchantable_items"));
    public static final TagKey<Item> WEAPON_TYPES = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"enchantable_weapon_items"));
    public static final TagKey<Item> ARMOR_TYPES_TYPES = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"enchantable_armor_items"));

    public BiologicalReagent(AcceptedTypes types, ResourceKey<Enchantment> location) {
        super(new Item.Properties());
        this.type = types;
        this.location = location;
    }

    public AcceptedTypes getType() {
        return this.type;
    }

    public boolean isFoil(ItemStack p_41453_) {
        return true;
    }

    public ResourceKey<Enchantment> getAppliedEnchantment() {
        return this.location;
    }

    public boolean testSlotCompat(ItemStack stack) {
        if (this.type == AcceptedTypes.ALL_TYPES) {
            return stack.is(ALL_TYPES);
        }
        if (this.type == AcceptedTypes.WEAPON_TYPES) {
            return stack.is(WEAPON_TYPES);
        }
        if (this.type == AcceptedTypes.ARMOR_TYPES) {
            return stack.is(ARMOR_TYPES_TYPES);
        }
        return false;
    }

    private double chance() {
        return 0.2;
    }

    public boolean overrideStackedOnOther(ItemStack itemStack, Slot slot, ClickAction clickAction, Player player) {
        ItemStack stack = slot.getItem();
        Level accessor = player.level();
        if (this.testSlotCompat(stack) && !Senchantments.hasEnchant((LevelAccessor)accessor, itemStack, this.getAppliedEnchantment()) && this.getAppliedEnchantment() != null && clickAction == ClickAction.SECONDARY) {
            player.playNotifySound(Ssounds.REAGENT.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            Senchantments.EnchantItem((LevelAccessor)accessor, stack, this.getAppliedEnchantment());
            itemStack.setCount(itemStack.getCount() - 1);
            if (Math.random() < this.chance()) {
                ResourceKey<Enchantment> curse = Senchantments.curses.get(player.getRandom().nextInt(Senchantments.curses.size()));
                Senchantments.EnchantItem((LevelAccessor)accessor, stack, curse);
            }
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, list, tooltipFlag);
        list.add((Component)Component.translatable((String)this.type.getId()).withStyle(ChatFormatting.GOLD));
        list.add((Component)Component.translatable((String)"item.reagent.line1"));
        list.add((Component)Component.translatable((String)("enchantment." + this.getAppliedEnchantment().location().toLanguageKey())));
        list.add((Component)Component.translatable((String)"item.reagent.line2").withStyle(ChatFormatting.BLACK));
        list.add((Component)Component.translatable((String)"universal_shift_rightclick").withStyle(ChatFormatting.YELLOW));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.isShiftKeyDown() && level.isClientSide) {
            ClientModEvents.openInjectionScreen(player);
        }
        ItemStack stack = player.getItemInHand(hand);
        return InteractionResultHolder.success((Object)stack);
    }

    public static enum AcceptedTypes {
        ALL_TYPES("spore.name.reagent_type1"),
        WEAPON_TYPES("spore.name.reagent_type2"),
        ARMOR_TYPES("spore.name.reagent_type3");

        private final String id;

        private AcceptedTypes(String ids) {
            this.id = ids;
        }

        public String getId() {
            return this.id;
        }
    }
}

