/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Sitems.BaseWeapons.SporeBaseArmor;
import com.Harbinger.Spore.Sitems.CustomModelArmorData;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sitems;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;

public class Elytron
extends SporeBaseArmor
implements CustomModelArmorData {
    private final ResourceLocation TEXTURE = ResourceLocation.parse((String)"spore:textures/armor/elytron.png");

    public Elytron(ArmorItem.Type type) {
        super(type, new int[]{0, 0, (Integer)SConfig.SERVER.ely_durability.get(), 0}, new int[]{0, 0, (Integer)SConfig.SERVER.ely_protection.get(), 0}, ((Integer)SConfig.SERVER.ely_toughness.get()).intValue(), (float)((Integer)SConfig.SERVER.ely_knockback_resistance.get()).intValue() / 10.0f);
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return this.TEXTURE;
    }

    public static class InfectedElytron
    extends Elytron {
        public InfectedElytron() {
            super(ArmorItem.Type.CHESTPLATE);
        }

        public boolean isValidRepairItem(ItemStack itemstack, ItemStack repairitem) {
            return Objects.equals(Sitems.BIOMASS.get(), repairitem.getItem());
        }

        public static boolean isFlyEnabled(ItemStack stack) {
            return stack.getDamageValue() < stack.getMaxDamage() - 10;
        }

        public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
            return InfectedElytron.isFlyEnabled(stack);
        }

        public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
            int nextFlightTick;
            if (!entity.level().isClientSide && (nextFlightTick = flightTicks + 1) % 10 == 0) {
                if (nextFlightTick % 20 == 0) {
                    stack.hurtAndBreak(1, entity, EquipmentSlot.CHEST);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        player.causeFoodExhaustion(0.1f);
                    }
                }
                entity.gameEvent((Holder)GameEvent.ELYTRA_GLIDE);
            }
            return true;
        }

        public int getEnchantmentValue() {
            return 2;
        }
    }
}

