/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Sentities.Projectile.ThrownBoomerang;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeSwordBase;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class InfectedBoomerang
extends SporeSwordBase {
    public InfectedBoomerang() {
        super(((Integer)SConfig.SERVER.boomerang_damage.get()).intValue(), 1.0, 3.0, (Integer)SConfig.SERVER.boomerang_durability.get());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && this.tooHurt(stack)) {
            ItemStack thrownCopy = stack.copy();
            ThrownBoomerang boomerang = new ThrownBoomerang(level, (LivingEntity)player, thrownCopy, this.getVariant(stack).getColor());
            boomerang.setPos(player.getEyePosition());
            boomerang.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.0f, 0.75f);
            if (player.getAbilities().instabuild) {
                boomerang.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            level.addFreshEntity((Entity)boomerang);
            level.playSound(null, (Entity)player, Ssounds.INFECTED_WEAPON_THROW.get(), SoundSource.PLAYERS, 1.5f, 0.9f);
            stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }
}

