/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Sitems.InfectedExoskeleton;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class InfectedChestplate
extends InfectedExoskeleton {
    public InfectedChestplate() {
        super(ArmorItem.Type.CHESTPLATE);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, components, tooltipFlag);
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"item.armor.shift").withStyle(ChatFormatting.DARK_RED));
        } else {
            components.add((Component)Component.translatable((String)"item.armor.normal").withStyle(ChatFormatting.GOLD));
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (living.getItemBySlot(EquipmentSlot.CHEST).equals(stack) && living.horizontalCollision && living.isCrouching()) {
            Vec3 currentMovement = living.getDeltaMovement();
            if (currentMovement.y < 0.15) {
                Vec3 climbVec = new Vec3(currentMovement.x, 0.15, currentMovement.z);
                living.setDeltaMovement(climbVec);
            }
        }
    }
}

