/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Client.ClientUtils;
import com.Harbinger.Spore.Sitems.BaseWeapons.DeathRewardingWeapon;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeSwordBase;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Sparticles;
import com.Harbinger.Spore.core.Ssounds;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;

public class InfectedCleaver
extends SporeSwordBase
implements DeathRewardingWeapon {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<EnAndItem> heads = this.getHeads();

    public InfectedCleaver() {
        super(((Integer)SConfig.SERVER.cleaver_damage.get()).intValue(), 2.5, 3.0, (Integer)SConfig.SERVER.cleaver_durability.get());
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 120;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    private List<EnAndItem> getHeads() {
        ArrayList<EnAndItem> values = new ArrayList<EnAndItem>();
        List configList = (List)SConfig.SERVER.cleaver_drops.get();
        if (configList.isEmpty()) {
            LOGGER.warn("[SporeMod] Cleaver drops list is empty or missing in config!");
            return values;
        }
        for (String entry : configList) {
            ResourceLocation itemLoc;
            if (entry == null || entry.isBlank()) {
                LOGGER.warn("[SporeMod] Skipping blank cleaver entry in config.");
                continue;
            }
            String[] parts = entry.split("\\|");
            if (parts.length != 2) {
                LOGGER.warn("[SporeMod] Invalid cleaver drop format '{}'. Expected 'entity|item'.", (Object)entry);
                continue;
            }
            String entityId = parts[0].trim();
            String itemId = parts[1].trim();
            try {
                itemLoc = ResourceLocation.parse((String)itemId);
            }
            catch (Exception e) {
                LOGGER.warn("[SporeMod] Invalid item ID '{}' in cleaver drop '{}'. Skipping.", (Object)itemId, (Object)entry);
                continue;
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(itemLoc);
            if (item == Items.AIR) {
                LOGGER.warn("[SporeMod] Unknown item '{}' in cleaver drop '{}'. Skipping.", (Object)itemLoc, (Object)entry);
                continue;
            }
            try {
                ResourceLocation.parse((String)entityId);
            }
            catch (Exception e) {
                LOGGER.warn("[SporeMod] Invalid entity ID '{}' in cleaver drop '{}'. Skipping.", (Object)entityId, (Object)entry);
                continue;
            }
            values.add(new EnAndItem(entityId, item));
        }
        if (values.isEmpty()) {
            LOGGER.warn("[SporeMod] No valid cleaver drops were parsed from config!");
        }
        return values;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public void computeAfterEffect(LivingEntity victim, LivingEntity source, ItemStack weapon) {
        if (victim.level().isClientSide) {
            return;
        }
        for (EnAndItem item : this.heads) {
            if (!item.id.equals(victim.getEncodeId()) || !(Math.random() < 0.1)) continue;
            this.dropLoot(victim.level(), victim.getX(), victim.getY(), victim.getZ(), new ItemStack((ItemLike)item.item));
            break;
        }
    }

    public void dropLoot(Level level, double x, double y, double z, ItemStack stack) {
        ItemEntity entity = new ItemEntity(level, x, y, z, stack);
        level.addFreshEntity((Entity)entity);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.tooHurt(stack)) {
            player.playNotifySound(Ssounds.CLEAVER_SPIN.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
            player.startUsingItem(hand);
            this.hurtTool(player.getItemInHand(hand), (LivingEntity)player, 1);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public void onUseTick(Level level, LivingEntity entity, ItemStack stack, int count) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int charge = this.getUseDuration(stack, entity) - count;
        if (level.isClientSide) {
            ClientUtils.spinPlayer(player);
        } else if (charge % 5 == 0) {
            double radius = 2.5;
            for (int i = 0; i < 10; ++i) {
                double angle = Math.PI * 2 * (double)i / 10.0;
                double x = player.getX() + radius * Math.cos(angle);
                double z = player.getZ() + radius * Math.sin(angle);
                ((ServerLevel)entity.level()).sendParticles((ParticleOptions)Sparticles.SPORE_SLASH.get(), x, player.getY() + 1.0, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            AABB area = player.getBoundingBox().inflate(3.5, 1.0, 3.5);
            List targets = player.level().getEntitiesOfClass(LivingEntity.class, area, e -> e != player && e.isAlive());
            for (LivingEntity target : targets) {
                this.hurtEnemy(stack, target, (LivingEntity)player);
                target.hurt(player.damageSources().playerAttack(player), (float)((Integer)SConfig.SERVER.cleaver_damage.get()).intValue() / 2.0f);
                target.hurtTime = 10;
                target.invulnerableTime = 10;
            }
        }
        if (count <= 2) {
            player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 200, 0));
            player.getCooldowns().addCooldown((Item)this, 200);
            player.stopUsingItem();
        }
        if (charge % 20 == 0) {
            player.playNotifySound(Ssounds.CLEAVER_SPIN.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        super.onUseTick(level, entity, stack, count);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity living, int p_41415_) {
        super.releaseUsing(stack, level, living, p_41415_);
        if (living instanceof Player) {
            Player player = (Player)living;
            player.getCooldowns().addCooldown((Item)this, 60);
        }
    }

    private record EnAndItem(String id, Item item) {
    }
}

