/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Fluids.BileLiquid;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.SdataComponents;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Senchantments;
import com.Harbinger.Spore.core.Sitems;
import com.Harbinger.Spore.core.Ssounds;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class InfectedCrossbow
extends CrossbowItem
implements SporeWeaponData {
    public InfectedCrossbow() {
        super(new Item.Properties().durability(((Integer)SConfig.SERVER.crossbow_durability.get()).intValue()));
        Sitems.BIOLOGICAL_ITEMS.add((Item)this);
        Sitems.TINTABLE_ITEMS.add((Item)this);
    }

    public boolean isValidRepairItem(ItemStack itemstack, ItemStack repairitem) {
        return Objects.equals(Sitems.BIOMASS.get(), repairitem.getItem());
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        Vector3f vector3f;
        if (target != null) {
            double d0 = target.getX() - shooter.getX();
            double d1 = target.getZ() - shooter.getZ();
            double d2 = Math.sqrt(d0 * d0 + d1 * d1);
            double d3 = target.getY(0.3333333333333333) - projectile.getY() + d2 * (double)0.2f;
            vector3f = InfectedCrossbow.getProjectileShotVector(shooter, new Vec3(d0, d3, d1), angle);
        } else {
            Vec3 vec3 = shooter.getUpVector(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(angle * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
            Vec3 vec31 = shooter.getViewVector(1.0f);
            vector3f = vec31.toVector3f().rotate((Quaternionfc)quaternionf);
        }
        projectile.shoot((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), (float)((double)velocity * (Double)SConfig.SERVER.crossbow_arrow_damage_multiplier.get()), inaccuracy);
        float f = InfectedCrossbow.getShotPitch(shooter.getRandom(), index);
        shooter.level().playSound((Player)null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.CROSSBOW_SHOOT, shooter.getSoundSource(), 1.0f, f);
    }

    protected Projectile createProjectile(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        if (ammo.is(Items.FIREWORK_ROCKET)) {
            return new FireworkRocketEntity(level, ammo, (Entity)shooter, shooter.getX(), shooter.getEyeY() - (double)0.15f, shooter.getZ(), true);
        }
        Projectile projectile = super.createProjectile(level, shooter, weapon, ammo, isCrit);
        if (projectile instanceof AbstractArrow) {
            AbstractArrow abstractArrow = (AbstractArrow)projectile;
            abstractArrow.setSoundEvent(SoundEvents.CROSSBOW_HIT);
            if (abstractArrow instanceof Arrow) {
                Arrow arrow = (Arrow)abstractArrow;
                InfectedCrossbow.abstractEffects(weapon, arrow, shooter.level());
            }
        }
        return projectile;
    }

    private static Vector3f getProjectileShotVector(LivingEntity shooter, Vec3 distance, float angle) {
        Vector3f vector3f = distance.toVector3f().normalize();
        Vector3f vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f1.lengthSquared() <= 1.0E-7) {
            Vec3 vec3 = shooter.getUpVector(1.0f);
            vector3f1 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)vec3.toVector3f());
        }
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f1.x, vector3f1.y, vector3f1.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(angle * ((float)Math.PI / 180), vector3f2.x, vector3f2.y, vector3f2.z);
    }

    private static float getShotPitch(RandomSource random, int index) {
        return index == 0 ? 1.0f : InfectedCrossbow.getRandomShotPitch((index & 1) == 1, random);
    }

    private static float getRandomShotPitch(boolean isHighPitched, RandomSource random) {
        float f = isHighPitched ? 0.63f : 0.43f;
        return 1.0f / (random.nextFloat() * 0.5f + 1.8f) + f;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, components, tooltipFlag);
        if (!this.tooHurt(stack)) {
            components.add((Component)Component.translatable((String)"spore.item.hurt").withStyle(ChatFormatting.RED));
        }
        if (Screen.hasShiftDown()) {
            if (this.getAdditionalDamage(stack) > 0.0) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.damage_increase").getString() + this.getAdditionalDamage(stack) + "%")));
            }
            if (this.getMaxAdditionalDurability(stack) > 0) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.durability_increase").getString() + this.getMaxAdditionalDurability(stack) + "%")));
            }
            if (this.getAdditionalDurability(stack) > 0) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.additional_durability").getString() + this.getAdditionalDurability(stack))));
            }
            if (this.getEnchantmentValue(stack) > 1) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.enchant").getString() + this.getEnchantmentValue(stack))));
            }
            if (this.getVariant(stack) != SporeToolsMutations.DEFAULT) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.mutation").getString() + Component.translatable((String)this.getVariant(stack).getName()).getString())));
            }
        }
    }

    public boolean useOnRelease(ItemStack p_150801_) {
        return p_150801_.is((Item)this);
    }

    public int getDefaultProjectileRange() {
        return 8;
    }

    public int getEnchantmentValue(ItemStack stack) {
        int luck = this.getLuck(stack);
        return luck > 0 ? luck : 1;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        if (!this.tooHurt(stack) && entity instanceof Player) {
            Player player = (Player)entity;
            player.getCooldowns().addCooldown((Item)this, 60);
        }
        return super.onEntitySwing(stack, entity, hand);
    }

    public static void abstractEffects(ItemStack stack, Arrow arrow, Level level) {
        if (Senchantments.hasEnchant((LevelAccessor)level, stack, Senchantments.CORROSIVE_POTENCY)) {
            arrow.addEffect(new MobEffectInstance(Seffects.CORROSION, 200, 1));
        }
        if (Senchantments.hasEnchant((LevelAccessor)level, stack, Senchantments.GASTRIC_SPEWAGE)) {
            for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                arrow.addEffect(instance);
            }
        }
        if (InfectedCrossbow.getMutation(stack) == SporeToolsMutations.TOXIC) {
            arrow.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 0));
        }
        if (InfectedCrossbow.getMutation(stack) == SporeToolsMutations.ROTTEN) {
            arrow.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 1));
        }
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity living, LivingEntity entity) {
        if (this.tooHurt(stack)) {
            this.hurtTool(stack, entity, 1);
        }
        this.doEntityHurtAfterEffects(stack, living, entity);
        return super.hurtEnemy(stack, living, entity);
    }

    private static boolean tooFreakyHurt(ItemStack stack) {
        return stack.getDamageValue() < stack.getMaxDamage() - 10;
    }

    private static SporeToolsMutations getMutation(ItemStack stack) {
        return SporeToolsMutations.byId((Integer)stack.getOrDefault(SdataComponents.WEAPON_MUTATION.get(), (Object)0) & 0xFF);
    }

    private static double calculateTrueDamageCrossBow(ItemStack stack, double meleeDamage) {
        double value = (double)((Float)stack.getOrDefault(SdataComponents.ADDITIONAL_DAMAGE.get(), (Object)Float.valueOf(0.0f))).floatValue() * 0.01;
        if (value > 0.0) {
            return meleeDamage + meleeDamage * value;
        }
        return meleeDamage;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack itemStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        boolean shouldOverride;
        if (clickAction == ClickAction.SECONDARY && Senchantments.hasEnchant((LevelAccessor)player.level(), stack, Senchantments.VORACIOUS_MAW) && stack.getDamageValue() > 0) {
            if (itemStack.getFoodProperties((LivingEntity)player) == null) {
                return false;
            }
            stack.setDamageValue(this.getDamage(stack) - 50);
            itemStack.shrink(1);
            player.playNotifySound(SoundEvents.GENERIC_EAT, SoundSource.AMBIENT, 1.0f, 1.0f);
            return true;
        }
        boolean bl = shouldOverride = clickAction == ClickAction.SECONDARY && itemStack.getItem() == Sitems.SYRINGE.get() && this.getVariant(stack) != SporeToolsMutations.DEFAULT;
        if (shouldOverride) {
            this.setVariant(SporeToolsMutations.DEFAULT, stack);
            itemStack.shrink(1);
            player.playNotifySound(Ssounds.SYRINGE_SUCK.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        return shouldOverride;
    }
}

