/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Fluids.BileLiquid;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeToolsMutations;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Seffects;
import com.Harbinger.Spore.core.Senchantments;
import com.Harbinger.Spore.core.Sitems;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfectedGreatBow
extends BowItem
implements SporeWeaponData {
    private static final ResourceLocation BONUS_REACH_MODIFIER_UUID = ResourceLocation.fromNamespaceAndPath((String)"spore", (String)"attack_reach");

    public InfectedGreatBow() {
        super(new Item.Properties().durability(((Integer)SConfig.SERVER.bow_durability.get()).intValue()));
        Sitems.BIOLOGICAL_ITEMS.add((Item)this);
        Sitems.TINTABLE_ITEMS.add((Item)this);
    }

    public boolean isValidRepairItem(ItemStack itemstack, ItemStack repairitem) {
        return Objects.equals(Sitems.BIOMASS.get(), repairitem.getItem());
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        Player player;
        ItemStack itemstack;
        if (entityLiving instanceof Player && !(itemstack = (player = (Player)entityLiving).getProjectile(stack)).isEmpty()) {
            int i = this.getUseDuration(stack, entityLiving) - timeLeft;
            if ((i = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)i, (!itemstack.isEmpty() ? 1 : 0) != 0)) < 0) {
                return;
            }
            float f = InfectedGreatBow.getPowerForTime((int)i);
            if (!((double)f < 0.1)) {
                List list = InfectedGreatBow.draw((ItemStack)stack, (ItemStack)itemstack, (LivingEntity)player);
                if (level instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)level;
                    if (!list.isEmpty()) {
                        this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), stack, list, f * 3.0f, 1.0f, f == 1.0f, null);
                    }
                }
                level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    protected void shoot(ServerLevel level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, @Nullable LivingEntity target) {
        float f = EnchantmentHelper.processProjectileSpread((ServerLevel)level, (ItemStack)weapon, (Entity)shooter, (float)0.0f);
        float f1 = projectileItems.size() == 1 ? 0.0f : 2.0f * f / (float)(projectileItems.size() - 1);
        float f2 = (float)((projectileItems.size() - 1) % 2) * f1 / 2.0f;
        float f3 = 1.0f;
        for (int i = 0; i < projectileItems.size(); ++i) {
            ItemStack itemstack = projectileItems.get(i);
            if (itemstack.isEmpty()) continue;
            float f4 = f2 + f3 * (float)((i + 1) / 2) * f1;
            f3 = -f3;
            Projectile projectile = this.createProjectile((Level)level, shooter, weapon, itemstack, isCrit);
            if (projectile instanceof Arrow) {
                Arrow arrow = (Arrow)projectile;
                this.abstractEffects(itemstack, arrow, shooter.level());
            }
            this.shootProjectile(shooter, projectile, i, velocity, inaccuracy, f4, target);
            level.addFreshEntity((Entity)projectile);
            weapon.hurtAndBreak(this.getDurabilityUse(itemstack), shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
            if (weapon.isEmpty()) break;
        }
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return this.getDynamicAttributeModifiers(stack);
    }

    public ItemAttributeModifiers getDynamicAttributeModifiers(ItemStack stack) {
        double extraDamage = this.calculateTrueDamage(stack, ((Integer)SConfig.SERVER.bow_melee_damage.get()).intValue()) + this.modifyDamage(stack, ((Integer)SConfig.SERVER.bow_melee_damage.get()).intValue());
        double extraRecharge = -2.4 + this.modifyRecharge(stack);
        double extraReach = 1.0 + this.modifyRange(stack);
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, extraDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, extraRecharge, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(BONUS_REACH_MODIFIER_UUID, extraReach, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public void abstractEffects(ItemStack stack, Arrow arrow, Level level) {
        if (Senchantments.hasEnchant((LevelAccessor)level, stack, Senchantments.CORROSIVE_POTENCY)) {
            arrow.addEffect(new MobEffectInstance(Seffects.CORROSION, 200, 1));
        }
        if (Senchantments.hasEnchant((LevelAccessor)level, stack, Senchantments.GASTRIC_SPEWAGE)) {
            for (MobEffectInstance instance : BileLiquid.bileEffects()) {
                arrow.addEffect(instance);
            }
        }
        if (this.getVariant(stack) == SporeToolsMutations.ROTTEN) {
            arrow.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 0));
        }
        if (this.getVariant(stack) == SporeToolsMutations.TOXIC) {
            arrow.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 1));
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, components, tooltipFlag);
        if (!this.tooHurt(stack)) {
            components.add((Component)Component.translatable((String)"spore.item.hurt").withStyle(ChatFormatting.RED));
        }
        if (Screen.hasShiftDown()) {
            if (this.getAdditionalDamage(stack) > 0.0) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.damage_increase").getString() + this.getAdditionalDamage(stack) + "%")));
            }
            if (this.getMaxAdditionalDurability(stack) > 0) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.durability_increase").getString() + this.getMaxAdditionalDurability(stack) + "%")));
            }
            if (this.getAdditionalDurability(stack) > 0) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.additional_durability").getString() + this.getAdditionalDurability(stack))));
            }
            if (this.getEnchantmentValue(stack) > 1) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.enchant").getString() + this.getEnchantmentValue(stack))));
            }
            if (this.getVariant(stack) != SporeToolsMutations.DEFAULT) {
                components.add((Component)Component.literal((String)(Component.translatable((String)"spore.item.mutation").getString() + Component.translatable((String)this.getVariant(stack).getName()).getString())));
            }
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return super.isBarVisible(stack) || this.getAdditionalDurability(stack) > 0;
    }

    public int getBarColor(ItemStack stack) {
        if (this.getAdditionalDurability(stack) > 0) {
            return Mth.hsvToRgb((float)240.0f, (float)100.0f, (float)100.0f);
        }
        return super.getBarColor(stack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        int luck = this.getLuck(stack);
        return luck > 0 ? luck : 1;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        if (!this.tooHurt(stack) && entity instanceof Player) {
            Player player = (Player)entity;
            player.getCooldowns().addCooldown((Item)this, 60);
        }
        return super.onEntitySwing(stack, entity, hand);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity living, LivingEntity entity) {
        if (this.tooHurt(stack)) {
            this.hurtTool(stack, entity, 1);
        }
        this.doEntityHurtAfterEffects(stack, living, entity);
        return super.hurtEnemy(stack, living, entity);
    }
}

