/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sitems;

import com.Harbinger.Spore.Sentities.Projectile.ThrownKnife;
import com.Harbinger.Spore.Sitems.BaseWeapons.LootModifierWeapon;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeSwordBase;
import com.Harbinger.Spore.core.SConfig;
import com.Harbinger.Spore.core.Ssounds;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class InfectedKnife
extends SporeSwordBase
implements LootModifierWeapon {
    public InfectedKnife() {
        super(((Integer)SConfig.SERVER.knife_damage.get()).intValue(), 0.0, -1.0, (Integer)SConfig.SERVER.knife_durability.get());
    }

    @Override
    public int getLootingLevel() {
        return 1;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.tooHurt(itemstack)) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int T) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int i = this.getUseDuration(stack, entity) - T;
            if (i >= 10 && !level.isClientSide) {
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                ThrownKnife thrownSpear = new ThrownKnife(level, (LivingEntity)player, stack, this.getVariant(stack).getColor());
                thrownSpear.setPos(player.getEyePosition());
                thrownSpear.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.0f, 0.75f);
                if (player.getAbilities().instabuild) {
                    thrownSpear.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                level.addFreshEntity((Entity)thrownSpear);
                level.playSound(null, (Entity)thrownSpear, Ssounds.INFECTED_WEAPON_THROW.get(), SoundSource.PLAYERS, 1.5f, 0.9f);
                if (!player.getAbilities().instabuild) {
                    player.getInventory().removeItem(stack);
                }
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }
}

